/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.client.item;

import com.buuz135.functionalstorage.client.model.FramedDrawerModelData;
import com.buuz135.functionalstorage.item.FSAttachments;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import java.util.HashMap;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;

public abstract class FunctionalStorageISTER
extends BlockEntityWithoutLevelRenderer {
    protected final Int2ObjectMap<ModelData> modelCache = new Int2ObjectArrayMap();

    public FunctionalStorageISTER() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    protected EntityModelSet getEntityModels() {
        return Minecraft.getInstance().getEntityModels();
    }

    protected BlockEntityRenderDispatcher getBlockEntityRenderDispatcher() {
        return Minecraft.getInstance().getBlockEntityRenderDispatcher();
    }

    protected Camera getCamera() {
        return this.getBlockEntityRenderDispatcher().camera;
    }

    public abstract void onResourceManagerReload(@NotNull ResourceManager var1);

    public abstract void renderByItem(HolderLookup.Provider var1, @NotNull ItemStack var2, @NotNull ItemDisplayContext var3, @NotNull PoseStack var4, @NotNull MultiBufferSource var5, int var6, int var7);

    public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
        this.renderByItem((HolderLookup.Provider)Minecraft.getInstance().level.registryAccess(), stack, displayContext, poseStack, buffer, packedLight, packedOverlay);
    }

    protected void renderBlockItem(@NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, @NotNull PoseStack matrix, @NotNull MultiBufferSource renderer, int light, int overlayLight, ModelData modelData) {
        Item item = stack.getItem();
        if (!(item instanceof BlockItem)) {
            return;
        }
        BlockItem blockItem = (BlockItem)item;
        Block block = blockItem.getBlock();
        boolean fabulous = displayContext != ItemDisplayContext.GUI && !displayContext.firstPerson() ? !(block instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock) : true;
        matrix.popPose();
        matrix.pushPose();
        Minecraft minecraft = Minecraft.getInstance();
        ItemRenderer itemRenderer = minecraft.getItemRenderer();
        BlockState defaultState = block.defaultBlockState();
        BakedModel mainModel = minecraft.getModelManager().getBlockModelShaper().getBlockModel(defaultState);
        mainModel = mainModel.applyTransform(displayContext, matrix, FunctionalStorageISTER.isLeftHand(displayContext));
        matrix.translate(-0.5, -0.5, -0.5);
        long seed = 42L;
        RandomSource random = RandomSource.create();
        boolean glint = stack.hasFoil();
        for (BakedModel model : mainModel.getRenderPasses(stack, fabulous)) {
            for (RenderType renderType : model.getRenderTypes(stack, fabulous)) {
                VertexConsumer consumer = null;
                consumer = fabulous ? ItemRenderer.getFoilBufferDirect((MultiBufferSource)renderer, (RenderType)renderType, (boolean)true, (boolean)glint) : ItemRenderer.getFoilBuffer((MultiBufferSource)renderer, (RenderType)renderType, (boolean)true, (boolean)glint);
                for (Direction direction : Direction.values()) {
                    random.setSeed(seed);
                    itemRenderer.renderQuadList(matrix, consumer, model.getQuads(defaultState, direction, random, modelData, null), stack, light, overlayLight);
                }
                random.setSeed(seed);
                itemRenderer.renderQuadList(matrix, consumer, model.getQuads(defaultState, null, random, modelData, null), stack, light, overlayLight);
            }
        }
    }

    protected ModelData getData(ItemStack stack) {
        ModelData modelData = ModelData.EMPTY;
        if (stack.has(FSAttachments.STYLE)) {
            CompoundTag tag = (CompoundTag)stack.get(FSAttachments.STYLE);
            modelData = (ModelData)this.modelCache.computeIfAbsent(tag.hashCode(), o -> {
                HashMap<String, Item> data = new HashMap<String, Item>();
                data.put("particle", (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)tag.getString("particle"))));
                data.put("front", (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)tag.getString("front"))));
                data.put("side", (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)tag.getString("side"))));
                data.put("front_divider", (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)tag.getString("front_divider"))));
                FramedDrawerModelData framedDrawerModelData = new FramedDrawerModelData(data);
                return ModelData.builder().with(FramedDrawerModelData.FRAMED_PROPERTY, (Object)framedDrawerModelData).build();
            });
        }
        return modelData;
    }

    private static boolean isLeftHand(ItemDisplayContext type) {
        return type == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || type == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
    }
}

