/*
 * Decompiled with CFR 0.152.
 */
package com.buuz135.functionalstorage.block.tile;

import com.buuz135.functionalstorage.FunctionalStorage;
import com.buuz135.functionalstorage.block.DrawerBlock;
import com.buuz135.functionalstorage.block.tile.StorageControllerTile;
import com.buuz135.functionalstorage.item.ConfigurationToolItem;
import com.buuz135.functionalstorage.item.FunctionalUpgradeItem;
import com.buuz135.functionalstorage.item.LinkingToolItem;
import com.buuz135.functionalstorage.item.StorageUpgradeItem;
import com.buuz135.functionalstorage.item.UpgradeItem;
import com.hrznstudio.titanium.annotation.Save;
import com.hrznstudio.titanium.block.BasicTileBlock;
import com.hrznstudio.titanium.block.tile.ActiveTile;
import com.hrznstudio.titanium.client.screen.addon.TextScreenAddon;
import com.hrznstudio.titanium.component.inventory.InventoryComponent;
import com.hrznstudio.titanium.util.TileUtil;
import java.util.HashMap;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.items.ItemHandlerHelper;

public abstract class ControllableDrawerTile<T extends ControllableDrawerTile<T>>
extends ActiveTile<T> {
    private boolean needsUpgradeCache = true;
    @Save
    private BlockPos controllerPos;
    @Save
    private InventoryComponent<ControllableDrawerTile<T>> storageUpgrades;
    @Save
    private InventoryComponent<ControllableDrawerTile<T>> utilityUpgrades;
    @Save
    private DrawerOptions drawerOptions = new DrawerOptions();
    @Save
    private boolean hasDowngrade = false;
    @Save
    private boolean isCreative = false;
    @Save
    private boolean isVoid = false;
    @Save
    private boolean isStorageUpgradeLocked = false;
    @Save
    private int mult = 1;

    public ControllableDrawerTile(BasicTileBlock<T> base, BlockEntityType<T> entityType, BlockPos pos, BlockState state) {
        super(base, entityType, pos, state);
        this.storageUpgrades = this.getStorageUpgradesConstructor();
        if (this.getStorageSlotAmount() > 0) {
            this.addInventory(this.storageUpgrades);
        }
        if (this.getUtilitySlotAmount() > 0) {
            this.utilityUpgrades = new InventoryComponent("utility_upgrades", 114, 70, this.getUtilitySlotAmount()).setInputFilter((stack, integer) -> {
                if (stack.is(FunctionalStorage.VOID_UPGRADE)) {
                    for (int i = 0; i < this.utilityUpgrades.getSlots(); ++i) {
                        if (!this.utilityUpgrades.getStackInSlot(i).is(FunctionalStorage.VOID_UPGRADE)) continue;
                        return false;
                    }
                }
                return stack.getItem() instanceof UpgradeItem && ((UpgradeItem)stack.getItem()).getType() == UpgradeItem.Type.UTILITY || stack.getItem() instanceof FunctionalUpgradeItem;
            }).setSlotLimit(1).setOnSlotChanged((itemStack, integer) -> {
                BlockEntity patt0$temp;
                this.needsUpgradeCache = true;
                if (this.controllerPos != null && (patt0$temp = this.level.getBlockEntity(this.controllerPos)) instanceof StorageControllerTile) {
                    StorageControllerTile controllerTile = (StorageControllerTile)patt0$temp;
                    controllerTile.getConnectedDrawers().rebuild();
                }
            });
            this.addInventory(this.utilityUpgrades);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void initClient() {
        super.initClient();
        if (this.getStorageSlotAmount() > 0) {
            this.addGuiAddonFactory(() -> new TextScreenAddon(this, "gui.functionalstorage.storage", 10, 59, false, ChatFormatting.DARK_GRAY.getColor()){

                public String getText() {
                    return Component.translatable((String)"key.categories.storage").getString();
                }
            });
        }
        if (this.getUtilitySlotAmount() > 0) {
            this.addGuiAddonFactory(() -> new TextScreenAddon(this, "gui.functionalstorage.utility", 114, 59, false, ChatFormatting.DARK_GRAY.getColor()){

                public String getText() {
                    return Component.translatable((String)"key.categories.utility").getString();
                }
            });
        }
        this.addGuiAddonFactory(() -> new TextScreenAddon(this, "key.categories.inventory", 8, 92, false, ChatFormatting.DARK_GRAY.getColor()){

            public String getText() {
                return Component.translatable((String)"key.categories.inventory").getString();
            }
        });
    }

    public void serverTick(Level level, BlockPos pos, BlockState state, T blockEntity) {
        Item item;
        ItemStack stack;
        int i;
        super.serverTick(level, pos, state, blockEntity);
        if (level.getGameTime() % 20L == 0L && this.getUtilitySlotAmount() > 0) {
            for (i = 0; i < this.utilityUpgrades.getSlots(); ++i) {
                stack = this.utilityUpgrades.getStackInSlot(i);
                if (stack.isEmpty() || !(item = stack.getItem()).equals(FunctionalStorage.REDSTONE_UPGRADE.get())) continue;
                level.updateNeighborsAt(this.getBlockPos(), (Block)this.getBasicTileBlock());
                break;
            }
        }
        if (this.getUtilitySlotAmount() > 0) {
            for (i = 0; i < this.utilityUpgrades.getSlots(); ++i) {
                stack = this.utilityUpgrades.getStackInSlot(i);
                if (stack.isEmpty() || !((item = stack.getItem()) instanceof FunctionalUpgradeItem)) continue;
                FunctionalUpgradeItem functionalUpgradeItem = (FunctionalUpgradeItem)item;
                functionalUpgradeItem.work(this.level, this.getBlockPos());
            }
        }
    }

    public BlockPos getControllerPos() {
        return this.controllerPos;
    }

    public void setControllerPos(BlockPos controllerPos) {
        if (this.controllerPos != null) {
            TileUtil.getTileEntity((BlockGetter)this.getLevel(), (BlockPos)this.controllerPos, StorageControllerTile.class).ifPresent(drawerControllerTile -> drawerControllerTile.addConnectedDrawers(LinkingToolItem.ActionMode.REMOVE, this.getBlockPos()));
        }
        this.controllerPos = controllerPos;
    }

    public void clearControllerPos() {
        this.controllerPos = null;
    }

    public int getStorageMultiplier() {
        this.maybeCacheUpgrades();
        return this.mult;
    }

    public boolean isVoid() {
        this.maybeCacheUpgrades();
        return this.isVoid;
    }

    public boolean isCreative() {
        this.maybeCacheUpgrades();
        return this.isCreative;
    }

    public double getStorageDiv() {
        return 1.0;
    }

    public void setNeedsUpgradeCache(boolean needsUpgradeCache) {
        this.needsUpgradeCache = needsUpgradeCache;
    }

    public InteractionResult onSlotActivated(Player playerIn, InteractionHand hand, Direction facing, double hitX, double hitY, double hitZ, int slot) {
        Item item;
        ItemStack stack = playerIn.getItemInHand(hand);
        if (stack.getItem().equals(FunctionalStorage.CONFIGURATION_TOOL.get()) || stack.getItem().equals(FunctionalStorage.LINKING_TOOL.get())) {
            return InteractionResult.PASS;
        }
        if (!stack.isEmpty() && (item = stack.getItem()) instanceof UpgradeItem) {
            UpgradeItem upgradeItem = (UpgradeItem)item;
            if (upgradeItem instanceof StorageUpgradeItem || ((Object)((Object)upgradeItem)).equals(FunctionalStorage.CREATIVE_UPGRADE.get())) {
                component = this.storageUpgrades;
                for (int i = 0; i < component.getSlots(); ++i) {
                    if (!component.getStackInSlot(i).isEmpty() || !component.isItemValid(i, stack)) continue;
                    playerIn.setItemInHand(hand, component.insertItem(i, stack, false));
                    return InteractionResult.SUCCESS;
                }
                if (upgradeItem instanceof StorageUpgradeItem) {
                    StorageUpgradeItem storageUpgradeItem = (StorageUpgradeItem)upgradeItem;
                    for (int i = 0; i < component.getSlots(); ++i) {
                        StorageUpgradeItem instertedUpgrade;
                        Item item2;
                        if (component.getStackInSlot(i).isEmpty() || !component.isItemValid(i, stack) || !((item2 = component.getStackInSlot(i).getItem()) instanceof StorageUpgradeItem) || (instertedUpgrade = (StorageUpgradeItem)item2).getStorageMultiplier() >= storageUpgradeItem.getStorageMultiplier()) continue;
                        ItemHandlerHelper.giveItemToPlayer((Player)playerIn, (ItemStack)component.getStackInSlot(i).copy());
                        ItemStack upgradeStack = stack.copy();
                        upgradeStack.setCount(1);
                        component.setStackInSlot(i, upgradeStack);
                        stack.shrink(1);
                        return InteractionResult.SUCCESS;
                    }
                }
            } else {
                component = this.utilityUpgrades;
                for (int i = 0; i < component.getSlots(); ++i) {
                    if (!component.getStackInSlot(i).isEmpty() || !component.isItemValid(i, stack)) continue;
                    playerIn.setItemInHand(hand, component.insertItem(i, stack, false));
                    return InteractionResult.SUCCESS;
                }
            }
        }
        if (stack.getItem() instanceof FunctionalUpgradeItem) {
            InventoryComponent<ControllableDrawerTile<T>> component = this.utilityUpgrades;
            for (int i = 0; i < component.getSlots(); ++i) {
                if (!component.getStackInSlot(i).isEmpty() || !component.isItemValid(i, stack)) continue;
                playerIn.setItemInHand(hand, component.insertItem(i, stack, false));
                return InteractionResult.SUCCESS;
            }
        }
        if (super.onActivated(playerIn, hand, facing, hitX, hitY, hitZ) == ItemInteractionResult.SUCCESS) {
            return InteractionResult.SUCCESS;
        }
        if (slot == -1) {
            this.openGui(playerIn);
        }
        return InteractionResult.SUCCESS;
    }

    public abstract int getStorageSlotAmount();

    public int getUtilitySlotAmount() {
        return 3;
    }

    public void onClicked(Player playerIn, int slot) {
    }

    public abstract int getBaseSize(int var1);

    private void maybeCacheUpgrades() {
        if (this.needsUpgradeCache) {
            int i;
            this.isCreative = false;
            this.hasDowngrade = false;
            this.mult = 1;
            for (i = 0; i < this.storageUpgrades.getSlots(); ++i) {
                Item upgrade = this.storageUpgrades.getStackInSlot(i).getItem();
                if (upgrade.equals(FunctionalStorage.STORAGE_UPGRADES.get((Object)StorageUpgradeItem.StorageTier.IRON).get())) {
                    this.hasDowngrade = true;
                }
                if (upgrade.equals(FunctionalStorage.CREATIVE_UPGRADE.get())) {
                    this.isCreative = true;
                }
                if (!(upgrade instanceof StorageUpgradeItem)) continue;
                double calculated = (double)((StorageUpgradeItem)upgrade).getStorageMultiplier() / this.getStorageDiv();
                if (this instanceof StorageControllerTile) {
                    if (this.mult == 1) {
                        this.mult = 0;
                    }
                    this.mult = (int)((double)this.mult + calculated);
                    continue;
                }
                this.mult = (int)((double)this.mult * calculated);
            }
            this.isVoid = false;
            if (this.getUtilitySlotAmount() > 0) {
                for (i = 0; i < this.utilityUpgrades.getSlots(); ++i) {
                    if (!this.utilityUpgrades.getStackInSlot(i).getItem().equals(FunctionalStorage.VOID_UPGRADE.get())) continue;
                    this.isVoid = true;
                }
            }
            this.needsUpgradeCache = false;
        }
    }

    public boolean hasDowngrade() {
        this.maybeCacheUpgrades();
        return this.hasDowngrade;
    }

    public void toggleLocking() {
        this.setLocked(!this.isLocked());
    }

    public boolean isLocked() {
        return this.getBlockState().hasProperty((Property)DrawerBlock.LOCKED) && (Boolean)this.getBlockState().getValue((Property)DrawerBlock.LOCKED) != false;
    }

    public void setLocked(boolean locked) {
        if (this.getBlockState().hasProperty((Property)DrawerBlock.LOCKED)) {
            this.level.setBlock(this.getBlockPos(), (BlockState)this.getBlockState().setValue((Property)DrawerBlock.LOCKED, (Comparable)Boolean.valueOf(locked)), 3);
        }
    }

    public void toggleOption(ConfigurationToolItem.ConfigurationAction action) {
        if (action.getMax() == 1) {
            this.drawerOptions.setActive(action, !this.drawerOptions.isActive(action));
        } else {
            this.drawerOptions.setAdvancedValue(action, (this.drawerOptions.getAdvancedValue(action) + 1) % (action.getMax() + 1));
        }
        this.markForUpdate();
    }

    public DrawerOptions getDrawerOptions() {
        return this.drawerOptions;
    }

    public InventoryComponent<ControllableDrawerTile<T>> getUtilityUpgrades() {
        return this.utilityUpgrades;
    }

    public InventoryComponent<ControllableDrawerTile<T>> getStorageUpgrades() {
        return this.storageUpgrades;
    }

    public boolean isEverythingEmpty() {
        int i;
        for (i = 0; i < this.getStorageUpgrades().getSlots(); ++i) {
            if (this.getStorageUpgrades().getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        for (i = 0; i < this.getUtilityUpgrades().getSlots(); ++i) {
            if (this.getUtilityUpgrades().getStackInSlot(i).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public abstract InventoryComponent<ControllableDrawerTile<T>> getStorageUpgradesConstructor();

    public int getTitleColor() {
        return ChatFormatting.DARK_GRAY.getColor();
    }

    public boolean isStorageUpgradeLocked() {
        return this.isStorageUpgradeLocked;
    }

    public static class DrawerOptions
    implements INBTSerializable<CompoundTag> {
        public HashMap<ConfigurationToolItem.ConfigurationAction, Boolean> options = new HashMap();
        public HashMap<ConfigurationToolItem.ConfigurationAction, Integer> advancedOptions;

        public DrawerOptions() {
            this.options.put(ConfigurationToolItem.ConfigurationAction.TOGGLE_NUMBERS, true);
            this.options.put(ConfigurationToolItem.ConfigurationAction.TOGGLE_RENDER, true);
            this.options.put(ConfigurationToolItem.ConfigurationAction.TOGGLE_UPGRADES, true);
            this.advancedOptions = new HashMap();
            this.advancedOptions.put(ConfigurationToolItem.ConfigurationAction.INDICATOR, 0);
        }

        public boolean isActive(ConfigurationToolItem.ConfigurationAction configurationAction) {
            return this.options.getOrDefault((Object)configurationAction, true);
        }

        public void setActive(ConfigurationToolItem.ConfigurationAction configurationAction, boolean active) {
            this.options.put(configurationAction, active);
        }

        public int getAdvancedValue(ConfigurationToolItem.ConfigurationAction configurationAction) {
            return this.advancedOptions.getOrDefault((Object)configurationAction, 0);
        }

        public void setAdvancedValue(ConfigurationToolItem.ConfigurationAction configurationAction, int value) {
            this.advancedOptions.put(configurationAction, value);
        }

        public CompoundTag serializeNBT(HolderLookup.Provider provider) {
            CompoundTag compoundTag = new CompoundTag();
            for (ConfigurationToolItem.ConfigurationAction action : this.options.keySet()) {
                compoundTag.putBoolean(action.name(), this.options.get((Object)action).booleanValue());
            }
            for (ConfigurationToolItem.ConfigurationAction action : this.advancedOptions.keySet()) {
                compoundTag.putInt("Advanced: " + action.name(), this.advancedOptions.get((Object)action).intValue());
            }
            return compoundTag;
        }

        public void deserializeNBT(HolderLookup.Provider provider, CompoundTag nbt) {
            for (String allKey : nbt.getAllKeys()) {
                if (allKey.startsWith("Advanced: ")) {
                    this.advancedOptions.put(ConfigurationToolItem.ConfigurationAction.valueOf(allKey.replace("Advanced: ", "")), nbt.getInt(allKey));
                    continue;
                }
                this.options.put(ConfigurationToolItem.ConfigurationAction.valueOf(allKey), nbt.getBoolean(allKey));
            }
        }
    }
}

