/*
 * Decompiled with CFR 0.152.
 */
package telepathicgrunt.structure_layout_optimizer.utils;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntComparators;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.Util;
import net.minecraft.core.FrontAndTop;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NumericTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.JigsawBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.structure.templatesystem.StructureTemplate;

public final class GeneralUtils {
    private GeneralUtils() {
    }

    public static boolean canJigsawsAttach(StructureTemplate.StructureBlockInfo jigsaw1, StructureTemplate.StructureBlockInfo jigsaw2) {
        FrontAndTop prop1 = (FrontAndTop)jigsaw1.state().getValue((Property)JigsawBlock.ORIENTATION);
        FrontAndTop prop2 = (FrontAndTop)jigsaw2.state().getValue((Property)JigsawBlock.ORIENTATION);
        return prop1.front() == prop2.front().getOpposite() && (prop1.top() == prop2.top() || GeneralUtils.isRollableJoint(jigsaw1, prop1)) && GeneralUtils.getStringMicroOptimised(jigsaw1.nbt(), "target").equals(GeneralUtils.getStringMicroOptimised(jigsaw2.nbt(), "name"));
    }

    private static boolean isRollableJoint(StructureTemplate.StructureBlockInfo jigsaw1, FrontAndTop prop1) {
        String joint = GeneralUtils.getStringMicroOptimised(jigsaw1.nbt(), "joint");
        if (!joint.equals("rollable") && !joint.equals("aligned")) {
            return !prop1.front().getAxis().isHorizontal();
        }
        return joint.equals("rollable");
    }

    public static void shuffleAndPrioritize(List<StructureTemplate.StructureBlockInfo> list, RandomSource random) {
        Int2ObjectArrayMap buckets = new Int2ObjectArrayMap();
        for (StructureTemplate.StructureBlockInfo structureBlockInfo : list) {
            int key = 0;
            if (structureBlockInfo.nbt() != null) {
                key = GeneralUtils.getIntMicroOptimised(structureBlockInfo.nbt(), "selection_priority");
            }
            ((List)buckets.computeIfAbsent(key, k -> new ArrayList())).add(structureBlockInfo);
        }
        for (List bucketList : buckets.values()) {
            Util.shuffle((List)bucketList, (RandomSource)random);
        }
        if (buckets.size() == 1) {
            list.clear();
            GeneralUtils.copyAll((List)buckets.get(0), list);
        } else if (buckets.size() > 1) {
            list.clear();
            IntArrayList keys = new IntArrayList((IntCollection)buckets.keySet());
            keys.sort(IntComparators.OPPOSITE_COMPARATOR);
            for (int i = 0; i < keys.size(); ++i) {
                GeneralUtils.copyAll((List)buckets.get(keys.getInt(i)), list);
            }
        }
    }

    public static int getIntMicroOptimised(CompoundTag tag, String key) {
        int n;
        Tag tag2 = tag.get(key);
        if (tag2 instanceof NumericTag) {
            NumericTag numericTag = (NumericTag)tag2;
            n = numericTag.getAsInt();
        } else {
            n = 0;
        }
        return n;
    }

    public static String getStringMicroOptimised(CompoundTag tag, String key) {
        String string;
        Tag tag2 = tag.get(key);
        if (tag2 instanceof StringTag) {
            StringTag stringTag = (StringTag)tag2;
            string = stringTag.getAsString();
        } else {
            string = "";
        }
        return string;
    }

    public static <T> void copyAll(List<T> src, List<T> dest) {
        for (int i = 0; i < src.size(); ++i) {
            dest.add(src.get(i));
        }
    }
}

