/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.sblforked.util;

import mod.azure.azurelib.sblforked.object.ExtendedTargetingConditions;
import mod.azure.azurelib.sblforked.util.BrainUtils;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;

public class SensoryUtils {
    public static boolean isEntityTargetable(LivingEntity attacker, LivingEntity target) {
        ExtendedTargetingConditions predicate = BrainUtils.getTargetOfEntity(attacker) == target ? ExtendedTargetingConditions.forLookTarget().withFollowRange().skipInvisibilityCheck() : ExtendedTargetingConditions.forLookTarget().withFollowRange();
        return predicate.test(attacker, target);
    }

    public static boolean isEntityAttackable(LivingEntity attacker, LivingEntity target) {
        ExtendedTargetingConditions predicate = BrainUtils.getTargetOfEntity(attacker) == target ? ExtendedTargetingConditions.forAttackTarget().withFollowRange().skipInvisibilityCheck() : ExtendedTargetingConditions.forAttackTarget().withFollowRange();
        return predicate.test(attacker, target);
    }

    public static boolean isEntityAttackableIgnoringLineOfSight(LivingEntity attacker, LivingEntity target) {
        ExtendedTargetingConditions predicate = BrainUtils.getTargetOfEntity(attacker) == target ? ExtendedTargetingConditions.forAttackTarget().ignoreLineOfSight().withFollowRange().skipInvisibilityCheck() : ExtendedTargetingConditions.forAttackTarget().ignoreLineOfSight().withFollowRange();
        return predicate.test(attacker, target);
    }

    public static boolean hasLineOfSight(LivingEntity entity, Entity target) {
        if (entity instanceof Mob) {
            Mob mob = (Mob)entity;
            return mob.getSensing().hasLineOfSight(target);
        }
        return entity.hasLineOfSight(target);
    }
}

