/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.sblforked.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.Object2LongOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import mod.azure.azurelib.sblforked.api.core.sensor.ExtendedSensor;
import mod.azure.azurelib.sblforked.api.core.sensor.PredicateSensor;
import mod.azure.azurelib.sblforked.registry.SBLSensors;
import mod.azure.azurelib.sblforked.util.BrainUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.AcquirePoi;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.level.pathfinder.Path;

public class NearestHomeSensor<E extends Mob>
extends PredicateSensor<E, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{MemoryModuleType.NEAREST_BED});
    protected int radius = 48;
    private final Object2LongOpenHashMap<BlockPos> homesMap = new Object2LongOpenHashMap(5);
    private int tries = 0;

    public NearestHomeSensor() {
        super((brainOwner, entity) -> brainOwner.isBaby());
    }

    public NearestHomeSensor<E> setRadius(int radius) {
        this.radius = radius;
        return this;
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.NEAREST_HOME.get();
    }

    @Override
    protected void doTick(ServerLevel level, E entity) {
        Predicate<BlockPos> predicate;
        if (!this.predicate().test(entity, entity)) {
            return;
        }
        this.tries = 0;
        long nodeExpiryTime = level.getGameTime() + (long)level.getRandom().nextInt(20);
        PoiManager poiManager = level.getPoiManager();
        Set poiLocations = poiManager.findAllWithType(poiType -> poiType.is(PoiTypes.HOME), predicate = pos -> {
            if (this.homesMap.containsKey(pos)) {
                return false;
            }
            if (++this.tries >= 5) {
                return false;
            }
            this.homesMap.put(pos, nodeExpiryTime + 40L);
            return true;
        }, entity.blockPosition(), this.radius, PoiManager.Occupancy.ANY).collect(Collectors.toSet());
        Path pathToHome = AcquirePoi.findPathToPois(entity, poiLocations);
        if (pathToHome != null && pathToHome.canReach()) {
            BlockPos targetPos = pathToHome.getTarget();
            poiManager.getType(targetPos).ifPresent(poiType -> BrainUtils.setMemory((LivingEntity)entity, MemoryModuleType.NEAREST_BED, targetPos));
        } else if (this.tries < 5) {
            this.homesMap.object2LongEntrySet().removeIf(pos -> pos.getLongValue() < nodeExpiryTime);
        }
    }
}

