/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.sblforked.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import mod.azure.azurelib.sblforked.api.core.sensor.ExtendedSensor;
import mod.azure.azurelib.sblforked.api.core.sensor.PredicateSensor;
import mod.azure.azurelib.sblforked.object.SquareRadius;
import mod.azure.azurelib.sblforked.registry.SBLSensors;
import mod.azure.azurelib.sblforked.util.BrainUtils;
import mod.azure.azurelib.sblforked.util.EntityRetrievalUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class NearbyPlayersSensor<E extends LivingEntity>
extends PredicateSensor<Player, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{MemoryModuleType.NEAREST_PLAYERS, MemoryModuleType.NEAREST_VISIBLE_PLAYER, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER});
    @Nullable
    protected SquareRadius radius = null;

    public NearbyPlayersSensor() {
        super((player, entity) -> !player.isSpectator());
    }

    public NearbyPlayersSensor<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public NearbyPlayersSensor<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.NEARBY_PLAYERS.get();
    }

    @Override
    protected void doTick(ServerLevel level, E entity) {
        SquareRadius radius = this.radius;
        if (radius == null) {
            double dist = entity.getAttributeValue(Attributes.FOLLOW_RANGE);
            radius = new SquareRadius(dist, dist);
        }
        List<Player> players = EntityRetrievalUtil.getPlayers((Level)level, radius.inflateAABB(entity.getBoundingBox()), player -> this.predicate().test(player, entity));
        players.sort(Comparator.comparingDouble(arg_0 -> entity.distanceToSqr(arg_0)));
        ObjectArrayList targetablePlayers = new ObjectArrayList(players);
        targetablePlayers.removeIf(pl -> !NearbyPlayersSensor.isEntityTargetable((LivingEntity)entity, (LivingEntity)pl));
        ObjectArrayList attackablePlayers = new ObjectArrayList((Collection)targetablePlayers);
        attackablePlayers.removeIf(pl -> !NearbyPlayersSensor.isEntityAttackable((LivingEntity)entity, (LivingEntity)pl));
        BrainUtils.setMemory(entity, MemoryModuleType.NEAREST_PLAYERS, players);
        BrainUtils.setMemory(entity, MemoryModuleType.NEAREST_VISIBLE_PLAYER, targetablePlayers.isEmpty() ? null : (Player)targetablePlayers.get(0));
        BrainUtils.setMemory(entity, MemoryModuleType.NEAREST_VISIBLE_ATTACKABLE_PLAYER, attackablePlayers.isEmpty() ? null : (Player)attackablePlayers.get(0));
    }
}

