/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.sblforked.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import mod.azure.azurelib.sblforked.api.core.sensor.ExtendedSensor;
import mod.azure.azurelib.sblforked.api.core.sensor.PredicateSensor;
import mod.azure.azurelib.sblforked.object.FixedNearestVisibleLivingEntities;
import mod.azure.azurelib.sblforked.object.SquareRadius;
import mod.azure.azurelib.sblforked.registry.SBLSensors;
import mod.azure.azurelib.sblforked.util.BrainUtils;
import mod.azure.azurelib.sblforked.util.EntityRetrievalUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class NearbyLivingEntitySensor<E extends LivingEntity>
extends PredicateSensor<LivingEntity, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{MemoryModuleType.NEAREST_LIVING_ENTITIES, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES});
    @Nullable
    protected SquareRadius radius = null;

    public NearbyLivingEntitySensor() {
        super((target, entity) -> target != entity && target.isAlive());
    }

    public NearbyLivingEntitySensor<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public NearbyLivingEntitySensor<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.NEARBY_LIVING_ENTITY.get();
    }

    @Override
    protected void doTick(ServerLevel level, E entity) {
        SquareRadius radius = this.radius;
        if (radius == null) {
            double dist = entity.getAttributeValue(Attributes.FOLLOW_RANGE);
            radius = new SquareRadius(dist, dist);
        }
        List<LivingEntity> entities = EntityRetrievalUtil.getEntities((Level)level, entity.getBoundingBox().inflate(radius.xzRadius(), radius.yRadius(), radius.xzRadius()), obj -> {
            if (!(obj instanceof LivingEntity)) return false;
            LivingEntity livingEntity = (LivingEntity)obj;
            if (!this.predicate().test(livingEntity, entity)) return false;
            return true;
        });
        entities.sort(Comparator.comparingDouble(arg_0 -> entity.distanceToSqr(arg_0)));
        BrainUtils.setMemory(entity, MemoryModuleType.NEAREST_LIVING_ENTITIES, entities);
        BrainUtils.setMemory(entity, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, new FixedNearestVisibleLivingEntities((LivingEntity)entity, entities));
    }
}

