/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.sblforked.api.core.sensor.vanilla;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import java.util.Map;
import java.util.function.BiPredicate;
import mod.azure.azurelib.sblforked.api.core.sensor.EntityFilteringSensor;
import mod.azure.azurelib.sblforked.api.core.sensor.ExtendedSensor;
import mod.azure.azurelib.sblforked.registry.SBLSensors;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.SensorType;
import org.jetbrains.annotations.Nullable;

public class NearbyHostileSensor<E extends LivingEntity>
extends EntityFilteringSensor<LivingEntity, E> {
    private final Map<EntityType<?>, Float> hostileDistanceMap = new Object2FloatOpenHashMap(11);

    public NearbyHostileSensor() {
        this.setHostiles(Pair.of((Object)EntityType.DROWNED, (Object)Float.valueOf(8.0f)), Pair.of((Object)EntityType.HUSK, (Object)Float.valueOf(8.0f)), Pair.of((Object)EntityType.VEX, (Object)Float.valueOf(8.0f)), Pair.of((Object)EntityType.ZOMBIE, (Object)Float.valueOf(8.0f)), Pair.of((Object)EntityType.ZOMBIE_VILLAGER, (Object)Float.valueOf(8.0f)), Pair.of((Object)EntityType.VINDICATOR, (Object)Float.valueOf(10.0f)), Pair.of((Object)EntityType.ZOGLIN, (Object)Float.valueOf(10.0f)), Pair.of((Object)EntityType.EVOKER, (Object)Float.valueOf(12.0f)), Pair.of((Object)EntityType.ILLUSIONER, (Object)Float.valueOf(12.0f)), Pair.of((Object)EntityType.RAVAGER, (Object)Float.valueOf(12.0f)), Pair.of((Object)EntityType.PILLAGER, (Object)Float.valueOf(15.0f)));
    }

    public NearbyHostileSensor<E> setHostiles(Pair<EntityType<?>, Float> ... entries) {
        this.hostileDistanceMap.clear();
        for (Pair<EntityType<?>, Float> entry : entries) {
            this.hostileDistanceMap.put((EntityType)entry.getFirst(), (Float)entry.getSecond());
        }
        return this;
    }

    public NearbyHostileSensor<E> addHostile(Pair<EntityType<?>, Float> entry) {
        this.hostileDistanceMap.put((EntityType)entry.getFirst(), (Float)entry.getSecond());
        return this;
    }

    @Override
    public MemoryModuleType<LivingEntity> getMemory() {
        return MemoryModuleType.NEAREST_HOSTILE;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.NEARBY_HOSTILE.get();
    }

    @Override
    protected BiPredicate<LivingEntity, E> predicate() {
        return (target, entity) -> {
            Float distance = this.hostileDistanceMap.get(target.getType());
            return distance != null && target.distanceToSqr((Entity)entity) <= (double)(distance.floatValue() * distance.floatValue());
        };
    }

    @Override
    @Nullable
    protected LivingEntity findMatches(E entity, NearestVisibleLivingEntities matcher) {
        return matcher.findClosest(target -> this.predicate().test((LivingEntity)target, entity)).orElse(null);
    }
}

