/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.sblforked.api.core.sensor.vanilla;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.function.BiPredicate;
import mod.azure.azurelib.sblforked.api.core.sensor.EntityFilteringSensor;
import mod.azure.azurelib.sblforked.api.core.sensor.ExtendedSensor;
import mod.azure.azurelib.sblforked.registry.SBLSensors;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.SensorType;
import org.jetbrains.annotations.Nullable;

public class NearbyBabySensor<E extends LivingEntity>
extends EntityFilteringSensor<List<LivingEntity>, E> {
    @Override
    public MemoryModuleType<List<LivingEntity>> getMemory() {
        return MemoryModuleType.VISIBLE_VILLAGER_BABIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.NEARBY_BABY.get();
    }

    @Override
    protected BiPredicate<LivingEntity, E> predicate() {
        return (target, entity) -> target.getType() == entity.getType() && target.isBaby();
    }

    @Override
    @Nullable
    protected List<LivingEntity> findMatches(E entity, NearestVisibleLivingEntities matcher) {
        return ImmutableList.copyOf((Iterable)matcher.findAll(target -> this.predicate().test((LivingEntity)target, entity)));
    }
}

