/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.sblforked.api.core.sensor.vanilla;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mod.azure.azurelib.sblforked.api.core.sensor.ExtendedSensor;
import mod.azure.azurelib.sblforked.registry.SBLSensors;
import mod.azure.azurelib.sblforked.util.BrainUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.monster.hoglin.Hoglin;
import net.minecraft.world.entity.monster.piglin.Piglin;

public class HoglinSpecificSensor<E extends LivingEntity>
extends ExtendedSensor<E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLIN, MemoryModuleType.NEAREST_VISIBLE_ADULT_HOGLINS, MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT, MemoryModuleType.NEAREST_REPELLENT});

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.HOGLIN_SPECIFIC.get();
    }

    @Override
    protected void doTick(ServerLevel level, E entity) {
        Brain brain = entity.getBrain();
        BrainUtils.withMemory(brain, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, entities -> {
            int piglinCount = 0;
            Piglin nearestPiglin = null;
            ObjectArrayList hoglins = new ObjectArrayList();
            for (LivingEntity target : entities.findAll(mob -> !mob.isBaby())) {
                if (target instanceof Piglin) {
                    Piglin piglin = (Piglin)target;
                    ++piglinCount;
                    if (nearestPiglin != null) continue;
                    nearestPiglin = piglin;
                    continue;
                }
                if (!(target instanceof Hoglin)) continue;
                Hoglin hoglin = (Hoglin)target;
                hoglins.add(hoglin);
            }
            BrainUtils.setMemory(brain, MemoryModuleType.NEAREST_VISIBLE_ADULT_PIGLIN, nearestPiglin);
            BrainUtils.setMemory(brain, MemoryModuleType.NEAREST_VISIBLE_ADULT_HOGLINS, hoglins);
            BrainUtils.setMemory(brain, MemoryModuleType.VISIBLE_ADULT_PIGLIN_COUNT, Integer.valueOf(piglinCount));
            BrainUtils.setMemory(brain, MemoryModuleType.VISIBLE_ADULT_HOGLIN_COUNT, Integer.valueOf(hoglins.size()));
            BrainUtils.setMemory(brain, MemoryModuleType.NEAREST_REPELLENT, (BlockPos)BlockPos.findClosestMatch((BlockPos)entity.blockPosition(), (int)8, (int)4, pos -> level.getBlockState(pos).is(BlockTags.HOGLIN_REPELLENTS)).orElse(null));
        });
    }
}

