/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.sblforked.api.core.sensor.custom;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import mod.azure.azurelib.sblforked.api.core.sensor.ExtendedSensor;
import mod.azure.azurelib.sblforked.api.core.sensor.PredicateSensor;
import mod.azure.azurelib.sblforked.object.SquareRadius;
import mod.azure.azurelib.sblforked.registry.SBLMemoryTypes;
import mod.azure.azurelib.sblforked.registry.SBLSensors;
import mod.azure.azurelib.sblforked.util.BrainUtils;
import mod.azure.azurelib.sblforked.util.EntityRetrievalUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.level.Level;

public class NearbyItemsSensor<E extends Mob>
extends PredicateSensor<ItemEntity, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{SBLMemoryTypes.NEARBY_ITEMS.get()});
    protected SquareRadius radius = new SquareRadius(32.0, 16.0);

    public NearbyItemsSensor() {
        super((item, entity) -> entity.wantsToPickUp(item.getItem()) && entity.hasLineOfSight((Entity)item));
    }

    public NearbyItemsSensor<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public NearbyItemsSensor<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.NEARBY_ITEMS.get();
    }

    @Override
    protected void doTick(ServerLevel level, E entity) {
        BrainUtils.setMemory(entity, SBLMemoryTypes.NEARBY_ITEMS.get(), EntityRetrievalUtil.getEntities((Level)level, this.radius.inflateAABB(entity.getBoundingBox()), obj -> {
            if (!(obj instanceof ItemEntity)) return false;
            ItemEntity item = (ItemEntity)obj;
            if (!this.predicate().test(item, entity)) return false;
            return true;
        }));
    }
}

