/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.sblforked.api.core.sensor.custom;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Comparator;
import java.util.List;
import mod.azure.azurelib.sblforked.api.core.sensor.ExtendedSensor;
import mod.azure.azurelib.sblforked.api.core.sensor.PredicateSensor;
import mod.azure.azurelib.sblforked.registry.SBLMemoryTypes;
import mod.azure.azurelib.sblforked.registry.SBLSensors;
import mod.azure.azurelib.sblforked.util.BrainUtils;
import mod.azure.azurelib.sblforked.util.EntityRetrievalUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;

public class IncomingProjectilesSensor<E extends LivingEntity>
extends PredicateSensor<Projectile, E> {
    private static final List<MemoryModuleType<?>> MEMORIES = ObjectArrayList.of((Object[])new MemoryModuleType[]{SBLMemoryTypes.INCOMING_PROJECTILES.get()});

    public IncomingProjectilesSensor() {
        this.setScanRate(entity -> 3);
        this.setPredicate((projectile, entity) -> {
            if (projectile.onGround() || projectile.horizontalCollision || projectile.verticalCollision) {
                return false;
            }
            return entity.getBoundingBox().clip(projectile.position(), projectile.position().add(projectile.getDeltaMovement().multiply(3.0, 3.0, 3.0))).isPresent();
        });
    }

    @Override
    public List<MemoryModuleType<?>> memoriesUsed() {
        return MEMORIES;
    }

    @Override
    public SensorType<? extends ExtendedSensor<?>> type() {
        return SBLSensors.INCOMING_PROJECTILES.get();
    }

    @Override
    protected void doTick(ServerLevel level, E entity) {
        List projectiles = EntityRetrievalUtil.getEntities((Level)level, entity.getBoundingBox().inflate(7.0), target -> {
            if (!(target instanceof Projectile)) return false;
            Projectile projectile = (Projectile)target;
            if (!this.predicate().test(projectile, entity)) return false;
            return true;
        });
        if (!projectiles.isEmpty()) {
            projectiles.sort(Comparator.comparingDouble(arg_0 -> entity.distanceToSqr(arg_0)));
            BrainUtils.setMemory(entity, SBLMemoryTypes.INCOMING_PROJECTILES.get(), projectiles);
        } else {
            BrainUtils.clearMemory(entity, SBLMemoryTypes.INCOMING_PROJECTILES.get());
        }
    }
}

