/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.sblforked.api.core.behaviour.custom.target;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import mod.azure.azurelib.sblforked.api.core.behaviour.ExtendedBehaviour;
import mod.azure.azurelib.sblforked.util.BrainUtils;
import mod.azure.azurelib.sblforked.util.EntityRetrievalUtil;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class TargetOrRetaliate<E extends Mob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.ATTACK_TARGET, (Object)MemoryStatus.VALUE_ABSENT), Pair.of((Object)MemoryModuleType.HURT_BY, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.NEAREST_ATTACKABLE, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.REGISTERED)});
    protected Predicate<LivingEntity> canAttackPredicate = entity -> {
        Player player;
        return entity.isAlive() && (!(entity instanceof Player) || !(player = (Player)entity).isCreative());
    };
    protected BiPredicate<E, Entity> alertAlliesPredicate = (owner, attacker) -> false;
    protected BiPredicate<E, LivingEntity> allyPredicate = (owner, ally) -> {
        OwnableEntity pet;
        if (!owner.getClass().isAssignableFrom(ally.getClass()) || BrainUtils.getTargetOfEntity(ally) != null) {
            return false;
        }
        if (owner instanceof OwnableEntity && (pet = (OwnableEntity)owner).getOwner() != ((OwnableEntity)ally).getOwner()) {
            return false;
        }
        Entity lastHurtBy = (Entity)BrainUtils.getMemory(ally, MemoryModuleType.HURT_BY_ENTITY);
        return lastHurtBy == null || !ally.isAlliedTo(lastHurtBy);
    };
    protected LivingEntity toTarget = null;
    protected MemoryModuleType<? extends LivingEntity> priorityTargetMemory = MemoryModuleType.NEAREST_ATTACKABLE;

    public TargetOrRetaliate<E> attackablePredicate(Predicate<LivingEntity> predicate) {
        this.canAttackPredicate = predicate;
        return this;
    }

    public TargetOrRetaliate<E> useMemory(MemoryModuleType<? extends LivingEntity> memory) {
        this.priorityTargetMemory = memory;
        return this;
    }

    public TargetOrRetaliate<E> alertAlliesWhen(BiPredicate<E, Entity> predicate) {
        this.alertAlliesPredicate = predicate;
        return this;
    }

    public TargetOrRetaliate<E> isAllyIf(BiPredicate<E, LivingEntity> predicate) {
        this.allyPredicate = predicate;
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, E owner) {
        Brain brain = owner.getBrain();
        this.toTarget = BrainUtils.getMemory(brain, this.priorityTargetMemory);
        if (this.toTarget == null) {
            this.toTarget = (LivingEntity)BrainUtils.getMemory(brain, MemoryModuleType.HURT_BY_ENTITY);
            if (this.toTarget == null) {
                NearestVisibleLivingEntities nearbyEntities = (NearestVisibleLivingEntities)BrainUtils.getMemory(brain, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES);
                if (nearbyEntities != null) {
                    this.toTarget = nearbyEntities.findClosest(this.canAttackPredicate).orElse(null);
                }
                if (this.alertAlliesPredicate.test(owner, (Entity)this.toTarget)) {
                    this.alertAllies(level, owner);
                }
                if (this.toTarget == null) {
                    return false;
                }
            }
        }
        if (this.alertAlliesPredicate.test(owner, (Entity)this.toTarget)) {
            this.alertAllies(level, owner);
        }
        return this.canAttackPredicate.test(this.toTarget);
    }

    @Override
    protected void start(E entity) {
        BrainUtils.setTargetOfEntity(entity, this.toTarget);
        BrainUtils.clearMemory(entity, MemoryModuleType.CANT_REACH_WALK_TARGET_SINCE);
        this.toTarget = null;
    }

    protected void alertAllies(ServerLevel level, E owner) {
        double followRange = owner.getAttributeValue(Attributes.FOLLOW_RANGE);
        for (LivingEntity ally : EntityRetrievalUtil.getEntities((Level)level, owner.getBoundingBox().inflate(followRange, 10.0, followRange), entity -> {
            LivingEntity livingEntity;
            return entity != owner && entity instanceof LivingEntity && this.allyPredicate.test(owner, livingEntity = (LivingEntity)entity);
        })) {
            BrainUtils.setTargetOfEntity(ally, this.toTarget);
        }
    }
}

