/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.sblforked.api.core.behaviour.custom.target;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Function;
import mod.azure.azurelib.sblforked.api.core.behaviour.ExtendedBehaviour;
import mod.azure.azurelib.sblforked.object.FreePositionTracker;
import mod.azure.azurelib.sblforked.util.BrainUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.valueproviders.ConstantFloat;
import net.minecraft.util.valueproviders.FloatProvider;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;

public class SetRandomLookTarget<E extends Mob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORIES = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.LOOK_TARGET, (Object)MemoryStatus.VALUE_ABSENT)});
    protected FloatProvider runChance = ConstantFloat.of((float)0.02f);
    protected Function<E, Integer> lookTime = entity -> entity.getRandom().nextInt(20) + 20;

    public SetRandomLookTarget<E> lookChance(FloatProvider chance) {
        this.runChance = chance;
        return this;
    }

    public SetRandomLookTarget<E> lookTime(Function<E, Integer> function) {
        this.lookTime = function;
        return this;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        return entity.getRandom().nextFloat() < this.runChance.sample(entity.getRandom());
    }

    @Override
    protected void start(E entity) {
        double angle = 6.2831854820251465 * entity.getRandom().nextDouble();
        BrainUtils.setForgettableMemory(entity, MemoryModuleType.LOOK_TARGET, new FreePositionTracker(entity.getEyePosition().add(Math.cos(angle), 0.0, Math.sin(angle))), (int)this.lookTime.apply(entity));
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORIES;
    }
}

