/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.sblforked.api.core.behaviour.custom.move;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import mod.azure.azurelib.sblforked.api.core.behaviour.custom.move.FollowEntity;
import mod.azure.azurelib.sblforked.util.BrainUtils;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import org.jetbrains.annotations.Nullable;

public class FollowParent<E extends AgeableMob>
extends FollowEntity<E, AgeableMob> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES, (Object)MemoryStatus.VALUE_PRESENT)});
    private BiPredicate<E, AgeableMob> parentPredicate = (entity, other) -> entity.getClass() == other.getClass() && other.getAge() >= 0;

    public FollowParent() {
        this.following(this::getParent);
        this.stopFollowingWithin(2.0);
    }

    public FollowParent<E> parentPredicate(BiPredicate<E, AgeableMob> predicate) {
        this.parentPredicate = predicate;
        return this;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        return entity.getAge() < 0 && super.checkExtraStartConditions(level, entity);
    }

    @Override
    public List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Nullable
    protected AgeableMob getParent(E entity) {
        return ((NearestVisibleLivingEntities)BrainUtils.getMemory(entity, MemoryModuleType.NEAREST_VISIBLE_LIVING_ENTITIES)).findClosest(other -> {
            AgeableMob ageableMob;
            return other instanceof AgeableMob && this.parentPredicate.test(entity, ageableMob = (AgeableMob)other);
        }).map(AgeableMob.class::cast).orElse(null);
    }
}

