/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.sblforked.api.core.behaviour.custom.misc;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2FloatFunction;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import mod.azure.azurelib.sblforked.api.core.behaviour.ExtendedBehaviour;
import mod.azure.azurelib.sblforked.object.SquareRadius;
import mod.azure.azurelib.sblforked.util.BrainUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.ai.memory.WalkTarget;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Panic<E extends PathfinderMob>
extends ExtendedBehaviour<E> {
    private static final List<Pair<MemoryModuleType<?>, MemoryStatus>> MEMORY_REQUIREMENTS = ObjectArrayList.of((Object[])new Pair[]{Pair.of((Object)MemoryModuleType.HURT_BY, (Object)MemoryStatus.VALUE_PRESENT), Pair.of((Object)MemoryModuleType.WALK_TARGET, (Object)MemoryStatus.REGISTERED), Pair.of((Object)MemoryModuleType.IS_PANICKING, (Object)MemoryStatus.REGISTERED)});
    protected BiPredicate<E, DamageSource> shouldPanicPredicate = (entity, damageSource) -> entity.isFreezing() || entity.isOnFire() || damageSource.getEntity() instanceof LivingEntity;
    protected Object2FloatFunction<E> speedMod = entity -> 1.25f;
    protected SquareRadius radius = new SquareRadius(5.0, 4.0);
    protected BiFunction<E, DamageSource, Integer> panicFor = (entity, damageSource) -> entity.getRandom().nextInt(100, 120);
    protected Vec3 targetPos = null;
    protected int panicEndTime = 0;

    public Panic() {
        this.noTimeout();
    }

    public Panic<E> panicIf(BiPredicate<E, DamageSource> predicate) {
        this.shouldPanicPredicate = predicate;
        return this;
    }

    public Panic<E> panicFor(BiFunction<E, DamageSource, Integer> function) {
        this.panicFor = function;
        return this;
    }

    public Panic<E> speedMod(Object2FloatFunction<E> speedModifier) {
        this.speedMod = speedModifier;
        return this;
    }

    public Panic<E> setRadius(double radius) {
        return this.setRadius(radius, radius);
    }

    public Panic<E> setRadius(double xz, double y) {
        this.radius = new SquareRadius(xz, y);
        return this;
    }

    @Override
    protected List<Pair<MemoryModuleType<?>, MemoryStatus>> getMemoryRequirements() {
        return MEMORY_REQUIREMENTS;
    }

    @Override
    protected boolean checkExtraStartConditions(ServerLevel level, E entity) {
        if (!this.shouldPanicPredicate.test(entity, (DamageSource)BrainUtils.getMemory(entity, MemoryModuleType.HURT_BY))) {
            return false;
        }
        this.setPanicTarget(entity);
        return this.targetPos != null;
    }

    @Override
    protected boolean shouldKeepRunning(E entity) {
        return ((PathfinderMob)entity).tickCount < this.panicEndTime;
    }

    @Override
    protected void start(E entity) {
        BrainUtils.setMemory(entity, MemoryModuleType.WALK_TARGET, new WalkTarget(this.targetPos, ((Float)this.speedMod.apply(entity)).floatValue(), 0));
        BrainUtils.setMemory(entity, MemoryModuleType.IS_PANICKING, Boolean.valueOf(true));
        this.panicEndTime = ((PathfinderMob)entity).tickCount + this.panicFor.apply(entity, (DamageSource)BrainUtils.getMemory(entity, MemoryModuleType.HURT_BY));
    }

    @Override
    protected void tick(E entity) {
        if (entity.getNavigation().isDone()) {
            this.targetPos = null;
            this.setPanicTarget(entity);
            if (this.targetPos != null) {
                BrainUtils.clearMemory(entity, MemoryModuleType.PATH);
                BrainUtils.setMemory(entity, MemoryModuleType.WALK_TARGET, new WalkTarget(this.targetPos, ((Float)this.speedMod.apply(entity)).floatValue(), 1));
            }
        }
    }

    @Override
    protected void stop(E entity) {
        this.targetPos = null;
        this.panicEndTime = 0;
        BrainUtils.setMemory(entity, MemoryModuleType.IS_PANICKING, Boolean.valueOf(false));
    }

    @Nullable
    protected Vec3 findNearbyWater(E entity) {
        BlockPos pos = entity.blockPosition();
        Level level = entity.level();
        return !level.getBlockState(pos).getCollisionShape((BlockGetter)level, pos).isEmpty() ? null : (Vec3)BlockPos.findClosestMatch((BlockPos)entity.blockPosition(), (int)((int)this.radius.xzRadius()), (int)((int)this.radius.yRadius()), checkPos -> level.getFluidState(checkPos).is(FluidTags.WATER)).map(Vec3::atBottomCenterOf).orElse(null);
    }

    protected void setPanicTarget(E entity) {
        if (entity.isOnFire()) {
            this.targetPos = this.findNearbyWater(entity);
        }
        if (this.targetPos == null) {
            Entity entity2;
            DamageSource lastDamage = (DamageSource)BrainUtils.getMemory(entity, MemoryModuleType.HURT_BY);
            if (lastDamage != null && (entity2 = lastDamage.getEntity()) instanceof LivingEntity) {
                LivingEntity attacker = (LivingEntity)entity2;
                this.targetPos = DefaultRandomPos.getPosAway(entity, (int)((int)this.radius.xzRadius()), (int)((int)this.radius.yRadius()), (Vec3)attacker.position());
            }
            if (this.targetPos == null) {
                this.targetPos = DefaultRandomPos.getPos(entity, (int)((int)this.radius.xzRadius()), (int)((int)this.radius.yRadius()));
            }
        }
    }
}

