/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.internal.common.network;

import mod.azure.azurelib.common.internal.common.constant.DataTickets;
import mod.azure.azurelib.core.object.DataTicket;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;

public abstract class SerializableDataTicket<D>
extends DataTicket<D> {
    public static final StreamCodec<RegistryFriendlyByteBuf, SerializableDataTicket<?>> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.STRING_UTF8, DataTicket::id, DataTickets::byName);

    protected SerializableDataTicket(String id, Class<? extends D> objectType) {
        super(id, objectType);
    }

    public static SerializableDataTicket<Double> ofDouble(ResourceLocation id) {
        return new SerializableDataTicket<Double>(id.toString(), Double.class){

            @Override
            public StreamCodec<? super RegistryFriendlyByteBuf, Double> streamCodec() {
                return ByteBufCodecs.DOUBLE;
            }
        };
    }

    public static SerializableDataTicket<Float> ofFloat(ResourceLocation id) {
        return new SerializableDataTicket<Float>(id.toString(), Float.class){

            @Override
            public StreamCodec<? super RegistryFriendlyByteBuf, Float> streamCodec() {
                return ByteBufCodecs.FLOAT;
            }
        };
    }

    public static SerializableDataTicket<Boolean> ofBoolean(ResourceLocation id) {
        return new SerializableDataTicket<Boolean>(id.toString(), Boolean.class){

            @Override
            public StreamCodec<? super RegistryFriendlyByteBuf, Boolean> streamCodec() {
                return ByteBufCodecs.BOOL;
            }
        };
    }

    public static SerializableDataTicket<Integer> ofInt(ResourceLocation id) {
        return new SerializableDataTicket<Integer>(id.toString(), Integer.class){

            @Override
            public StreamCodec<? super RegistryFriendlyByteBuf, Integer> streamCodec() {
                return ByteBufCodecs.VAR_INT;
            }
        };
    }

    public static SerializableDataTicket<String> ofString(ResourceLocation id) {
        return new SerializableDataTicket<String>(id.toString(), String.class){

            @Override
            public StreamCodec<? super RegistryFriendlyByteBuf, String> streamCodec() {
                return ByteBufCodecs.STRING_UTF8;
            }
        };
    }

    public static <E extends Enum<E>> SerializableDataTicket<E> ofEnum(ResourceLocation id, final Class<E> enumClass) {
        return new SerializableDataTicket<E>(id.toString(), enumClass){

            @Override
            public StreamCodec<? super RegistryFriendlyByteBuf, E> streamCodec() {
                return new StreamCodec<RegistryFriendlyByteBuf, E>(){

                    @NotNull
                    public E decode(@NotNull RegistryFriendlyByteBuf buf) {
                        return Enum.valueOf(enumClass, buf.readUtf());
                    }

                    public void encode(@NotNull RegistryFriendlyByteBuf buf, @NotNull E data) {
                        buf.writeUtf(((Enum)data).toString());
                    }
                };
            }
        };
    }

    public abstract StreamCodec<? super RegistryFriendlyByteBuf, D> streamCodec();
}

