/*
 * Decompiled with CFR 0.152.
 */
package mod.azure.azurelib.common.api.common.interfaces;

import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.Level;

public interface Growable {
    public float getGrowth();

    public void setGrowth(float var1);

    public float getMaxGrowth();

    default public void grow(LivingEntity entity, float amount) {
        this.setGrowth(Math.min(this.getGrowth() + amount, this.getMaxGrowth()));
        if (this.getGrowth() >= this.getMaxGrowth()) {
            this.growUp(entity);
        }
    }

    public LivingEntity growInto();

    default public void growUp(LivingEntity entity) {
        Level world = entity.level();
        if (!world.isClientSide()) {
            LivingEntity newEntity = this.growInto();
            if (newEntity == null) {
                return;
            }
            newEntity.moveTo(entity.blockPosition(), entity.getYRot(), entity.getXRot());
            world.addFreshEntity((Entity)newEntity);
            entity.remove(Entity.RemovalReason.DISCARDED);
        }
    }

    default public float getGrowthNeededUntilGrowUp() {
        return this.getMaxGrowth() - this.getGrowth();
    }

    default public float getGrowthMultiplier() {
        return 1.0f;
    }
}

