/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.fabric;

import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.Iterables;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import java.util.function.Consumer;
import me.shedaniel.rei.RoughlyEnoughItemsInitializer;
import me.shedaniel.rei.RoughlyEnoughItemsState;
import me.shedaniel.rei.api.client.plugins.REIClientPlugin;
import me.shedaniel.rei.api.common.plugins.PluginManager;
import me.shedaniel.rei.api.common.plugins.PluginView;
import me.shedaniel.rei.api.common.plugins.REIPlugin;
import me.shedaniel.rei.api.common.plugins.REIPluginProvider;
import me.shedaniel.rei.api.common.plugins.REIServerPlugin;
import me.shedaniel.rei.impl.ClientInternals;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.entrypoint.EntrypointContainer;
import net.minecraft.class_437;
import net.minecraft.class_5632;

public class PluginDetectorImpl {
    private static <P extends REIPlugin<?>> void loadPlugin(Class<? extends P> pluginClass, Consumer<? super REIPluginProvider<P>> consumer) {
        block2: for (final EntrypointContainer container : Iterables.concat((Iterable[])new Iterable[]{FabricLoader.getInstance().getEntrypointContainers("rei_containers", REIPluginProvider.class), FabricLoader.getInstance().getEntrypointContainers("rei_server", REIPluginProvider.class), FabricLoader.getInstance().getEntrypointContainers("rei", REIPluginProvider.class), FabricLoader.getInstance().getEntrypointContainers("rei_common", REIPluginProvider.class), FabricLoader.getInstance().getEntrypointContainers("rei_plugins", REIPluginProvider.class), FabricLoader.getInstance().getEntrypointContainers("rei_plugins_v0", REIPluginProvider.class)})) {
            try {
                final REIPluginProvider plugin = (REIPluginProvider)container.getEntrypoint();
                if (!pluginClass.isAssignableFrom(plugin.getPluginProviderClass())) continue;
                consumer.accept(new REIPluginProvider<P>(){

                    @Override
                    public Collection<P> provide() {
                        return plugin.provide();
                    }

                    @Override
                    public Class<P> getPluginProviderClass() {
                        return plugin.getPluginProviderClass();
                    }

                    @Override
                    public String getPluginProviderName() {
                        return plugin.getPluginProviderName() + " [" + container.getProvider().getMetadata().getId() + "]";
                    }
                });
            }
            catch (Throwable t) {
                for (Throwable throwable = t; throwable != null; throwable = throwable.getCause()) {
                    if (throwable.getMessage() != null && throwable.getMessage().contains("environment type SERVER") && !RoughlyEnoughItemsInitializer.isClient()) continue block2;
                }
                String error = "Could not create REI Plugin [" + PluginDetectorImpl.getSimpleName(pluginClass) + "] due to errors, provided by '" + container.getProvider().getMetadata().getId() + "'!";
                new RuntimeException(error, t).printStackTrace();
                RoughlyEnoughItemsState.error(error);
            }
        }
    }

    private static <P> String getSimpleName(Class<? extends P> pluginClass) {
        String simpleName = pluginClass.getSimpleName();
        if (simpleName == null) {
            return pluginClass.getName();
        }
        return simpleName;
    }

    public static void detectServerPlugins() {
        PluginDetectorImpl.loadPlugin(REIServerPlugin.class, ((PluginView)((Object)PluginManager.getServerInstance()))::registerPlugin);
        try {
            PluginView.getServerInstance().registerPlugin((REIServerPlugin)Class.forName("me.shedaniel.rei.impl.common.compat.FabricFluidAPISupportPlugin").getConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    public static void detectCommonPlugins() {
        PluginDetectorImpl.loadPlugin(REIPlugin.class, ((PluginView)((Object)PluginManager.getInstance()))::registerPlugin);
    }

    @Environment(value=EnvType.CLIENT)
    public static void detectClientPlugins() {
        PluginDetectorImpl.loadPlugin(REIClientPlugin.class, ((PluginView)((Object)PluginManager.getClientInstance()))::registerPlugin);
        Supplier method = Suppliers.memoize(() -> {
            String methodName = FabricLoader.getInstance().getMappingResolver().mapMethodName("intermediary", "net.minecraft.class_437", "method_32635", "(Ljava/util/List;Lnet/minecraft/class_5632;)V");
            try {
                Method declaredMethod = class_437.class.getDeclaredMethod(methodName, List.class, class_5632.class);
                if (declaredMethod != null) {
                    declaredMethod.setAccessible(true);
                }
                return declaredMethod;
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException(e);
            }
        });
        ClientInternals.attachInstance((arg_0, arg_1) -> PluginDetectorImpl.lambda$detectClientPlugins$1((java.util.function.Supplier)method, arg_0, arg_1), "clientTooltipComponentProvider");
    }

    private static /* synthetic */ void lambda$detectClientPlugins$1(java.util.function.Supplier method, List lines, class_5632 component) {
        try {
            ((Method)method.get()).invoke(null, lines, component);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

