/*
 * Decompiled with CFR 0.152.
 */
package io.ejekta.bountiful.bounty.logic;

import io.ejekta.bountiful.bounty.BountyDataEntry;
import io.ejekta.bountiful.bounty.logic.IEntryLogic;
import io.ejekta.bountiful.bounty.logic.ItemTagLogic;
import io.ejekta.bountiful.bounty.logic.Progress;
import io.ejekta.kambrik.ext.ExtInventoryKt;
import io.ejekta.kambrik.text.TextBuilderDSLKt;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2554;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3489;
import net.minecraft.class_3494;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u0003\u001a\u0010\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u001c\u0010\u000b\u001a\u0010\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r0\f2\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u0011\u001a\u0012\u0012\f\u0012\n \u000e*\u0004\u0018\u00010\r0\r\u0018\u00010\u00122\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00160\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J \u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00142\u0006\u0010\t\u001a\u00020\nH\u0016J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001a\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016\u00a8\u0006\u001c"}, d2={"Lio/ejekta/bountiful/bounty/logic/ItemTagLogic;", "Lio/ejekta/bountiful/bounty/logic/IEntryLogic;", "()V", "getCurrentStacks", "", "Lnet/minecraft/item/ItemStack;", "", "entry", "Lio/ejekta/bountiful/bounty/BountyDataEntry;", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "getItems", "", "Lnet/minecraft/item/Item;", "kotlin.jvm.PlatformType", "getProgress", "Lio/ejekta/bountiful/bounty/logic/Progress;", "getTag", "Lnet/minecraft/tag/Tag;", "giveReward", "", "textBoard", "Lnet/minecraft/text/Text;", "textSummary", "isObj", "tryFinishObjective", "verifyValidity", "Lnet/minecraft/text/MutableText;", "BountifulFabric"})
public final class ItemTagLogic
implements IEntryLogic {
    @NotNull
    public static final ItemTagLogic INSTANCE = new ItemTagLogic();

    private ItemTagLogic() {
    }

    private final class_3494<class_1792> getTag(BountyDataEntry entry) {
        return class_3489.method_15106().method_30210(new class_2960(entry.getContent()));
    }

    @NotNull
    public final List<class_1792> getItems(@NotNull BountyDataEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        class_3494<class_1792> class_34942 = this.getTag(entry);
        List list = class_34942 == null ? null : class_34942.method_15138();
        return list == null ? CollectionsKt.emptyList() : list;
    }

    @Override
    @Nullable
    public class_5250 verifyValidity(@NotNull BountyDataEntry entry, @NotNull class_1657 player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        if (this.getTag(entry) == null) {
            return (class_5250)new class_2585("* '" + entry.getContent() + "' is not a valid tag!");
        }
        return null;
    }

    private final Map<class_1799, Integer> getCurrentStacks(BountyDataEntry entry, class_1657 player) {
        List<class_1792> validItems = this.getItems(entry);
        class_2371 class_23712 = player.method_31548().field_7547;
        Intrinsics.checkNotNullExpressionValue((Object)class_23712, (String)"player.inventory.main");
        return ExtInventoryKt.collect((List)((List)class_23712), (int)entry.getAmount(), (Function1)((Function1)new Function1<class_1799, Boolean>(validItems){
            final /* synthetic */ List<class_1792> $validItems;
            {
                this.$validItems = $validItems;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull class_1799 $this$collect) {
                Intrinsics.checkNotNullParameter((Object)$this$collect, (String)"$this$collect");
                return this.$validItems.contains($this$collect.method_7909());
            }
        }));
    }

    @Override
    @NotNull
    public class_2561 textSummary(@NotNull BountyDataEntry entry, boolean isObj, @NotNull class_1657 player) {
        class_2561 class_25612;
        class_2554 class_25542;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Progress progress = this.getProgress(entry, player);
        if (entry.getTranslation() != null) {
            class_25542 = (class_2554)new class_2588(entry.getTranslation());
        } else {
            String string = entry.getName();
            if (string == null) {
                string = entry.getContent();
            }
            class_25542 = (class_2554)new class_2585(string);
        }
        class_2554 title = class_25542;
        boolean bl = isObj;
        if (bl) {
            class_5250 class_52502 = title.method_27653().method_27692(progress.getColor()).method_10852((class_2561)this.colored((class_2561)progress.getNeededText(), class_124.field_1068));
            Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"title.copy().formatted(p\u2026olored(Formatting.WHITE))");
            class_25612 = (class_2561)class_52502;
        } else if (!bl) {
            class_5250 class_52503 = progress.getGivingText().method_10852((class_2561)this.colored((class_2561)title, entry.getRarity().getColor()));
            Intrinsics.checkNotNullExpressionValue((Object)class_52503, (String)"progress.givingText.appe\u2026ored(entry.rarity.color))");
            class_25612 = (class_2561)class_52503;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return class_25612;
    }

    @Override
    @NotNull
    public List<class_2561> textBoard(@NotNull BountyDataEntry entry, @NotNull class_1657 player) {
        class_2554 class_25542;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Object[] objectArray = new class_2554[2];
        if (entry.getTranslation() != null) {
            String string = entry.getTranslation();
            Intrinsics.checkNotNull((Object)string);
            class_25542 = (class_2554)TextBuilderDSLKt.textTranslate$default((String)string, null, (int)2, null);
        } else {
            class_25542 = (class_2554)TextBuilderDSLKt.textLiteral$default((String)"Item Tag", null, (int)2, null);
        }
        objectArray[0] = class_25542;
        objectArray[1] = (class_2554)TextBuilderDSLKt.textLiteral((String)entry.getContent(), (Function1)textBoard.1.INSTANCE);
        return CollectionsKt.listOf((Object[])objectArray);
    }

    @Override
    @NotNull
    public Progress getProgress(@NotNull BountyDataEntry entry, @NotNull class_1657 player) {
        int n;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Map<class_1799, Integer> map = this.getCurrentStacks(entry, player);
        if (map == null) {
            n = 0;
        } else {
            int n2;
            Collection<Integer> collection = map.values();
            n = collection == null ? 0 : (n2 = CollectionsKt.sumOfInt((Iterable)collection));
        }
        return new Progress(n, entry.getAmount(), 0, 4, null);
    }

    @Override
    public boolean tryFinishObjective(@NotNull BountyDataEntry entry, @NotNull class_1657 player) {
        boolean bl;
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Map<class_1799, Integer> map = this.getCurrentStacks(entry, player);
        if (map == null) {
            bl = false;
        } else {
            boolean bl2;
            Map<class_1799, Integer> it = map;
            boolean bl3 = false;
            Map<class_1799, Integer> $this$forEach$iv = it;
            boolean $i$f$forEach = false;
            Map<class_1799, Integer> map2 = $this$forEach$iv;
            Iterator<Map.Entry<class_1799, Integer>> iterator = map2.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<class_1799, Integer> element$iv;
                Map.Entry<class_1799, Integer> $dstr$stack$toShrink = element$iv = iterator.next();
                boolean bl4 = false;
                class_1799 stack = $dstr$stack$toShrink.getKey();
                int toShrink = ((Number)$dstr$stack$toShrink.getValue()).intValue();
                stack.method_7934(toShrink);
            }
            bl = bl2 = true;
        }
        return bl;
    }

    @Override
    public boolean giveReward(@NotNull BountyDataEntry entry, @NotNull class_1657 player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return false;
    }

    @Override
    public void setup(@NotNull BountyDataEntry entry, @NotNull class_3218 world, @NotNull class_2338 pos) {
        IEntryLogic.DefaultImpls.setup(this, entry, world, pos);
    }

    @Override
    @NotNull
    public class_2561 getDescription(@NotNull BountyDataEntry entry) {
        return IEntryLogic.DefaultImpls.getDescription(this, entry);
    }

    @Override
    public boolean isDone(@NotNull Pair<Integer, Integer> $this$isDone) {
        return IEntryLogic.DefaultImpls.isDone(this, $this$isDone);
    }

    @Override
    @NotNull
    public class_124 getColor(@NotNull Pair<Integer, Integer> $this$color) {
        return IEntryLogic.DefaultImpls.getColor(this, $this$color);
    }

    @Override
    @NotNull
    public class_5250 colored(@NotNull class_2561 $this$colored, @NotNull Pair<Integer, Integer> progress) {
        return IEntryLogic.DefaultImpls.colored((IEntryLogic)this, $this$colored, progress);
    }

    @Override
    @NotNull
    public class_5250 colored(@NotNull class_2561 $this$colored, @NotNull class_124 formatting) {
        return IEntryLogic.DefaultImpls.colored((IEntryLogic)this, $this$colored, formatting);
    }

    @Override
    @NotNull
    public class_2585 getNeeded(@NotNull Pair<Integer, Integer> $this$needed) {
        return IEntryLogic.DefaultImpls.getNeeded(this, $this$needed);
    }

    @Override
    @NotNull
    public class_2585 getGiving(@NotNull Pair<Integer, Integer> $this$giving) {
        return IEntryLogic.DefaultImpls.getGiving(this, $this$giving);
    }
}

