/*
 * Decompiled with CFR 0.152.
 */
package io.ejekta.bountiful.bounty.logic;

import io.ejekta.bountiful.bounty.BountyData;
import io.ejekta.bountiful.bounty.BountyDataEntry;
import io.ejekta.bountiful.bounty.BountyType;
import io.ejekta.bountiful.bounty.logic.IEntryLogic;
import io.ejekta.bountiful.bounty.logic.Progress;
import io.ejekta.bountiful.content.BountyItem;
import io.ejekta.kambrik.ext.ExtRegIdKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import net.minecraft.class_124;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u0006\u0012\u0002\b\u00030\n2\u0006\u0010\u0007\u001a\u00020\bJ\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0016\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0016\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0006J\u001e\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001a2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\u001d\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0018\u0010\u001e\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u001a\u0010\u001f\u001a\u0004\u0018\u00010 2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000eH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lio/ejekta/bountiful/bounty/logic/EntityLogic;", "Lio/ejekta/bountiful/bounty/logic/IEntryLogic;", "()V", "entityKillsKey", "", "getEntityKills", "", "entry", "Lio/ejekta/bountiful/bounty/BountyDataEntry;", "getEntityType", "Lnet/minecraft/entity/EntityType;", "getProgress", "Lio/ejekta/bountiful/bounty/logic/Progress;", "player", "Lnet/minecraft/entity/player/PlayerEntity;", "giveReward", "", "incrementEntityBounties", "", "playerEntity", "Lnet/minecraft/server/network/ServerPlayerEntity;", "killedEntity", "Lnet/minecraft/entity/LivingEntity;", "setEntityKills", "value", "textBoard", "", "Lnet/minecraft/text/Text;", "textSummary", "isObj", "tryFinishObjective", "verifyValidity", "Lnet/minecraft/text/MutableText;", "BountifulFabric"})
public final class EntityLogic
implements IEntryLogic {
    @NotNull
    public static final EntityLogic INSTANCE = new EntityLogic();
    @NotNull
    private static final String entityKillsKey = "kills";

    private EntityLogic() {
    }

    @NotNull
    public final class_1299<?> getEntityType(@NotNull BountyDataEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Object object = class_2378.field_11145.method_10223(new class_2960(entry.getContent()));
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ENTITY_TYPE.get(Identifier(entry.content))");
        return (class_1299)object;
    }

    public final int getEntityKills(@NotNull BountyDataEntry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        return entry.getTracking().method_10550(entityKillsKey);
    }

    public final void setEntityKills(@NotNull BountyDataEntry entry, int value) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        entry.getTracking().method_10569(entityKillsKey, value);
    }

    @Override
    @Nullable
    public class_5250 verifyValidity(@NotNull BountyDataEntry entry, @NotNull class_1657 player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        class_2960 id = ExtRegIdKt.getIdentifier(this.getEntityType(entry));
        if (!Intrinsics.areEqual((Object)id, (Object)new class_2960(entry.getContent()))) {
            return (class_5250)new class_2585("* '" + entry.getContent() + "' is not a valid entity!");
        }
        return null;
    }

    @Override
    @NotNull
    public class_2561 textSummary(@NotNull BountyDataEntry entry, boolean isObj, @NotNull class_1657 player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        Progress progress = this.getProgress(entry, player);
        boolean bl = isObj;
        if (!bl) {
            if (!bl) {
                throw (Throwable)new IllegalStateException(("Cannot have an entity (" + entry.getContent() + ") as a reward.").toString());
            }
            throw new NoWhenBranchMatchedException();
        }
        class_5250 class_52502 = new class_2585("Kill ").method_10852((class_2561)this.getEntityType(entry).method_5897().method_27662()).method_27692(progress.getColor()).method_10852((class_2561)this.colored((class_2561)progress.getNeededText(), class_124.field_1068));
        Intrinsics.checkNotNullExpressionValue((Object)class_52502, (String)"LiteralText(\"Kill \").app\u2026ting.WHITE)\n            )");
        return (class_2561)class_52502;
    }

    @Override
    @NotNull
    public List<class_2561> textBoard(@NotNull BountyDataEntry entry, @NotNull class_1657 player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return CollectionsKt.listOf((Object)this.getEntityType(entry).method_5897());
    }

    @Override
    @NotNull
    public Progress getProgress(@NotNull BountyDataEntry entry, @NotNull class_1657 player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return new Progress(this.getEntityKills(entry), entry.getAmount(), 0, 4, null);
    }

    @Override
    public boolean tryFinishObjective(@NotNull BountyDataEntry entry, @NotNull class_1657 player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return this.getEntityKills(entry) >= entry.getAmount();
    }

    @Override
    public boolean giveReward(@NotNull BountyDataEntry entry, @NotNull class_1657 player) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        Intrinsics.checkNotNullParameter((Object)player, (String)"player");
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void incrementEntityBounties(@NotNull class_3222 playerEntity, @NotNull class_1309 killedEntity) {
        void $this$filterTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)playerEntity, (String)"playerEntity");
        Intrinsics.checkNotNullParameter((Object)killedEntity, (String)"killedEntity");
        class_2371 class_23712 = playerEntity.method_31548().field_7547;
        Intrinsics.checkNotNullExpressionValue((Object)class_23712, (String)"playerEntity.inventory.main");
        Iterable $this$filter$iv = (Iterable)class_23712;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            class_1799 it = (class_1799)element$iv$iv;
            boolean bl = false;
            if (!(it.method_7909() instanceof BountyItem)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            class_1799 stack = (class_1799)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNullExpressionValue((Object)stack, (String)"stack");
            BountyData.Companion.editIf(stack, (Function1)new Function1<BountyData, Boolean>(killedEntity){
                final /* synthetic */ class_1309 $killedEntity;
                {
                    this.$killedEntity = $killedEntity;
                    super(1);
                }

                /*
                 * WARNING - void declaration
                 */
                @NotNull
                public final Boolean invoke(@NotNull BountyData $this$editIf) {
                    void $this$filterTo$iv$iv;
                    Intrinsics.checkNotNullParameter((Object)$this$editIf, (String)"$this$editIf");
                    boolean didWork = false;
                    Iterable $this$filter$iv = $this$editIf.getObjectives();
                    boolean $i$f$filter = false;
                    Iterable iterable = $this$filter$iv;
                    Collection destination$iv$iv = new ArrayList<E>();
                    boolean $i$f$filterTo = false;
                    for (T element$iv$iv : $this$filterTo$iv$iv) {
                        BountyDataEntry it = (BountyDataEntry)element$iv$iv;
                        boolean bl = false;
                        if (!(it.getType() == BountyType.ENTITY)) continue;
                        destination$iv$iv.add(element$iv$iv);
                    }
                    List entityObjectives = (List)destination$iv$iv;
                    if (entityObjectives.isEmpty()) {
                        return false;
                    }
                    for (BountyDataEntry obj : entityObjectives) {
                        String string = obj.getContent();
                        iterable = this.$killedEntity.method_5864();
                        Intrinsics.checkNotNullExpressionValue((Object)iterable, (String)"killedEntity.type");
                        if (!Intrinsics.areEqual((Object)string, (Object)ExtRegIdKt.getIdentifier((class_1299)iterable).toString())) continue;
                        obj.getTracking().method_10569("kills", RangesKt.coerceAtMost((int)(obj.getTracking().method_10550("kills") + 1), (int)obj.getAmount()));
                        didWork = true;
                    }
                    return didWork;
                }
            });
        }
    }

    @Override
    public void setup(@NotNull BountyDataEntry entry, @NotNull class_3218 world, @NotNull class_2338 pos) {
        IEntryLogic.DefaultImpls.setup(this, entry, world, pos);
    }

    @Override
    @NotNull
    public class_2561 getDescription(@NotNull BountyDataEntry entry) {
        return IEntryLogic.DefaultImpls.getDescription(this, entry);
    }

    @Override
    public boolean isDone(@NotNull Pair<Integer, Integer> $this$isDone) {
        return IEntryLogic.DefaultImpls.isDone(this, $this$isDone);
    }

    @Override
    @NotNull
    public class_124 getColor(@NotNull Pair<Integer, Integer> $this$color) {
        return IEntryLogic.DefaultImpls.getColor(this, $this$color);
    }

    @Override
    @NotNull
    public class_5250 colored(@NotNull class_2561 $this$colored, @NotNull Pair<Integer, Integer> progress) {
        return IEntryLogic.DefaultImpls.colored((IEntryLogic)this, $this$colored, progress);
    }

    @Override
    @NotNull
    public class_5250 colored(@NotNull class_2561 $this$colored, @NotNull class_124 formatting) {
        return IEntryLogic.DefaultImpls.colored((IEntryLogic)this, $this$colored, formatting);
    }

    @Override
    @NotNull
    public class_2585 getNeeded(@NotNull Pair<Integer, Integer> $this$needed) {
        return IEntryLogic.DefaultImpls.getNeeded(this, $this$needed);
    }

    @Override
    @NotNull
    public class_2585 getGiving(@NotNull Pair<Integer, Integer> $this$giving) {
        return IEntryLogic.DefaultImpls.getGiving(this, $this$giving);
    }
}

