/*
 * Decompiled with CFR 0.152.
 */
package wraith.waystones.util;

import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import wraith.waystones.Waystones;
import wraith.waystones.access.PlayerEntityMixinAccess;
import wraith.waystones.block.WaystoneBlock;
import wraith.waystones.block.WaystoneBlockEntity;
import wraith.waystones.util.Config;
import wraith.waystones.util.Utils;

public final class WaystonePacketHandler {
    public static final class_2960 REMOVE_WAYSTONE_OWNER = Utils.ID("remove_waystone_owner");
    public static final class_2960 WAYSTONE_GUI_SLOT_CLICK = Utils.ID("waystone_gui_slot_click");
    public static final class_2960 RENAME_WAYSTONE = Utils.ID("rename_waystone");
    public static final class_2960 FORGET_WAYSTONE = Utils.ID("forget_waystone");
    public static final class_2960 TELEPORT_TO_WAYSTONE = Utils.ID("teleport_to_waystone");
    public static final class_2960 SYNC_PLAYER_FROM_CLIENT = Utils.ID("sync_player_from_client");
    public static final class_2960 TOGGLE_GLOBAL_WAYSTONE = Utils.ID("toggle_global_waystone");
    public static final class_2960 REQUEST_PLAYER_SYNC = Utils.ID("request_player_waystone_update");

    private WaystonePacketHandler() {
    }

    public static void registerPacketHandlers() {
        ServerPlayNetworking.registerGlobalReceiver((class_2960)REMOVE_WAYSTONE_OWNER, (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            server.execute(() -> {
                if (tag == null || !tag.method_10545("waystone_hash") || !tag.method_10545("waystone_owner")) {
                    return;
                }
                String hash = tag.method_10558("waystone_hash");
                UUID owner = tag.method_25926("waystone_owner");
                if (player.method_5667().equals(owner) || player.method_5687(2)) {
                    Waystones.WAYSTONE_STORAGE.setOwner(hash, null);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)WAYSTONE_GUI_SLOT_CLICK, (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            server.execute(() -> {
                if (tag == null || !tag.method_10545("sync_id") || !tag.method_10545("clicked_slot")) {
                    return;
                }
                int syncId = tag.method_10550("sync_id");
                int button = tag.method_10550("clicked_slot");
                if (player.field_7512.field_7763 == syncId) {
                    player.field_7512.method_7604((class_1657)player, button);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)RENAME_WAYSTONE, (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            if (!(tag != null && tag.method_10545("waystone_name") && tag.method_10545("waystone_hash") && tag.method_10545("waystone_owner"))) {
                return;
            }
            String name = tag.method_10558("waystone_name");
            String hash = tag.method_10558("waystone_hash");
            UUID owner = tag.method_25926("waystone_owner");
            server.execute(() -> {
                if (Waystones.WAYSTONE_STORAGE.containsHash(hash) && (player.method_5667().equals(owner) && owner.equals(Waystones.WAYSTONE_STORAGE.getWaystone(hash).getOwner()) || player.method_5687(2))) {
                    Waystones.WAYSTONE_STORAGE.renameWaystone(hash, name);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)FORGET_WAYSTONE, (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            if (tag == null || !tag.method_10545("waystone_hash")) {
                return;
            }
            String hash = tag.method_10558("waystone_hash");
            server.execute(() -> {
                WaystoneBlockEntity waystone = Waystones.WAYSTONE_STORAGE.getWaystone(hash);
                if (waystone == null || waystone.isGlobal()) {
                    return;
                }
                if (player.method_5667().equals(waystone.getOwner())) {
                    waystone.setOwner(null);
                }
                ((PlayerEntityMixinAccess)player).forgetWaystone(hash);
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)REQUEST_PLAYER_SYNC, (server, player, networkHandler, data, sender) -> server.execute(((PlayerEntityMixinAccess)player)::syncData));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TOGGLE_GLOBAL_WAYSTONE, (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            if (tag == null || !tag.method_10545("waystone_hash") || !tag.method_10545("waystone_owner")) {
                return;
            }
            if (!Config.getInstance().canPlayersToggleGlobal() && !player.method_5687(2)) {
                return;
            }
            server.execute(() -> {
                String hash = tag.method_10558("waystone_hash");
                UUID owner = tag.method_25926("waystone_owner");
                if (Waystones.WAYSTONE_STORAGE.containsHash(hash) && (player.method_5667().equals(owner) && owner.equals(Waystones.WAYSTONE_STORAGE.getWaystone(hash).getOwner()) || player.method_5687(2))) {
                    Waystones.WAYSTONE_STORAGE.toggleGlobal(hash);
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SYNC_PLAYER_FROM_CLIENT, (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            server.execute(() -> ((PlayerEntityMixinAccess)player).fromTagW(tag));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TELEPORT_TO_WAYSTONE, (server, player, networkHandler, data, sender) -> {
            class_2487 tag = data.method_10798();
            if (tag == null || !tag.method_10545("waystone_hash")) {
                return;
            }
            server.execute(() -> {
                if (!tag.method_10545("waystone_hash")) {
                    return;
                }
                String hash = tag.method_10558("waystone_hash");
                WaystoneBlockEntity waystone = Waystones.WAYSTONE_STORAGE.getWaystone(hash);
                if (waystone == null) {
                    return;
                }
                if (waystone.method_10997() != null && !(waystone.method_10997().method_8320(waystone.method_11016()).method_26204() instanceof WaystoneBlock)) {
                    Waystones.WAYSTONE_STORAGE.removeWaystone(hash);
                    waystone.method_10997().method_8544(waystone.method_11016());
                } else {
                    waystone.teleportPlayer((class_1657)player, true);
                }
            });
        });
    }
}

