/*
 * Decompiled with CFR 0.152.
 */
package wraith.waystones.util;

import com.mojang.datafixers.util.Pair;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1282;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1702;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2791;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_3443;
import net.minecraft.class_3781;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_4076;
import net.minecraft.class_5138;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;
import wraith.waystones.Waystones;
import wraith.waystones.access.StructurePiecesListAccess;
import wraith.waystones.block.WaystoneBlockEntity;
import wraith.waystones.mixin.SinglePoolElementAccessor;
import wraith.waystones.mixin.StructurePoolAccessor;
import wraith.waystones.mixin.StructureStartAccessor;
import wraith.waystones.util.Config;
import wraith.waystones.util.WaystonesWorldgen;

public final class Utils {
    public static final Random random = new Random();
    public static final DecimalFormat df = new DecimalFormat("#.##");

    private Utils() {
    }

    public static int getRandomIntInRange(int min, int max) {
        return random.nextInt(max - min + 1) + min;
    }

    public static class_2960 ID(String id) {
        return new class_2960("waystones", id);
    }

    public static String generateWaystoneName(String id) {
        return id == null || "".equals(id) ? Utils.generateUniqueId() : id;
    }

    private static String generateUniqueId() {
        if (random.nextDouble() < 1.0E-4) {
            return "DeatHunter was here";
        }
        StringBuilder sb = new StringBuilder();
        char[] vowels = new char[]{'a', 'e', 'i', 'o', 'u'};
        char[] consonants = new char[]{'b', 'c', 'd', 'f', 'g', 'h', 'j', 'k', 'l', 'm', 'n', 'p', 'q', 'r', 's', 't', 'v', 'w', 'x', 'y', 'z'};
        for (int i = 0; i < 4; ++i) {
            char consonant = consonants[random.nextInt(consonants.length)];
            if (i == 0) {
                consonant = Character.toUpperCase(consonant);
            }
            sb.append(consonant);
            sb.append(vowels[random.nextInt(vowels.length)]);
        }
        return sb.toString();
    }

    public static void addToStructurePool(MinecraftServer server, class_2960 village, class_2960 waystone, int weight) {
        Optional<Map.Entry> poolGetter = server.method_30611().method_30530(class_2378.field_25917).method_29722().stream().filter(p -> ((class_5321)p.getKey()).method_29177().equals((Object)village)).findFirst();
        if (poolGetter.isEmpty()) {
            Waystones.LOGGER.error("Cannot add to " + village + " as it cannot be found!");
            return;
        }
        class_3785 pool = (class_3785)poolGetter.get().getValue();
        List<class_3784> pieceList = ((StructurePoolAccessor)pool).getElements();
        class_3781 piece = (class_3781)class_3784.method_30434((String)waystone.toString()).apply(class_3785.class_3786.field_16687);
        ArrayList<Pair<class_3784, Integer>> list = new ArrayList<Pair<class_3784, Integer>>(((StructurePoolAccessor)pool).getElementCounts());
        list.add((Pair<class_3784, Integer>)Pair.of((Object)piece, (Object)weight));
        ((StructurePoolAccessor)pool).setElementCounts(list);
        for (int i = 0; i < weight; ++i) {
            pieceList.add((class_3784)piece);
        }
    }

    public static long determineLevelXP(class_1657 player) {
        int level = player.field_7520;
        long total = player.field_7495;
        total = level <= 16 ? (total += (long)(Math.pow(level, 2.0) + (double)(6L * (long)level))) : (level <= 31 ? (total += (long)(2.5 * Math.pow(level, 2.0) - 40.5 * (double)level + 360.0)) : (total += (long)(4.5 * Math.pow(level, 2.0) - 162.5 * (double)level + 2220.0)));
        return total;
    }

    public static boolean canTeleport(class_1657 player, String hash, boolean takeCost) {
        String cost = Config.getInstance().teleportType();
        int amount = Config.getInstance().teleportCost();
        if (player.method_7337()) {
            return true;
        }
        switch (cost) {
            case "hp": 
            case "health": {
                if (player.method_6032() + player.method_6067() <= (float)amount) {
                    return false;
                }
                if (takeCost) {
                    player.method_5643(class_1282.field_5849, (float)amount);
                }
                return true;
            }
            case "hunger": 
            case "saturation": {
                class_1702 hungerManager = player.method_7344();
                float hungerAndExhaustion = (float)hungerManager.method_7586() + hungerManager.method_7589();
                if (hungerAndExhaustion <= 10.0f || hungerAndExhaustion + hungerManager.method_35219() / 4.0f <= (float)amount) {
                    return false;
                }
                if (takeCost) {
                    hungerManager.method_7583((float)(4 * amount));
                }
                return true;
            }
            case "xp": 
            case "experience": {
                long total = Utils.determineLevelXP(player);
                if (total < (long)amount) {
                    return false;
                }
                if (takeCost) {
                    player.method_7255(-amount);
                }
                return true;
            }
            case "level": {
                if (player.field_7520 < amount) {
                    return false;
                }
                if (takeCost) {
                    player.field_7520 -= amount;
                }
                return true;
            }
            case "item": {
                class_2960 itemId = Config.getInstance().teleportCostItem();
                class_1792 item = (class_1792)class_2378.field_11142.method_10223(itemId);
                if (!Utils.containsItem(player.method_31548(), item, amount)) {
                    return false;
                }
                if (takeCost) {
                    Utils.removeItem(player.method_31548(), (class_1792)class_2378.field_11142.method_10223(itemId), amount);
                    if (player.field_6002.field_9236 || Waystones.WAYSTONE_STORAGE == null) {
                        return true;
                    }
                    WaystoneBlockEntity waystone = Waystones.WAYSTONE_STORAGE.getWaystone(hash);
                    if (waystone == null) {
                        return true;
                    }
                    ArrayList<class_1799> oldInventory = new ArrayList<class_1799>((Collection<class_1799>)waystone.getInventory());
                    boolean found = false;
                    for (class_1799 stack : oldInventory) {
                        if (stack.method_7909() != item) continue;
                        stack.method_7933(amount);
                        found = true;
                        break;
                    }
                    if (!found) {
                        oldInventory.add(new class_1799((class_1935)class_2378.field_11142.method_10223(itemId), amount));
                    }
                    waystone.setInventory(oldInventory);
                }
                return true;
            }
        }
        return true;
    }

    private static boolean containsItem(class_1661 inventory, class_1792 item, int maxAmount) {
        int amount = 0;
        for (class_1799 stack : inventory.field_7547) {
            if (!stack.method_7909().equals(item)) continue;
            amount += stack.method_7947();
        }
        for (class_1799 stack : inventory.field_7544) {
            if (!stack.method_7909().equals(item)) continue;
            amount += stack.method_7947();
        }
        for (class_1799 stack : inventory.field_7548) {
            if (!stack.method_7909().equals(item)) continue;
            amount += stack.method_7947();
        }
        return amount >= maxAmount;
    }

    private static void removeItem(class_1661 inventory, class_1792 item, int totalAmount) {
        int amount;
        for (class_1799 stack : inventory.field_7547) {
            if (stack.method_7909().equals(item)) {
                amount = stack.method_7947();
                stack.method_7934(totalAmount);
                totalAmount -= amount;
            }
            if (totalAmount > 0) continue;
            return;
        }
        for (class_1799 stack : inventory.field_7544) {
            if (stack.method_7909().equals(item)) {
                amount = stack.method_7947();
                stack.method_7934(totalAmount);
                totalAmount -= amount;
            }
            if (totalAmount > 0) continue;
            return;
        }
        for (class_1799 stack : inventory.field_7548) {
            if (stack.method_7909().equals(item)) {
                amount = stack.method_7947();
                stack.method_7934(totalAmount);
                totalAmount -= amount;
            }
            if (totalAmount > 0) continue;
            return;
        }
    }

    public static String getSHA256(String data) {
        try {
            return Arrays.toString(MessageDigest.getInstance("SHA-256").digest(data.getBytes(StandardCharsets.UTF_8)));
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return "";
        }
    }

    public static class_5138 populateNoise(class_5138 accessor, class_2791 chunk) {
        if (!Config.getInstance().generateInVillages()) {
            return accessor;
        }
        class_1923 chunkPos = chunk.method_12004();
        for (int i = 0; i < class_3195.field_24861.size(); ++i) {
            class_3195 structureFeature = (class_3195)class_3195.field_24861.get(i);
            AtomicInteger waystones = new AtomicInteger(0);
            accessor.method_38853(class_4076.method_18681((class_1923)chunkPos, (int)0), structureFeature).forEach(structures -> {
                ArrayList<class_3443> oldStructurePieces = new ArrayList<class_3443>(structures.method_14963());
                ArrayList<Integer> toRemove = new ArrayList<Integer>();
                for (int j = 0; j < oldStructurePieces.size(); ++j) {
                    class_3443 structure = (class_3443)oldStructurePieces.get(j);
                    if (!(structure instanceof class_3790)) continue;
                    class_3790 poolStructurePiece = (class_3790)structure;
                    if (!(((class_3790)structure).method_16644() instanceof class_3781) || !WaystonesWorldgen.WAYSTONE_STRUCTURES.contains(((SinglePoolElementAccessor)poolStructurePiece.method_16644()).getLocation().left().get()) || waystones.getAndIncrement() <= 0) continue;
                    toRemove.add(j);
                }
                toRemove.sort(Collections.reverseOrder());
                Iterator iterator = toRemove.iterator();
                while (iterator.hasNext()) {
                    int remove = (Integer)iterator.next();
                    oldStructurePieces.remove(remove);
                }
                ((StructurePiecesListAccess)((StructureStartAccessor)structures).getChildren()).setPieces(oldStructurePieces);
            });
        }
        return accessor;
    }
}

