/*
 * Decompiled with CFR 0.152.
 */
package wraith.waystones.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.util.Map;
import java.util.Scanner;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;
import wraith.waystones.Waystones;

public final class Config {
    private static Config instance = null;
    public class_2487 configData;
    private final Logger LOGGER = Waystones.LOGGER;
    private static final String CONFIG_FILE = "config/waystones/config.json";
    private int difference = 0;

    private Config() {
    }

    public static Config getInstance() {
        if (instance == null) {
            instance = new Config();
        }
        return instance;
    }

    public boolean generateInVillages() {
        return this.configData.method_10577("generate_in_villages");
    }

    public boolean canOwnersRedeemPayments() {
        return this.configData.method_10577("can_owners_redeem_payments");
    }

    public boolean canPlayersToggleGlobal() {
        return this.configData.method_10577("can_players_toggle_global_mode");
    }

    @Nullable
    public class_2960 teleportCostItem() {
        if ("item".equals(this.configData.method_10558("cost_type"))) {
            String[] item = this.configData.method_10558("cost_item").split(":");
            return item.length == 2 ? new class_2960(item[0], item[1]) : new class_2960(item[0]);
        }
        return null;
    }

    public boolean storeWaystoneNbt() {
        return true;
    }

    public String teleportType() {
        return this.configData.method_10558("cost_type");
    }

    public int teleportCost() {
        return Math.abs(this.configData.method_10550("cost_amount"));
    }

    public float getHardness() {
        return this.configData.method_10583("waystone_block_hardness");
    }

    public int getMiningLevel() {
        return this.configData.method_10550("waystone_block_required_mining_level");
    }

    public boolean consumeInfiniteScroll() {
        return this.configData.method_10577("consume_infinite_knowledge_scroll_on_use");
    }

    public boolean consumeLocalVoid() {
        return this.configData.method_10577("consume_local_void_on_use");
    }

    public boolean areLocalVoidsFree() {
        return this.configData.method_10577("free_local_void_teleport");
    }

    public boolean preventNonOwnersFromBreaking() {
        return this.configData.method_10577("prevent_non_owners_from_breaking_waystone");
    }

    public int getCooldownWhenHurt() {
        return this.configData.method_10562("teleportation_cooldown").method_10550("cooldown_ticks_when_hurt");
    }

    public int getCooldownFromAbyssWatcher() {
        return this.configData.method_10562("teleportation_cooldown").method_10550("cooldown_ticks_from_abyss_watcher");
    }

    public int getCooldownFromPocketWormhole() {
        return this.configData.method_10562("teleportation_cooldown").method_10550("cooldown_ticks_from_pocket_wormhole");
    }

    public int getCooldownFromLocalVoid() {
        return this.configData.method_10562("teleportation_cooldown").method_10550("cooldown_ticks_from_local_void");
    }

    public int getCooldownFromWaystone() {
        return this.configData.method_10562("teleportation_cooldown").method_10550("cooldown_ticks_from_waystone");
    }

    public int getIntOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10550(key);
        }
        ++this.difference;
        return defaults.method_10550(key);
    }

    public boolean getBooleanOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10577(key);
        }
        ++this.difference;
        return defaults.method_10577(key);
    }

    private String getStringOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10558(key);
        }
        ++this.difference;
        return defaults.method_10558(key);
    }

    private class_2487 getCompoundOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10562(key);
        }
        ++this.difference;
        return defaults.method_10562(key);
    }

    private double getDoubleOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10574(key);
        }
        ++this.difference;
        return defaults.method_10574(key);
    }

    private float getFloatOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10583(key);
        }
        ++this.difference;
        return defaults.method_10583(key);
    }

    public int getIntOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsInt();
        }
        ++this.difference;
        return defaults.method_10550(key);
    }

    public boolean getBooleanOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsBoolean();
        }
        ++this.difference;
        return defaults.method_10577(key);
    }

    private String getStringOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsString();
        }
        ++this.difference;
        return defaults.method_10558(key);
    }

    private double getDoubleOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsDouble();
        }
        ++this.difference;
        return defaults.method_10574(key);
    }

    private float getFloatOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsFloat();
        }
        ++this.difference;
        return defaults.method_10583(key);
    }

    private class_2487 getDefaults() {
        class_2487 defaultConfig = new class_2487();
        defaultConfig.method_10556("generate_in_villages", true);
        defaultConfig.method_10556("consume_infinite_knowledge_scroll_on_use", false);
        defaultConfig.method_10556("consume_local_void_on_use", true);
        defaultConfig.method_10556("free_local_void_teleport", true);
        defaultConfig.method_10556("can_owners_redeem_payments", false);
        defaultConfig.method_10556("store_waystone_data_on_sneak_break", true);
        defaultConfig.method_10569("cost_amount", 1);
        defaultConfig.method_10582("cost_type", "level");
        defaultConfig.method_10582("cost_item", "minecraft:ender_pearl");
        defaultConfig.method_10548("waystone_block_hardness", 4.0f);
        defaultConfig.method_10569("waystone_block_required_mining_level", 1);
        defaultConfig.method_10556("prevent_non_owners_from_breaking_waystone", false);
        defaultConfig.method_10556("can_players_toggle_global_mode", true);
        class_2487 cooldown = new class_2487();
        cooldown.method_10569("cooldown_ticks_when_hurt", 0);
        cooldown.method_10569("cooldown_ticks_from_abyss_watcher", 0);
        cooldown.method_10569("cooldown_ticks_from_pocket_wormhole", 0);
        cooldown.method_10569("cooldown_ticks_from_local_void", 0);
        cooldown.method_10569("cooldown_ticks_from_waystone", 0);
        defaultConfig.method_10566("teleportation_cooldown", (class_2520)cooldown);
        return defaultConfig;
    }

    private JsonObject toJson(class_2487 tag) {
        JsonObject json = new JsonObject();
        class_2487 defaults = this.getDefaults();
        json.addProperty("generate_in_villages", Boolean.valueOf(this.getBooleanOrDefault(tag, "generate_in_villages", defaults)));
        json.addProperty("consume_infinite_knowledge_scroll_on_use", Boolean.valueOf(this.getBooleanOrDefault(tag, "consume_infinite_knowledge_scroll_on_use", defaults)));
        json.addProperty("consume_local_void_on_use", Boolean.valueOf(this.getBooleanOrDefault(tag, "consume_local_void_on_use", defaults)));
        json.addProperty("free_local_void_teleport", Boolean.valueOf(this.getBooleanOrDefault(tag, "free_local_void_teleport", defaults)));
        json.addProperty("store_waystone_data_on_sneak_break", Boolean.valueOf(this.getBooleanOrDefault(tag, "store_waystone_data_on_sneak_break", defaults)));
        json.addProperty("can_owners_redeem_payments", Boolean.valueOf(this.getBooleanOrDefault(tag, "can_owners_redeem_payments", defaults)));
        json.addProperty("cost_amount", (Number)this.getIntOrDefault(tag, "cost_amount", defaults));
        json.addProperty("cost_type", this.getStringOrDefault(tag, "cost_type", defaults));
        json.addProperty("cost_item", this.getStringOrDefault(tag, "cost_item", defaults));
        json.addProperty("waystone_block_hardness", (Number)Float.valueOf(this.getFloatOrDefault(tag, "waystone_block_hardness", defaults)));
        json.addProperty("waystone_block_required_mining_level", (Number)this.getIntOrDefault(tag, "waystone_block_required_mining_level", defaults));
        json.addProperty("prevent_non_owners_from_breaking_waystone", Boolean.valueOf(this.getBooleanOrDefault(tag, "prevent_non_owners_from_breaking_waystone", defaults)));
        json.addProperty("can_players_toggle_global_mode", Boolean.valueOf(this.getBooleanOrDefault(tag, "can_players_toggle_global_mode", defaults)));
        JsonObject cooldownsJson = new JsonObject();
        class_2487 cooldownsTag = this.getCompoundOrDefault(tag, "teleportation_cooldown", defaults);
        cooldownsJson.addProperty("cooldown_ticks_when_hurt", (Number)this.getIntOrDefault(cooldownsTag, "cooldown_ticks_when_hurt", defaults));
        cooldownsJson.addProperty("cooldown_ticks_from_abyss_watcher", (Number)this.getIntOrDefault(cooldownsTag, "cooldown_ticks_from_abyss_watcher", defaults));
        cooldownsJson.addProperty("cooldown_ticks_from_pocket_wormhole", (Number)this.getIntOrDefault(cooldownsTag, "cooldown_ticks_from_pocket_wormhole", defaults));
        cooldownsJson.addProperty("cooldown_ticks_from_local_void", (Number)this.getIntOrDefault(cooldownsTag, "cooldown_ticks_from_local_void", defaults));
        cooldownsJson.addProperty("cooldown_ticks_from_waystone", (Number)this.getIntOrDefault(cooldownsTag, "cooldown_ticks_from_waystone", defaults));
        json.add("teleportation_cooldown", (JsonElement)cooldownsJson);
        this.createFile(json, this.difference > 0);
        this.difference = 0;
        return json;
    }

    private class_2487 toNbtCompound(JsonObject json) {
        class_2487 tag = new class_2487();
        class_2487 defaults = this.getDefaults();
        tag.method_10556("generate_in_villages", this.getBooleanOrDefault(json, "generate_in_villages", defaults));
        tag.method_10556("consume_infinite_knowledge_scroll_on_use", this.getBooleanOrDefault(json, "consume_infinite_knowledge_scroll_on_use", defaults));
        tag.method_10556("consume_local_void_on_use", this.getBooleanOrDefault(json, "consume_local_void_on_use", defaults));
        tag.method_10556("free_local_void_teleport", this.getBooleanOrDefault(json, "free_local_void_teleport", defaults));
        tag.method_10556("store_waystone_data_on_sneak_break", this.getBooleanOrDefault(json, "store_waystone_data_on_sneak_break", defaults));
        tag.method_10556("can_owners_redeem_payments", this.getBooleanOrDefault(json, "can_owners_redeem_payments", defaults));
        tag.method_10569("cost_amount", this.getIntOrDefault(json, "cost_amount", defaults));
        tag.method_10582("cost_type", this.getStringOrDefault(json, "cost_type", defaults));
        tag.method_10582("cost_item", this.getStringOrDefault(json, "cost_item", defaults));
        tag.method_10548("waystone_block_hardness", this.getFloatOrDefault(json, "waystone_block_hardness", defaults));
        tag.method_10569("waystone_block_required_mining_level", this.getIntOrDefault(json, "waystone_block_required_mining_level", defaults));
        tag.method_10556("prevent_non_owners_from_breaking_waystone", this.getBooleanOrDefault(json, "prevent_non_owners_from_breaking_waystone", defaults));
        tag.method_10556("can_players_toggle_global_mode", this.getBooleanOrDefault(json, "can_players_toggle_global_mode", defaults));
        class_2487 cooldowns = new class_2487();
        if (json.has("teleportation_cooldown")) {
            JsonObject cooldownsJson = json.get("teleportation_cooldown").getAsJsonObject();
            class_2487 defaultCooldowns = defaults.method_10562("teleportation_cooldown");
            cooldowns.method_10569("cooldown_ticks_when_hurt", this.getIntOrDefault(cooldownsJson, "cooldown_ticks_when_hurt", defaultCooldowns));
            cooldowns.method_10569("cooldown_ticks_from_abyss_watcher", this.getIntOrDefault(cooldownsJson, "cooldown_ticks_from_abyss_watcher", defaultCooldowns));
            cooldowns.method_10569("cooldown_ticks_from_pocket_wormhole", this.getIntOrDefault(cooldownsJson, "cooldown_ticks_from_pocket_wormhole", defaultCooldowns));
            cooldowns.method_10569("cooldown_ticks_from_local_void", this.getIntOrDefault(cooldownsJson, "cooldown_ticks_from_local_void", defaultCooldowns));
            cooldowns.method_10569("cooldown_ticks_from_waystone", this.getIntOrDefault(cooldownsJson, "cooldown_ticks_from_waystone", defaultCooldowns));
        } else {
            ++this.difference;
            cooldowns = defaults.method_10562("teleportation_cooldown");
        }
        tag.method_10566("teleportation_cooldown", (class_2520)cooldowns);
        this.createFile(this.toJson(tag), this.difference > 0);
        this.difference = 0;
        return tag;
    }

    public boolean loadConfig() {
        try {
            return this.loadConfig(Config.getJsonObject(Config.readFile(new File(CONFIG_FILE))));
        }
        catch (Exception e) {
            this.LOGGER.info("Found error with config. Using default config.");
            this.configData = this.getDefaults();
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    private boolean loadConfig(JsonObject fileConfig) {
        try {
            this.configData = this.toNbtCompound(fileConfig);
            return true;
        }
        catch (Exception e) {
            this.LOGGER.info("Found error with config. Using default config.");
            this.configData = this.getDefaults();
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    public boolean loadConfig(class_2487 config) {
        try {
            this.configData = config;
            return true;
        }
        catch (Exception e) {
            this.LOGGER.info("Found error with config. Using default config.");
            this.configData = this.getDefaults();
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    private void createFile(JsonObject contents, boolean overwrite) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        contents = new JsonParser().parse(gson.toJson((JsonElement)contents)).getAsJsonObject();
        File file = new File(CONFIG_FILE);
        if (file.exists() && !overwrite) {
            return;
        }
        file.getParentFile().mkdirs();
        try {
            file.createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        file.setReadable(true);
        file.setWritable(true);
        file.setExecutable(true);
        if (contents == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(file);){
            String json = gson.toJson((JsonElement)contents).replace("\n", "").replace("\r", "");
            writer.write(gson.toJson((JsonElement)new JsonParser().parse(json).getAsJsonObject()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public class_2487 toNbtCompound() {
        return this.configData;
    }

    public static String readFile(File file) throws FileNotFoundException {
        Scanner scanner = new Scanner(file);
        scanner.useDelimiter("\\Z");
        String result = scanner.next();
        scanner.close();
        return result;
    }

    public static JsonObject getJsonObject(String json) {
        return new JsonParser().parse(json).getAsJsonObject();
    }

    public void print(class_3222 player) {
        for (Map.Entry config : this.toJson(this.configData).entrySet()) {
            if (((JsonElement)config.getValue()).isJsonObject()) continue;
            player.method_7353((class_2561)new class_2585("\u00a76[\u00a7e" + (String)config.getKey() + "\u00a76] \u00a73 " + config.getValue()), false);
        }
    }
}

