/*
 * Decompiled with CFR 0.152.
 */
package ladysnake.blast.client;

import java.util.function.Function;
import ladysnake.blast.client.particle.ConfettiParticle;
import ladysnake.blast.client.particle.DryIceParticle;
import ladysnake.blast.client.renderers.AmethystShardEntityRenderer;
import ladysnake.blast.client.renderers.BlastBlockEntityRenderer;
import ladysnake.blast.client.renderers.IcicleEntityRenderer;
import ladysnake.blast.common.entity.BombEntity;
import ladysnake.blast.common.entity.ColdDiggerEntity;
import ladysnake.blast.common.entity.StripminerEntity;
import ladysnake.blast.common.init.BlastBlocks;
import ladysnake.blast.common.init.BlastEntities;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.blockrenderlayer.v1.BlockRenderLayerMap;
import net.fabricmc.fabric.api.client.particle.v1.ParticleFactoryRegistry;
import net.fabricmc.fabric.api.client.rendereregistry.v1.EntityRendererRegistry;
import net.fabricmc.fabric.api.particle.v1.FabricParticleTypes;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1921;
import net.minecraft.class_2378;
import net.minecraft.class_2396;
import net.minecraft.class_2400;
import net.minecraft.class_2680;
import net.minecraft.class_3856;
import net.minecraft.class_953;

@Environment(value=EnvType.CLIENT)
public class BlastClient
implements ClientModInitializer {
    public static class_2400 DRY_ICE;
    public static class_2400 CONFETTI;

    public static void registerRenders() {
        BlastClient.registerItemEntityRenders(BlastEntities.BOMB, BlastEntities.TRIGGER_BOMB, BlastEntities.GOLDEN_BOMB, BlastEntities.GOLDEN_TRIGGER_BOMB, BlastEntities.DIAMOND_BOMB, BlastEntities.DIAMOND_TRIGGER_BOMB, BlastEntities.NAVAL_MINE, BlastEntities.CONFETTI_BOMB, BlastEntities.CONFETTI_TRIGGER_BOMB, BlastEntities.DIRT_BOMB, BlastEntities.DIRT_TRIGGER_BOMB, BlastEntities.PEARL_BOMB, BlastEntities.PEARL_TRIGGER_BOMB);
        BlastClient.registerBlockEntityRender(BlastEntities.GUNPOWDER_BLOCK, e -> BlastBlocks.GUNPOWDER_BLOCK.method_9564());
        BlastClient.registerBlockEntityRender(BlastEntities.STRIPMINER, StripminerEntity::getState);
        BlastClient.registerBlockEntityRender(BlastEntities.COLD_DIGGER, ColdDiggerEntity::getState);
        BlockRenderLayerMap.INSTANCE.putBlock(BlastBlocks.GUNPOWDER_BLOCK, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BlastBlocks.STRIPMINER, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BlastBlocks.COLD_DIGGER, class_1921.method_23581());
        BlockRenderLayerMap.INSTANCE.putBlock(BlastBlocks.DRY_ICE, class_1921.method_23583());
        EntityRendererRegistry.INSTANCE.register(BlastEntities.AMETHYST_SHARD, AmethystShardEntityRenderer::new);
        EntityRendererRegistry.INSTANCE.register(BlastEntities.ICICLE, IcicleEntityRenderer::new);
    }

    @SafeVarargs
    private static void registerItemEntityRenders(class_1299<? extends class_3856> ... entityTypes) {
        for (class_1299<? extends class_3856> entityType : entityTypes) {
            BlastClient.registerItemEntityRender(entityType);
        }
    }

    private static <T extends class_1297> void registerItemEntityRender(class_1299<T> entityType) {
        EntityRendererRegistry.INSTANCE.register(entityType, ctx -> new class_953(ctx));
    }

    private static <T extends BombEntity> void registerBlockEntityRender(class_1299<T> block, Function<T, class_2680> stateGetter) {
        EntityRendererRegistry.INSTANCE.register(block, ctx -> new BlastBlockEntityRenderer(ctx, stateGetter));
    }

    public void onInitializeClient() {
        BlastClient.registerRenders();
        DRY_ICE = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"blast:dry_ice", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)DRY_ICE, DryIceParticle.DefaultFactory::new);
        CONFETTI = (class_2400)class_2378.method_10226((class_2378)class_2378.field_11141, (String)"blast:confetti", (Object)FabricParticleTypes.simple((boolean)true));
        ParticleFactoryRegistry.getInstance().register((class_2396)CONFETTI, ConfettiParticle.DefaultFactory::new);
    }
}

