/*
 * Decompiled with CFR 0.152.
 */
package net.blay09.mods.farmingforblockheads.registry.market;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import net.blay09.mods.balm.api.Balm;
import net.blay09.mods.balm.api.container.ContainerUtils;
import net.blay09.mods.balm.api.event.PlayerLoginEvent;
import net.blay09.mods.farmingforblockheads.FarmingForBlockheads;
import net.blay09.mods.farmingforblockheads.api.FarmingForBlockheadsAPI;
import net.blay09.mods.farmingforblockheads.api.IMarketCategory;
import net.blay09.mods.farmingforblockheads.api.IMarketRegistryDefaultHandler;
import net.blay09.mods.farmingforblockheads.api.MarketRegistryReloadEvent;
import net.blay09.mods.farmingforblockheads.registry.MarketCategory;
import net.blay09.mods.farmingforblockheads.registry.MarketRegistry;
import net.blay09.mods.farmingforblockheads.registry.json.ItemStackSerializer;
import net.blay09.mods.farmingforblockheads.registry.json.MarketRegistryDataSerializer;
import net.blay09.mods.farmingforblockheads.registry.market.MarketRegistryData;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_4013;
import org.jetbrains.annotations.Nullable;

public class MarketRegistryLoader
implements class_4013 {
    private static final Gson gson = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeAdapter(class_1799.class, (Object)new ItemStackSerializer()).registerTypeAdapter(MarketRegistryData.class, (Object)new MarketRegistryDataSerializer()).create();
    private static final List<Exception> registryErrors = new ArrayList<Exception>();

    public void method_14491(class_3300 resourceManager) {
        try {
            MarketRegistry.INSTANCE.reset();
            registryErrors.clear();
            Balm.getEvents().fireEvent((Object)new MarketRegistryReloadEvent.Pre());
            for (class_2960 resourceLocation : resourceManager.method_14488("farmingforblockheads_compat", it -> it.endsWith(".json"))) {
                try {
                    class_3298 resource = resourceManager.method_14486(resourceLocation);
                    try {
                        InputStreamReader reader = new InputStreamReader(resource.method_14482());
                        this.load((MarketRegistryData)gson.fromJson((Reader)reader, MarketRegistryData.class));
                    }
                    finally {
                        if (resource == null) continue;
                        resource.close();
                    }
                }
                catch (Exception e) {
                    FarmingForBlockheads.logger.error("Parsing error loading Farming for Blockheads data file at {}", (Object)resourceLocation, (Object)e);
                    registryErrors.add(e);
                }
            }
            File configDir = new File(Balm.getConfig().getConfigDir(), "farmingforblockheads");
            if (configDir.exists() || configDir.mkdirs()) {
                File configFile = new File(configDir, "MarketRegistry.json");
                if (configFile.exists()) {
                    try (FileReader reader = new FileReader(configFile);){
                        this.load((MarketRegistryData)gson.fromJson((Reader)reader, MarketRegistryData.class));
                    }
                    catch (Exception e) {
                        FarmingForBlockheads.logger.error("Parsing error loading Farming for Blockheads data from MarketRegistry.json", (Throwable)e);
                        registryErrors.add(e);
                    }
                } else {
                    try (FileWriter writer = new FileWriter(configFile);){
                        gson.toJson((Object)new MarketRegistryData(), (Appendable)writer);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            MarketRegistry.INSTANCE.registerDefaults();
            Balm.getEvents().fireEvent((Object)new MarketRegistryReloadEvent.Post());
        }
        catch (Exception e) {
            FarmingForBlockheads.logger.error("Exception loading Farming for Blockheads data", (Throwable)e);
            registryErrors.add(e);
        }
    }

    private void load(final @Nullable MarketRegistryData data) {
        if (data == null) {
            return;
        }
        if (data.getModId() != null && !data.getModId().equals("minecraft") && !Balm.isModLoaded((String)data.getModId())) {
            return;
        }
        if (data.getGroup() != null) {
            FarmingForBlockheadsAPI.registerMarketDefaultHandler(data.getGroup().getName(), new IMarketRegistryDefaultHandler(){

                @Override
                public void register(@Nullable class_1799 overridePayment, @Nullable Integer overrideCount) {
                    class_1799 effectiveDefaultPayment = data.getGroup().getDefaultPayment();
                    if (effectiveDefaultPayment == null) {
                        effectiveDefaultPayment = this.getDefaultPayment();
                    }
                    if (overridePayment != null) {
                        effectiveDefaultPayment = overridePayment;
                    }
                    MarketRegistryLoader.this.loadMarketData(data, effectiveDefaultPayment, overrideCount);
                }

                @Override
                public boolean isEnabledByDefault() {
                    return data.getGroup().isEnabledByDefault();
                }

                @Override
                public class_1799 getDefaultPayment() {
                    return new class_1799((class_1935)class_1802.field_8687);
                }
            });
        } else {
            this.loadMarketData(data, new class_1799((class_1935)class_1802.field_8687), null);
        }
    }

    private void loadMarketData(MarketRegistryData data, class_1799 defaultPayment, @Nullable Integer overrideCount) {
        if (data.getCustomCategories() != null) {
            data.getCustomCategories().forEach((key, categoryData) -> {
                class_2960 resourceLocation = new class_2960(key);
                MarketRegistry.INSTANCE.registerCategory(new MarketCategory(resourceLocation, categoryData.getName(), categoryData.getIcon(), categoryData.getSortIndex()));
            });
        }
        if (data.getEntryOverrides() != null) {
            data.getEntryOverrides().forEach(MarketRegistry.INSTANCE::registerEntryOverride);
        }
        if (data.getGroupOverrides() != null) {
            data.getGroupOverrides().forEach(MarketRegistry.INSTANCE::registerGroupOverride);
        }
        if (data.getCustomEntries() != null) {
            data.getCustomEntries().forEach(it -> {
                class_2960 categoryKey = it.getCategory();
                if (categoryKey == null) {
                    categoryKey = data.getGroup() != null ? data.getGroup().getDefaultCategory() : new class_2960("farmingforblockheads:other");
                }
                IMarketCategory category = MarketRegistry.getCategory(categoryKey);
                class_1799 effectivePayment = it.getPayment();
                if (effectivePayment == null) {
                    effectivePayment = defaultPayment;
                }
                class_1799 effectiveOutput = it.getOutput();
                if (overrideCount != null) {
                    effectiveOutput = ContainerUtils.copyStackWithSize((class_1799)effectiveOutput, (int)overrideCount);
                }
                MarketRegistry.INSTANCE.registerEntry(effectiveOutput, effectivePayment, category);
            });
        }
    }

    public static void onLogin(PlayerLoginEvent event) {
        if (!registryErrors.isEmpty()) {
            event.getPlayer().method_7353((class_2561)MarketRegistryLoader.getErrorTextComponent("There were registry errors in the FarmingForBlockheads market data. See the log for full details."), false);
            for (Exception registryError : registryErrors) {
                event.getPlayer().method_7353((class_2561)MarketRegistryLoader.getErrorTextComponent("- " + registryError.getMessage()), false);
            }
        }
    }

    private static class_2585 getErrorTextComponent(String message) {
        class_2585 result = new class_2585(message);
        result.method_27692(class_124.field_1061);
        return result;
    }
}

