/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.config;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import juuxel.adorn.config.Config;
import juuxel.adorn.relocated.jankson.Jankson;
import juuxel.adorn.relocated.jankson.JsonElement;
import juuxel.adorn.relocated.jankson.JsonObject;
import juuxel.adorn.relocated.jankson.api.DeserializationException;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmName;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\f\b&\u0018\u0000 \u001e2\u00020\u0001:\u0001\u001eB\u0007\u00a2\u0006\u0004\b\u001d\u0010\u0004J\r\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\r\u0010\u0005\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0004J\u001f\u0010\n\u001a\u00020\t2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\r\u0010\f\u001a\u00020\u0002\u00a2\u0006\u0004\b\f\u0010\u0004J\u0017\u0010\f\u001a\u00020\u00022\u0006\u0010\u0007\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b\f\u0010\u000eR\u001b\u0010\u0007\u001a\u00020\r8GX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0016\u001a\u00020\u00138$X\u00a4\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0019\u001a\u00020\u00138BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0010\u001a\u0004\b\u0018\u0010\u0015R\u0016\u0010\u001a\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001a\u0010\u001bR\u0016\u0010\u001c\u001a\u00020\t8\u0002@\u0002X\u0082\u000e\u00a2\u0006\u0006\n\u0004\b\u001c\u0010\u001b\u00a8\u0006\u001f"}, d2={"Ljuuxel/adorn/config/ConfigManager;", "", "", "finalize", "()V", "init", "Ljuuxel/adorn/relocated/jankson/JsonObject;", "config", "defaults", "", "isMissingKeys", "(Ljuuxel/adorn/relocated/jankson/JsonObject;Ljuuxel/adorn/relocated/jankson/JsonObject;)Z", "save", "Ljuuxel/adorn/config/Config;", "(Ljuuxel/adorn/config/Config;)V", "config$delegate", "Lkotlin/Lazy;", "getConfig", "()Ljuuxel/adorn/config/Config;", "Ljava/nio/file/Path;", "getConfigDirectory", "()Ljava/nio/file/Path;", "configDirectory", "configPath$delegate", "getConfigPath", "configPath", "finalized", "Z", "saveScheduled", "<init>", "Companion", "Adorn"})
public abstract class ConfigManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Lazy configPath$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Path>(this){
        final /* synthetic */ ConfigManager this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        public final Path invoke() {
            return this.this$0.getConfigDirectory().resolve("Adorn.json5");
        }
    }));
    private boolean saveScheduled;
    private boolean finalized;
    @NotNull
    private final Lazy config$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Config>(this){
        final /* synthetic */ ConfigManager this$0;
        {
            this.this$0 = $receiver;
            super(0);
        }

        public final Config invoke() {
            Object object;
            if (Files.notExists(ConfigManager.access$getConfigPath(this.this$0), new LinkOption[0])) {
                ConfigManager.access$save(this.this$0, new Config());
            }
            try {
                Jankson jankson = ConfigManager.access$getJANKSON$cp();
                Object object2 = Files.readAllLines(ConfigManager.access$getConfigPath(this.this$0));
                Intrinsics.checkNotNullExpressionValue(object2, (String)"readAllLines(configPath)");
                JsonObject jsonObject = jankson.load(CollectionsKt.joinToString$default((Iterable)((Iterable)object2), (CharSequence)"\n", null, null, (int)0, null, null, (int)62, null));
                Intrinsics.checkNotNullExpressionValue((Object)jsonObject, (String)"JANKSON.load(Files.readA\u2026Path).joinToString(\"\\n\"))");
                JsonObject obj = jsonObject;
                try {
                    object2 = ConfigManager.access$getJANKSON$cp().fromJsonCarefully(obj, Config.class);
                }
                catch (DeserializationException e) {
                    Config config2 = ConfigManager.access$getJANKSON$cp().fromJson(obj, Config.class);
                    if (config2 == null) {
                        throw e;
                    }
                    object2 = config2;
                }
                Object config3 = object2;
                if (ConfigManager.access$isMissingKeys(this.this$0, obj, ConfigManager.access$getDEFAULT$cp())) {
                    ConfigManager.access$getLOGGER$cp().info("[Adorn] Upgrading config...");
                    Intrinsics.checkNotNullExpressionValue((Object)config3, (String)"config");
                    ConfigManager.access$save(this.this$0, (Config)config3);
                }
                object = config3;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load Adorn config file!", e);
            }
            return object;
        }
    }));
    private static final Jankson JANKSON = Jankson.builder().build();
    @NotNull
    private static final JsonObject DEFAULT;
    private static final Logger LOGGER;

    @NotNull
    protected abstract Path getConfigDirectory();

    private final Path getConfigPath() {
        Lazy lazy = this.configPath$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-configPath>(...)");
        return (Path)object;
    }

    @JvmName(name="getConfig")
    @NotNull
    public final Config getConfig() {
        Lazy lazy = this.config$delegate;
        Object object = lazy.getValue();
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"<get-config>(...)");
        return (Config)object;
    }

    public final void init() {
        this.getConfig();
    }

    public final void save() {
        if (this.finalized) {
            this.save(this.getConfig());
        } else {
            this.saveScheduled = true;
        }
    }

    public final void finalize() {
        this.finalized = true;
        if (this.saveScheduled) {
            this.save();
        }
    }

    private final void save(Config config2) {
        Path path = this.getConfigPath();
        String string = JANKSON.toJson(config2).toJson(true, true);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"JANKSON.toJson(config).toJson(true, true)");
        Files.write(path, (Iterable<? extends CharSequence>)StringsKt.lines((CharSequence)string), new OpenOption[0]);
    }

    private final boolean isMissingKeys(JsonObject config2, JsonObject defaults) {
        for (Map.Entry entry : ((Map)defaults).entrySet()) {
            String key = (String)entry.getKey();
            JsonElement value2 = (JsonElement)entry.getValue();
            if (!config2.containsKey(key)) {
                return true;
            }
            if (!(value2 instanceof JsonObject)) continue;
            JsonObject jsonObject = config2.get(JsonObject.class, key);
            if (jsonObject == null) {
                return true;
            }
            if (!this.isMissingKeys(jsonObject, (JsonObject)value2)) continue;
            return true;
        }
        return false;
    }

    public static final /* synthetic */ Path access$getConfigPath(ConfigManager $this) {
        return $this.getConfigPath();
    }

    public static final /* synthetic */ void access$save(ConfigManager $this, Config config2) {
        $this.save(config2);
    }

    public static final /* synthetic */ Jankson access$getJANKSON$cp() {
        return JANKSON;
    }

    public static final /* synthetic */ boolean access$isMissingKeys(ConfigManager $this, JsonObject config2, JsonObject defaults) {
        return $this.isMissingKeys(config2, defaults);
    }

    public static final /* synthetic */ JsonObject access$getDEFAULT$cp() {
        return DEFAULT;
    }

    public static final /* synthetic */ Logger access$getLOGGER$cp() {
        return LOGGER;
    }

    static {
        JsonElement jsonElement = JANKSON.toJson(new Config());
        if (jsonElement == null) {
            throw new NullPointerException("null cannot be cast to non-null type blue.endless.jankson.JsonObject");
        }
        DEFAULT = (JsonObject)jsonElement;
        LOGGER = LogManager.getLogger();
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\f\u0010\rR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0004R\u001c\u0010\u0007\u001a\n \u0006*\u0004\u0018\u00010\u00050\u00058\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010\bR\u001c\u0010\n\u001a\n \u0006*\u0004\u0018\u00010\t0\t8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\n\u0010\u000b\u00a8\u0006\u000e"}, d2={"Ljuuxel/adorn/config/ConfigManager$Companion;", "", "Ljuuxel/adorn/relocated/jankson/JsonObject;", "DEFAULT", "Ljuuxel/adorn/relocated/jankson/JsonObject;", "Ljuuxel/adorn/relocated/jankson/Jankson;", "kotlin.jvm.PlatformType", "JANKSON", "Ljuuxel/adorn/relocated/jankson/Jankson;", "Lorg/apache/logging/log4j/Logger;", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

