/*
 * Decompiled with CFR 0.152.
 */
package juuxel.adorn.client.resources;

import java.io.Closeable;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import juuxel.adorn.AdornCommon;
import juuxel.adorn.client.resources.ColorPalette;
import juuxel.adorn.relocated.jankson.Jankson;
import juuxel.adorn.relocated.jankson.JsonElement;
import juuxel.adorn.relocated.jankson.JsonObject;
import juuxel.adorn.relocated.jankson.JsonPrimitive;
import juuxel.adorn.util.Colors;
import juuxel.adorn.util.ColorsKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import kotlin.text.CharsKt;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000F\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\b\u0006\b\u0016\u0018\u0000 \u001c2\u001a\u0012\u0016\u0012\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00020\u0001:\u0002\u001d\u001cB\u0007\u00a2\u0006\u0004\b\u001a\u0010\u001bJ9\u0010\f\u001a\u00020\u000b2\u0018\u0010\u0006\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00022\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0014\u00a2\u0006\u0004\b\f\u0010\rJ\u0015\u0010\u0010\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0010\u0010\u0011J1\u0010\u0012\u001a\u0014\u0012\u0004\u0012\u00020\u0003\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\u00040\u00022\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\tH\u0014\u00a2\u0006\u0004\b\u0012\u0010\u0013R\u001c\u0010\u0016\u001a\n \u0015*\u0004\u0018\u00010\u00140\u00148\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0016\u0010\u0017R \u0010\u0006\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000f0\u00188\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0019\u00a8\u0006\u001e"}, d2={"Ljuuxel/adorn/client/resources/ColorManager;", "Lnet/minecraft/class_4080;", "", "Lnet/minecraft/class_2960;", "", "Ljuuxel/adorn/relocated/jankson/JsonObject;", "map", "Lnet/minecraft/class_3300;", "manager", "Lnet/minecraft/class_3695;", "profiler", "", "apply", "(Ljava/util/Map;Lnet/minecraft/class_3300;Lnet/minecraft/class_3695;)V", "id", "Ljuuxel/adorn/client/resources/ColorPalette;", "getColors", "(Lnet/minecraft/class_2960;)Ljuuxel/adorn/client/resources/ColorPalette;", "prepare", "(Lnet/minecraft/class_3300;Lnet/minecraft/class_3695;)Ljava/util/Map;", "Ljuuxel/adorn/relocated/jankson/Jankson;", "kotlin.jvm.PlatformType", "jankson", "Ljuuxel/adorn/relocated/jankson/Jankson;", "", "Ljava/util/Map;", "<init>", "()V", "Companion", "ColorPair", "Adorn"})
public class ColorManager
extends class_4080<Map<class_2960, ? extends List<? extends JsonObject>>> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final Jankson jankson = Jankson.builder().build();
    @NotNull
    private final Map<class_2960, ColorPalette> map = new HashMap();
    private static final Logger LOGGER = LogManager.getLogger();
    @NotNull
    private static final class_2960 FALLBACK = AdornCommon.id("fallback");
    @NotNull
    private static final String PREFIX = "adorn/color_palettes";
    private static final int SUFFIX_LENGTH = 6;
    @NotNull
    private static final Regex COLOR_REGEX = new Regex("#(?:[0-9A-Fa-f]{2})?[0-9A-Fa-f]{6}");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    protected Map<class_2960, List<JsonObject>> prepare(@NotNull class_3300 manager, @NotNull class_3695 profiler) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
        Collection ids = manager.method_14488(PREFIX, ColorManager::prepare$lambda-0);
        Intrinsics.checkNotNullExpressionValue((Object)ids, (String)"ids");
        Iterable $this$associateWith$iv = ids;
        boolean $i$f$associateWith = false;
        LinkedHashMap result$iv = new LinkedHashMap(RangesKt.coerceAtLeast((int)MapsKt.mapCapacity((int)CollectionsKt.collectionSizeOrDefault((Iterable)$this$associateWith$iv, (int)10)), (int)16));
        Iterable $this$associateWithTo$iv$iv = $this$associateWith$iv;
        boolean $i$f$associateWithTo = false;
        for (Object element$iv$iv : $this$associateWithTo$iv$iv) {
            void $this$mapTo$iv$iv;
            void id;
            class_2960 class_29602 = (class_2960)element$iv$iv;
            Object t = element$iv$iv;
            Map map2 = result$iv;
            boolean bl = false;
            List list = manager.method_14489((class_2960)id);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"manager.getAllResources(id)");
            Iterable $this$map$iv = list;
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                JsonObject jsonObject;
                void resource;
                class_3298 class_32982 = (class_3298)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl2 = false;
                Closeable closeable = resource.method_14482();
                Throwable throwable = null;
                try {
                    InputStream input = (InputStream)closeable;
                    boolean bl3 = false;
                    JsonObject jsonObject2 = this.jankson.load(input);
                    Intrinsics.checkNotNullExpressionValue((Object)jsonObject2, (String)"jankson.load(input)");
                    jsonObject = jsonObject2;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
                collection.add(jsonObject);
            }
            List list2 = (List)destination$iv$iv;
            map2.put(t, list2);
        }
        return result$iv;
    }

    protected void apply(@NotNull Map<class_2960, ? extends List<? extends JsonObject>> map2, @NotNull class_3300 manager, @NotNull class_3695 profiler) {
        Intrinsics.checkNotNullParameter(map2, (String)"map");
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        Intrinsics.checkNotNullParameter((Object)profiler, (String)"profiler");
        for (Map.Entry<class_2960, ? extends List<? extends JsonObject>> entry : map2.entrySet()) {
            class_2960 id = entry.getKey();
            List<? extends JsonObject> jsons = entry.getValue();
            HashMap scheme = new HashMap();
            for (JsonObject jsonObject : jsons) {
                for (Map.Entry entry2 : ((Map)jsonObject).entrySet()) {
                    String key = (String)entry2.getKey();
                    JsonElement value2 = (JsonElement)entry2.getValue();
                    class_2960 keyId = class_2960.method_12829((String)key);
                    if (keyId == null) {
                        LOGGER.warn("[Adorn] Invalid key '{}' in color palette {} - must be a valid identifier", (Object)key, (Object)id);
                        continue;
                    }
                    Map map3 = scheme;
                    Intrinsics.checkNotNullExpressionValue((Object)value2, (String)"value");
                    ColorPair colorPair = ColorPair.Companion.fromJson(value2);
                    map3.put(keyId, colorPair);
                }
            }
            String string = id.method_12836();
            String string2 = id.method_12832();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"id.path");
            String string3 = string2;
            int n = PREFIX.length() + 1;
            int n2 = id.method_12832().length() - 6;
            String string4 = string3.substring(n, n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            class_2960 newId = new class_2960(string, string4);
            Map<class_2960, ColorPalette> object = this.map;
            ColorPalette colorPalette = new ColorPalette(scheme);
            object.put(newId, colorPalette);
        }
    }

    @NotNull
    public final ColorPalette getColors(@NotNull class_2960 id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        ColorPalette colorPalette = this.map.get(id);
        if (colorPalette == null && (colorPalette = this.map.get(FALLBACK)) == null) {
            throw new IllegalStateException("Could not find fallback palette!");
        }
        return colorPalette;
    }

    private static final boolean prepare$lambda-0(String it) {
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return StringsKt.endsWith$default((String)it, (String)".json5", (boolean)false, (int)2, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0017\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002H\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\tR\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010\fR\u001c\u0010\u000f\u001a\n \u000e*\u0004\u0018\u00010\r0\r8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00028\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0013\u0010\u0014\u00a8\u0006\u0017"}, d2={"Ljuuxel/adorn/client/resources/ColorManager$Companion;", "", "", "str", "", "parseHexColor", "(Ljava/lang/String;)I", "Lkotlin/text/Regex;", "COLOR_REGEX", "Lkotlin/text/Regex;", "Lnet/minecraft/class_2960;", "FALLBACK", "Lnet/minecraft/class_2960;", "Lorg/apache/logging/log4j/Logger;", "kotlin.jvm.PlatformType", "LOGGER", "Lorg/apache/logging/log4j/Logger;", "PREFIX", "Ljava/lang/String;", "SUFFIX_LENGTH", "I", "<init>", "()V", "Adorn"})
    public static final class Companion {
        private Companion() {
        }

        private final int parseHexColor(String str) {
            CharSequence charSequence = str;
            if (!COLOR_REGEX.matches(charSequence)) {
                boolean $i$a$-require-ColorManager$Companion$parseHexColor$22 = false;
                String $i$a$-require-ColorManager$Companion$parseHexColor$22 = "Color must be a hex color beginning with '#' - found '" + str + "'";
                throw new IllegalArgumentException($i$a$-require-ColorManager$Companion$parseHexColor$22.toString());
            }
            String string = str.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
            String colorStr = string;
            int len = colorStr.length();
            return switch (len) {
                case 6 -> ColorsKt.color$default(Integer.parseInt(colorStr, CharsKt.checkRadix((int)16)), 0, 2, null);
                case 8 -> Integer.parseInt(colorStr, CharsKt.checkRadix((int)16));
                default -> throw new IllegalStateException(("Invalid color length: " + len).toString());
            };
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\b\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\b\u0086\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0019\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u0010\u0010\u0003\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0010\u0010\u0005\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0004J$\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0006\u001a\u00020\u00022\b\b\u0002\u0010\u0007\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u001a\u0010\f\u001a\u00020\u000b2\b\u0010\n\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\f\u0010\rJ\u0010\u0010\u000e\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u000e\u0010\u0004J\u0010\u0010\u0010\u001a\u00020\u000fH\u00d6\u0001\u00a2\u0006\u0004\b\u0010\u0010\u0011R\u0017\u0010\u0006\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0006\u0010\u0012\u001a\u0004\b\u0013\u0010\u0004R\u0017\u0010\u0007\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0007\u0010\u0012\u001a\u0004\b\u0014\u0010\u0004\u00a8\u0006\u0018"}, d2={"Ljuuxel/adorn/client/resources/ColorManager$ColorPair;", "", "", "component1", "()I", "component2", "bg", "fg", "copy", "(II)Ljuuxel/adorn/client/resources/ColorManager$ColorPair;", "other", "", "equals", "(Ljava/lang/Object;)Z", "hashCode", "", "toString", "()Ljava/lang/String;", "I", "getBg", "getFg", "<init>", "(II)V", "Companion", "Adorn"})
    public static final class ColorPair {
        @NotNull
        public static final Companion Companion = new Companion(null);
        private final int bg;
        private final int fg;

        public ColorPair(int bg, int fg) {
            this.bg = bg;
            this.fg = fg;
        }

        public /* synthetic */ ColorPair(int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n3 & 2) != 0) {
                n2 = Colors.INSTANCE.getSCREEN_TEXT();
            }
            this(n, n2);
        }

        public final int getBg() {
            return this.bg;
        }

        public final int getFg() {
            return this.fg;
        }

        public final int component1() {
            return this.bg;
        }

        public final int component2() {
            return this.fg;
        }

        @NotNull
        public final ColorPair copy(int bg, int fg) {
            return new ColorPair(bg, fg);
        }

        public static /* synthetic */ ColorPair copy$default(ColorPair colorPair, int n, int n2, int n3, Object object) {
            if ((n3 & 1) != 0) {
                n = colorPair.bg;
            }
            if ((n3 & 2) != 0) {
                n2 = colorPair.fg;
            }
            return colorPair.copy(n, n2);
        }

        @NotNull
        public String toString() {
            return "ColorPair(bg=" + this.bg + ", fg=" + this.fg + ")";
        }

        public int hashCode() {
            int result = Integer.hashCode(this.bg);
            result = result * 31 + Integer.hashCode(this.fg);
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof ColorPair)) {
                return false;
            }
            ColorPair colorPair = (ColorPair)other;
            if (this.bg != colorPair.bg) {
                return false;
            }
            return this.fg == colorPair.fg;
        }

        @Metadata(mv={1, 6, 0}, k=1, xi=0, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\n\u0010\u000bJ\u0015\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0015\u0010\b\u001a\u00020\u0007*\u0004\u0018\u00010\u0002H\u0002\u00a2\u0006\u0004\b\b\u0010\t\u00a8\u0006\f"}, d2={"Ljuuxel/adorn/client/resources/ColorManager$ColorPair$Companion;", "", "Ljuuxel/adorn/relocated/jankson/JsonElement;", "json", "Ljuuxel/adorn/client/resources/ColorManager$ColorPair;", "fromJson", "(Ljuuxel/adorn/relocated/jankson/JsonElement;)Ljuuxel/adorn/client/resources/ColorManager$ColorPair;", "", "asString", "(Ljuuxel/adorn/relocated/jankson/JsonElement;)Ljava/lang/String;", "<init>", "()V", "Adorn"})
        public static final class Companion {
            private Companion() {
            }

            private final String asString(JsonElement $this$asString) {
                JsonElement jsonElement = $this$asString;
                if (jsonElement == null) {
                    throw new NullPointerException("null cannot be cast to non-null type blue.endless.jankson.JsonPrimitive");
                }
                String string = ((JsonPrimitive)jsonElement).asString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as JsonPrimitive).asString()");
                return string;
            }

            @NotNull
            public final ColorPair fromJson(@NotNull JsonElement json) {
                ColorPair colorPair;
                Intrinsics.checkNotNullParameter((Object)json, (String)"json");
                JsonElement jsonElement = json;
                if (jsonElement instanceof JsonObject) {
                    colorPair = ((JsonObject)json).containsKey("fg") ? new ColorPair(ColorManager.Companion.parseHexColor(this.asString((JsonElement)((JsonObject)json).get("bg"))), ColorManager.Companion.parseHexColor(this.asString((JsonElement)((JsonObject)json).get("fg")))) : new ColorPair(ColorManager.Companion.parseHexColor(this.asString((JsonElement)((JsonObject)json).get("bg"))), 0, 2, null);
                } else if (jsonElement instanceof JsonPrimitive) {
                    String string = ((JsonPrimitive)json).asString();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"json.asString()");
                    ColorPair colorPair2 = new ColorPair(ColorManager.Companion.parseHexColor(string), 0, 2, null);
                    colorPair = colorPair2;
                } else {
                    throw new IllegalArgumentException("Invalid color value: " + json);
                }
                return colorPair;
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }
}

