/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.mixin;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1313;
import net.minecraft.class_1542;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Constant;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.ModifyArgs;
import org.spongepowered.asm.mixin.injection.ModifyConstant;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import org.spongepowered.asm.mixin.injection.invoke.arg.Args;
import virtuoel.pehkui.api.ScaleData;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.server.command.DebugCommand;
import virtuoel.pehkui.util.PehkuiEntityExtensions;
import virtuoel.pehkui.util.ScaleUtils;

@Mixin(value={class_1297.class})
public abstract class EntityMixin
implements PehkuiEntityExtensions {
    @Shadow
    boolean field_5952;
    private final Map<ScaleType, ScaleData> pehkui_scaleTypes = new Object2ObjectOpenHashMap();
    private boolean pehkui_shouldSyncScales = false;

    @Override
    public ScaleData pehkui_constructScaleData(ScaleType type) {
        return ScaleData.Builder.create().type(type).entity((class_1297)this).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ScaleData pehkui_getScaleData(ScaleType type) {
        Map<ScaleType, ScaleData> map = this.pehkui_scaleTypes;
        synchronized (map) {
            ScaleData scaleData = this.pehkui_scaleTypes.get(type);
            if (!this.pehkui_scaleTypes.containsKey(type)) {
                this.pehkui_scaleTypes.put(type, null);
                scaleData = this.pehkui_constructScaleData(type);
                this.pehkui_scaleTypes.put(type, scaleData);
            }
            return scaleData;
        }
    }

    @Override
    public Map<ScaleType, ScaleData> pehkui_getScales() {
        return this.pehkui_scaleTypes;
    }

    @Override
    public void pehkui_setShouldSyncScales(boolean sync) {
        this.pehkui_shouldSyncScales = sync;
    }

    @Override
    public boolean pehkui_shouldSyncScales() {
        return this.pehkui_shouldSyncScales;
    }

    @Inject(at={@At(value="HEAD")}, method={"readNbt"})
    private void onReadNbt(class_2487 tag, CallbackInfo info) {
        if (tag.method_10573("pehkui:scale_data_types", 10) && !DebugCommand.unmarkEntityForScaleReset((class_1297)this, tag)) {
            class_2487 typeData = tag.method_10562("pehkui:scale_data_types");
            for (Map.Entry entry : ScaleRegistries.SCALE_TYPES.entrySet()) {
                String key = ((class_2960)entry.getKey()).toString();
                if (!typeData.method_10573(key, 10)) continue;
                ScaleData scaleData = this.pehkui_getScaleData((ScaleType)entry.getValue());
                scaleData.readNbt(typeData.method_10562(key));
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"writeNbt"})
    private void onWriteNbt(class_2487 tag, CallbackInfoReturnable<class_2487> info) {
        class_2487 typeData = new class_2487();
        for (Map.Entry entry : ScaleRegistries.SCALE_TYPES.entrySet()) {
            ScaleData scaleData = this.pehkui_getScaleData((ScaleType)entry.getValue());
            if (scaleData.isReset()) continue;
            class_2487 compound = new class_2487();
            scaleData.writeNbt(compound);
            if (compound.method_10546() == 0) continue;
            typeData.method_10566(((class_2960)entry.getKey()).toString(), (class_2520)compound);
        }
        if (typeData.method_10546() > 0) {
            tag.method_10566("pehkui:scale_data_types", (class_2520)typeData);
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"tick"})
    private void onTickPre(CallbackInfo info) {
        for (ScaleType type : ScaleRegistries.SCALE_TYPES.values()) {
            ScaleUtils.tickScale(this.pehkui_getScaleData(type));
        }
    }

    @Inject(at={@At(value="RETURN")}, method={"getDimensions"}, cancellable=true)
    private void onGetDimensions(class_4050 pose, CallbackInfoReturnable<class_4048> info) {
        float widthScale = ScaleUtils.getBoundingBoxWidthScale((class_1297)this);
        float heightScale = ScaleUtils.getBoundingBoxHeightScale((class_1297)this);
        if (widthScale != 1.0f || heightScale != 1.0f) {
            info.setReturnValue((Object)((class_4048)info.getReturnValue()).method_19539(widthScale, heightScale));
        }
    }

    @ModifyVariable(method={"dropStack(Lnet/minecraft/item/ItemStack;F)Lnet/minecraft/entity/ItemEntity;"}, at=@At(value="STORE"))
    private class_1542 onDropStack(class_1542 entity) {
        ScaleUtils.setScaleOfDrop((class_1297)entity, (class_1297)this);
        return entity;
    }

    @ModifyConstant(method={"move"}, constant={@Constant(doubleValue=1.0E-7)})
    private double moveModifyMinVelocity(double value) {
        float scale = ScaleUtils.getMotionScale((class_1297)this);
        return scale < 1.0f ? (double)(scale * scale) * value : value;
    }

    @ModifyArg(method={"move"}, index=0, at=@At(value="INVOKE", target="Lnet/minecraft/entity/Entity;adjustMovementForSneaking(Lnet/minecraft/util/math/Vec3d;Lnet/minecraft/entity/MovementType;)Lnet/minecraft/util/math/Vec3d;"))
    private class_243 onMoveAdjustMovementForSneakingProxy(class_243 movement, class_1313 type) {
        if (type == class_1313.field_6308 || type == class_1313.field_6305) {
            return movement.method_1021((double)ScaleUtils.getMotionScale((class_1297)this));
        }
        return movement;
    }

    @ModifyArgs(method={"pushAwayFrom"}, at=@At(value="INVOKE", ordinal=0, target="Lnet/minecraft/entity/Entity;addVelocity(DDD)V"))
    private void modifyPushSelfAwayFromOther(Args args, class_1297 other) {
        float otherScale = ScaleUtils.getMotionScale(other);
        if (otherScale != 1.0f) {
            args.set(0, (Object)((Double)args.get(0) * (double)otherScale));
            args.set(2, (Object)((Double)args.get(2) * (double)otherScale));
        }
    }

    @ModifyArgs(method={"pushAwayFrom"}, at=@At(value="INVOKE", ordinal=1, target="Lnet/minecraft/entity/Entity;addVelocity(DDD)V"))
    private void modifyPushOtherAwayFromSelf(Args args, class_1297 other) {
        float ownScale = ScaleUtils.getMotionScale((class_1297)this);
        if (ownScale != 1.0f) {
            args.set(0, (Object)((Double)args.get(0) * (double)ownScale));
            args.set(2, (Object)((Double)args.get(2) * (double)ownScale));
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"spawnSprintingParticles"}, cancellable=true)
    private void onSpawnSprintingParticles(CallbackInfo info) {
        if (ScaleUtils.getMotionScale((class_1297)this) < 1.0f) {
            info.cancel();
        }
    }

    @Override
    public boolean pehkui_getOnGround() {
        return this.field_5952;
    }

    @Override
    public void pehkui_setOnGround(boolean onGround) {
        this.field_5952 = onGround;
    }
}

