/*
 * Decompiled with CFR 0.152.
 */
package virtuoel.pehkui.api;

import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;
import virtuoel.kanos_config.api.JsonConfigBuilder;
import virtuoel.pehkui.Pehkui;
import virtuoel.pehkui.api.ScaleRegistries;
import virtuoel.pehkui.api.ScaleType;
import virtuoel.pehkui.api.ScaleTypes;
import virtuoel.pehkui.util.ClampingScaleModifier;
import virtuoel.pehkui.util.VersionUtils;

public class PehkuiConfig {
    @ApiStatus.Internal
    public static final JsonConfigBuilder BUILDER = new JsonConfigBuilder("pehkui", "config.json");
    public static final Client CLIENT = new Client(BUILDER);
    public static final Common COMMON = new Common(BUILDER);
    public static final Server SERVER = new Server(BUILDER);

    private PehkuiConfig() {
    }

    public static final class Client {
        public final Supplier<Double> minimumCameraDepth;

        private Client(JsonConfigBuilder builder) {
            this.minimumCameraDepth = builder.doubleConfig("minimumCameraDepth", 0.0);
        }
    }

    public static final class Common {
        public final Supplier<Boolean> keepAllScalesOnRespawn;
        public final Supplier<List<String>> scalesKeptOnRespawn;
        public final Supplier<Boolean> accurateNetherPortals;
        public final Supplier<Boolean> enableCommands;
        public final Supplier<Boolean> enableDebugCommands;
        public final Supplier<Boolean> scaledFallDamage;
        public final Supplier<Boolean> scaledMotion;
        public final Supplier<Boolean> scaledReach;
        public final Supplier<Boolean> scaledAttack;
        public final Supplier<Boolean> scaledDefense;
        public final Supplier<Boolean> scaledHealth;
        public final Supplier<Boolean> scaledItemDrops;
        public final Supplier<Boolean> scaledProjectiles;
        public final Supplier<Boolean> scaledExplosions;

        private Common(JsonConfigBuilder builder) {
            this.keepAllScalesOnRespawn = builder.booleanConfig("keepAllScalesOnRespawn", false);
            this.scalesKeptOnRespawn = builder.stringListConfig("scalesKeptOnRespawn");
            this.accurateNetherPortals = builder.booleanConfig("accurateNetherPortals", true);
            this.enableCommands = builder.booleanConfig("enableCommands", true);
            this.enableDebugCommands = builder.booleanConfig("enableDebugCommands", false);
            this.scaledFallDamage = builder.booleanConfig("scaledFallDamage", true);
            this.scaledMotion = builder.booleanConfig("scaledMotion", true);
            this.scaledReach = builder.booleanConfig("scaledReach", true);
            this.scaledAttack = builder.booleanConfig("scaledAttack", true);
            this.scaledDefense = builder.booleanConfig("scaledDefense", true);
            this.scaledHealth = builder.booleanConfig("scaledHealth", true);
            this.scaledItemDrops = builder.booleanConfig("scaledItemDrops", true);
            this.scaledProjectiles = builder.booleanConfig("scaledProjectiles", true);
            this.scaledExplosions = builder.booleanConfig("scaledExplosions", true);
            for (Map.Entry entry : ScaleRegistries.SCALE_TYPES.entrySet()) {
                ScaleType type;
                class_2960 id = (class_2960)entry.getKey();
                String namespace = id.method_12836();
                if (!namespace.equals("pehkui") || (type = (ScaleType)entry.getValue()) == ScaleTypes.INVALID) continue;
                String path = id.method_12832();
                Supplier min = builder.doubleConfig(path + ".minimum", (double)1.4E-45f);
                Supplier max = builder.doubleConfig(path + ".maximum", (type == ScaleTypes.BLOCK_REACH || type == ScaleTypes.ENTITY_REACH) && VersionUtils.MINOR < 17 ? 128.0 : 3.4028234663852886E38);
                type.getDefaultBaseValueModifiers().add(ScaleRegistries.register(ScaleRegistries.SCALE_MODIFIERS, Pehkui.id("clamping", path), new ClampingScaleModifier(((Supplier)min)::get, ((Supplier)max)::get, 0.0f)));
            }
        }
    }

    public static final class Server {
        private Server(JsonConfigBuilder builder) {
        }
    }
}

