/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftbquests.integration.StageHelper;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.ServerQuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.task.BooleanTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.task.TaskType;
import dev.ftb.mods.ftbquests.quest.task.TaskTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class StageTask
extends BooleanTask {
    public String stage = "";

    public StageTask(Quest quest) {
        super(quest);
    }

    @Override
    public TaskType getType() {
        return TaskTypes.STAGE;
    }

    @Override
    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10582("stage", this.stage);
    }

    @Override
    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.stage = nbt.method_10558("stage");
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10788(this.stage, Short.MAX_VALUE);
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.stage = buffer.method_10800(Short.MAX_VALUE);
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addString("stage", this.stage, v -> {
            this.stage = v;
        }, "").setNameKey("ftbquests.task.ftbquests.gamestage");
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return new class_2588("ftbquests.task.ftbquests.gamestage").method_27693(": ").method_10852((class_2561)new class_2585(this.stage).method_27692(class_124.field_1054));
    }

    @Override
    public int autoSubmitOnPlayerTick() {
        return 20;
    }

    @Override
    public boolean canSubmit(TeamData teamData, class_3222 player) {
        return ((StageHelper)StageHelper.instance.method_15332()).has((class_1657)player, this.stage);
    }

    public static void checkStages(class_3222 player) {
        TeamData data;
        TeamData teamData = data = ServerQuestFile.INSTANCE == null || PlayerHooks.isFake((class_1657)player) ? null : ServerQuestFile.INSTANCE.getData((class_1297)player);
        if (data == null || data.isLocked()) {
            return;
        }
        ServerQuestFile.INSTANCE.currentPlayer = player;
        for (Task task : ServerQuestFile.INSTANCE.getAllTasks()) {
            if (!(task instanceof StageTask) || !data.canStartTasks(task.quest)) continue;
            task.submitTask(data, player);
        }
        ServerQuestFile.INSTANCE.currentPlayer = null;
    }
}

