/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.task.ISingleLongValueTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2585;
import net.minecraft.class_5250;

public abstract class EnergyTask
extends Task
implements ISingleLongValueTask {
    public long value = 1000L;
    public long maxInput = 0L;

    public EnergyTask(Quest quest) {
        super(quest);
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10544("value", this.value);
        if (this.maxInput > 0L) {
            nbt.method_10544("max_input", this.maxInput);
        }
    }

    @Override
    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.value = nbt.method_10537("value");
        if (this.value < 1L) {
            this.value = 1L;
        }
        this.maxInput = nbt.method_10537("max_input");
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10791(this.value);
        buffer.method_10791(this.maxInput);
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.value = buffer.method_10792();
        this.maxInput = buffer.method_10792();
    }

    @Override
    public void setValue(long v) {
        this.value = v;
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return new class_2585(StringUtils.formatDouble((double)this.value, (boolean)true));
    }

    @Override
    public boolean consumesResources() {
        return true;
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 1000L, 1L, Long.MAX_VALUE);
        config.addLong("max_input", this.maxInput, v -> {
            this.maxInput = v;
        }, 0L, 0L, Integer.MAX_VALUE).setNameKey("ftbquests.task.max_input");
    }
}

