/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftbquests.net.DisplayRewardToastMessage;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.quest.reward.RewardTypes;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_3222;
import net.minecraft.class_5250;

public class XPReward
extends Reward {
    public int xp;

    public XPReward(Quest quest, int x) {
        super(quest);
        this.xp = x;
    }

    public XPReward(Quest quest) {
        this(quest, 100);
    }

    @Override
    public RewardType getType() {
        return RewardTypes.XP;
    }

    @Override
    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        nbt.method_10569("xp", this.xp);
    }

    @Override
    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.xp = nbt.method_10550("xp");
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        buffer.method_10804(this.xp);
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.xp = buffer.method_10816();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addInt("xp", this.xp, v -> {
            this.xp = v;
        }, 100, 1, Integer.MAX_VALUE).setNameKey("ftbquests.reward.ftbquests.xp");
    }

    @Override
    public void claim(class_3222 player, boolean notify) {
        player.method_7255(this.xp);
        if (notify) {
            new DisplayRewardToastMessage(this.id, (class_2561)new class_2588("ftbquests.reward.ftbquests.xp").method_27693(": ").method_10852((class_2561)new class_2585("+" + this.xp).method_27692(class_124.field_1060)), (Icon)Icon.EMPTY).sendTo(player);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public class_5250 getAltTitle() {
        return new class_2588("ftbquests.reward.ftbquests.xp").method_27693(": ").method_10852((class_2561)new class_2585("+" + this.xp).method_27692(class_124.field_1060));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public String getButtonText() {
        return "+" + this.xp;
    }
}

