/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.reward;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.Tristate;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.integration.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.net.ClaimRewardMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.reward.RewardAutoClaim;
import dev.ftb.mods.ftbquests.quest.reward.RewardType;
import dev.ftb.mods.ftbquests.util.ProgressChange;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public abstract class Reward
extends QuestObjectBase {
    public Quest quest;
    public Tristate team;
    public RewardAutoClaim autoclaim;

    public Reward(Quest q) {
        this.quest = q;
        this.team = Tristate.DEFAULT;
        this.autoclaim = RewardAutoClaim.DEFAULT;
    }

    @Override
    public final QuestObjectType getObjectType() {
        return QuestObjectType.REWARD;
    }

    @Override
    public final QuestFile getQuestFile() {
        return this.quest.chapter.file;
    }

    @Override
    @Nullable
    public final Chapter getQuestChapter() {
        return this.quest.chapter;
    }

    @Override
    public final long getParentID() {
        return this.quest.id;
    }

    public abstract RewardType getType();

    @Override
    public void writeData(class_2487 nbt) {
        super.writeData(nbt);
        if (this.team != Tristate.DEFAULT) {
            this.team.write(nbt, "team_reward");
        }
        if (this.autoclaim != RewardAutoClaim.DEFAULT) {
            nbt.method_10582("auto", this.autoclaim.id);
        }
    }

    @Override
    public void readData(class_2487 nbt) {
        super.readData(nbt);
        this.team = Tristate.read((class_2487)nbt, (String)"team_reward");
        this.autoclaim = (RewardAutoClaim)((Object)RewardAutoClaim.NAME_MAP.get(nbt.method_10558("auto")));
    }

    @Override
    public void writeNetData(class_2540 buffer) {
        super.writeNetData(buffer);
        Tristate.NAME_MAP.write(buffer, (Object)this.team);
        RewardAutoClaim.NAME_MAP.write(buffer, (Object)this.autoclaim);
    }

    @Override
    public void readNetData(class_2540 buffer) {
        super.readNetData(buffer);
        this.team = (Tristate)Tristate.NAME_MAP.read(buffer);
        this.autoclaim = (RewardAutoClaim)((Object)RewardAutoClaim.NAME_MAP.read(buffer));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addEnum("team", (Object)this.team, v -> {
            this.team = v;
        }, Tristate.NAME_MAP).setNameKey("ftbquests.reward.team_reward");
        config.addEnum("autoclaim", (Object)this.autoclaim, v -> {
            this.autoclaim = v;
        }, RewardAutoClaim.NAME_MAP).setNameKey("ftbquests.reward.autoclaim");
    }

    public abstract void claim(class_3222 var1, boolean var2);

    public Optional<class_1799> claimAutomated(class_2586 tileEntity, UUID playerId, @Nullable class_3222 player, boolean simulate) {
        if (player != null) {
            if (!simulate) {
                this.claim(player, false);
            }
            return Optional.of(class_1799.field_8037);
        }
        return Optional.empty();
    }

    public boolean automatedClaimPre(class_2586 tileEntity, List<class_1799> items, Random random, UUID playerId, @Nullable class_3222 player) {
        return player != null;
    }

    public void automatedClaimPost(class_2586 tileEntity, UUID playerId, @Nullable class_3222 player) {
        if (player != null) {
            this.claim(player, false);
        }
    }

    @Override
    public final void deleteSelf() {
        this.quest.rewards.remove(this);
        for (TeamData data : this.getQuestFile().getAllData()) {
            data.deleteReward(this);
        }
        super.deleteSelf();
    }

    @Override
    public final void deleteChildren() {
        for (TeamData data : this.getQuestFile().getAllData()) {
            data.deleteReward(this);
        }
        super.deleteChildren();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public void editedFromGUI() {
        QuestScreen gui = (QuestScreen)((Object)ClientUtils.getCurrentGuiAs(QuestScreen.class));
        if (gui != null && gui.isViewingQuest()) {
            gui.viewQuestPanel.refreshWidgets();
        }
        if (gui != null) {
            gui.questPanel.refreshWidgets();
        }
    }

    @Override
    public void onCreated() {
        this.quest.rewards.add(this);
    }

    public final boolean isTeamReward() {
        return this.team.get(this.quest.chapter.file.defaultRewardTeam);
    }

    public final RewardAutoClaim getAutoClaimType() {
        if (this.quest.chapter.alwaysInvisible && (this.autoclaim == RewardAutoClaim.DEFAULT || this.autoclaim == RewardAutoClaim.DISABLED)) {
            return RewardAutoClaim.ENABLED;
        }
        if (this.autoclaim == RewardAutoClaim.DEFAULT) {
            return this.quest.chapter.file.defaultRewardAutoClaim;
        }
        return this.autoclaim;
    }

    @Override
    public final void forceProgress(TeamData teamData, ProgressChange progressChange) {
        if (progressChange.reset) {
            teamData.resetReward(progressChange.player, this);
        } else {
            teamData.claimReward(progressChange.player, this, progressChange.time.getTime());
        }
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public Icon getAltIcon() {
        return this.getType().getIcon();
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    public class_2561 getAltTitle() {
        return this.getType().getDisplayName();
    }

    @Override
    public final ConfigGroup createSubGroup(ConfigGroup group) {
        RewardType type = this.getType();
        return group.getGroup(this.getObjectType().id).getGroup(type.id.method_12836()).getGroup(type.id.method_12832());
    }

    @Environment(value=EnvType.CLIENT)
    public void addMouseOverText(TooltipList list) {
    }

    @Environment(value=EnvType.CLIENT)
    public boolean addTitleInMouseOverText() {
        return true;
    }

    @Environment(value=EnvType.CLIENT)
    public void onButtonClicked(Button button, boolean canClick) {
        if (canClick) {
            button.playClickSound();
            new ClaimRewardMessage(this.id, true).sendToServer();
        }
    }

    public boolean getExcludeFromClaimAll() {
        return this.getType().getExcludeFromListRewards();
    }

    @Nullable
    @Environment(value=EnvType.CLIENT)
    public Object getIngredient() {
        return this.getIcon().getIngredient();
    }

    @Override
    public final int refreshJEI() {
        return FTBQuestsJEIHelper.QUESTS;
    }

    @Environment(value=EnvType.CLIENT)
    public String getButtonText() {
        return "";
    }
}

