/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui.quests;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.ConfigWithVariants;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.math.MathUtils;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.ContextMenuItem;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.gui.SelectQuestObjectScreen;
import dev.ftb.mods.ftbquests.gui.quests.ChapterPanel;
import dev.ftb.mods.ftbquests.gui.quests.ExpandChaptersButton;
import dev.ftb.mods.ftbquests.gui.quests.OtherButtonsPanelBottom;
import dev.ftb.mods.ftbquests.gui.quests.OtherButtonsPanelTop;
import dev.ftb.mods.ftbquests.gui.quests.QuestPanel;
import dev.ftb.mods.ftbquests.gui.quests.ViewQuestPanel;
import dev.ftb.mods.ftbquests.net.ChangeProgressMessage;
import dev.ftb.mods.ftbquests.net.EditObjectMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestObject;
import dev.ftb.mods.ftbquests.quest.QuestObjectBase;
import dev.ftb.mods.ftbquests.quest.QuestObjectType;
import dev.ftb.mods.ftbquests.quest.reward.RandomReward;
import dev.ftb.mods.ftbquests.quest.reward.Reward;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.theme.QuestTheme;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import dev.ftb.mods.ftbquests.util.ConfigQuestObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class QuestScreen
extends BaseScreen {
    public final ClientQuestFile file;
    public double scrollWidth;
    public double scrollHeight;
    public int prevMouseX;
    public int prevMouseY;
    public int grabbed;
    public Chapter selectedChapter;
    public final List<Movable> selectedObjects;
    public final ExpandChaptersButton expandChaptersButton;
    public final ChapterPanel chapterPanel;
    public final QuestPanel questPanel;
    public final OtherButtonsPanelBottom otherButtonsBottomPanel;
    public final OtherButtonsPanelTop otherButtonsTopPanel;
    public final ViewQuestPanel viewQuestPanel;
    public boolean movingObjects = false;
    public int zoom = 16;
    public long lastShiftPress = 0L;
    public static boolean grid = false;

    public QuestScreen(ClientQuestFile q) {
        this.file = q;
        this.selectedObjects = new ArrayList<Movable>();
        this.expandChaptersButton = new ExpandChaptersButton(this);
        this.chapterPanel = new ChapterPanel((Panel)this);
        this.selectedChapter = this.file.getFirstVisibleChapter(this.file.self);
        this.questPanel = new QuestPanel((Panel)this);
        this.otherButtonsBottomPanel = new OtherButtonsPanelBottom((Panel)this);
        this.otherButtonsTopPanel = new OtherButtonsPanelTop((Panel)this);
        this.viewQuestPanel = new ViewQuestPanel(this);
        this.selectChapter(null);
    }

    @Nullable
    public Quest getViewedQuest() {
        return this.viewQuestPanel.quest;
    }

    public boolean isViewingQuest() {
        return this.getViewedQuest() != null;
    }

    public void addWidgets() {
        QuestTheme.currentObject = this.selectedChapter;
        this.add((Widget)this.chapterPanel);
        this.add((Widget)this.questPanel);
        this.add(this.expandChaptersButton);
        this.add((Widget)this.otherButtonsBottomPanel);
        this.add((Widget)this.otherButtonsTopPanel);
        this.add((Widget)this.viewQuestPanel);
    }

    public void alignWidgets() {
        QuestTheme.currentObject = this.selectedChapter;
        this.otherButtonsBottomPanel.alignWidgets();
        this.otherButtonsTopPanel.alignWidgets();
        this.chapterPanel.alignWidgets();
        this.expandChaptersButton.setPosAndSize(0, 0, 20, this.height);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void onClosed() {
        super.onClosed();
    }

    public void selectChapter(@Nullable Chapter chapter) {
        if (this.selectedChapter != chapter) {
            this.closeQuest();
            this.selectedChapter = chapter;
            this.questPanel.refreshWidgets();
            this.questPanel.resetScroll();
        }
    }

    public void viewQuest(Quest quest) {
        if (this.viewQuestPanel.quest != quest) {
            this.viewQuestPanel.quest = quest;
            this.viewQuestPanel.refreshWidgets();
        }
    }

    public void onBack() {
        if (this.isViewingQuest()) {
            this.closeQuest();
        } else {
            super.onBack();
        }
    }

    public void closeQuest() {
        if (this.viewQuestPanel.quest != null) {
            this.viewQuestPanel.quest = null;
            this.viewQuestPanel.hidePanel = false;
            this.viewQuestPanel.refreshWidgets();
        }
    }

    public void toggleSelected(Movable movable) {
        if (this.viewQuestPanel.quest != null) {
            this.viewQuestPanel.quest = null;
            this.viewQuestPanel.refreshWidgets();
        }
        if (this.selectedObjects.contains(movable)) {
            this.selectedObjects.remove(movable);
        } else {
            this.selectedObjects.add(movable);
        }
    }

    public void addObjectMenuItems(List<ContextMenuItem> contextMenu, Runnable gui, final QuestObjectBase object) {
        ConfigGroup group = new ConfigGroup("ftbquests");
        ConfigGroup g = object.createSubGroup(group);
        object.getConfig(g);
        if (!g.getValues().isEmpty()) {
            ArrayList<1> list = new ArrayList<1>();
            for (final ConfigValue c : g.getValues()) {
                if (!(c instanceof ConfigWithVariants)) continue;
                class_2588 name = new class_2588(c.getNameKey());
                if (!c.getCanEdit()) {
                    name = name.method_27692(class_124.field_1080);
                }
                list.add(new ContextMenuItem((class_2561)name, Icons.SETTINGS, null){

                    public void addMouseOverText(TooltipList list) {
                        list.add(c.getStringForGUI(c.value));
                    }

                    public void onClicked(Panel panel, MouseButton button) {
                        c.onClicked(button, accepted -> {
                            if (accepted) {
                                c2.setter.accept(c2.value);
                                new EditObjectMessage(object).sendToServer();
                            }
                        });
                    }

                    public void drawIcon(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
                        c.getIcon(c.value).draw(matrixStack, x, y, w, h);
                    }
                });
            }
            if (!list.isEmpty()) {
                list.sort(null);
                contextMenu.addAll(list);
                contextMenu.add(ContextMenuItem.SEPARATOR);
            }
        }
        contextMenu.add(new ContextMenuItem((class_2561)new class_2588("selectServer.edit"), (Icon)ThemeProperties.EDIT_ICON.get(), () -> object.onEditButtonClicked(gui)));
        if (object instanceof RandomReward && !QuestObjectBase.isNull(((RandomReward)object).getTable())) {
            contextMenu.add(new ContextMenuItem((class_2561)new class_2588("ftbquests.reward_table.edit"), (Icon)ThemeProperties.EDIT_ICON.get(), () -> ((RandomReward)object).getTable().onEditButtonClicked(gui)));
        }
        ContextMenuItem delete = new ContextMenuItem((class_2561)new class_2588("selectServer.delete"), (Icon)ThemeProperties.DELETE_ICON.get(), () -> ClientQuestFile.INSTANCE.deleteObject(object.id));
        if (!QuestScreen.isShiftKeyDown()) {
            delete.setYesNo((class_2561)new class_2588("delete_item", new Object[]{object.getTitle()}));
        }
        contextMenu.add(delete);
        contextMenu.add(new ContextMenuItem((class_2561)new class_2588("ftbquests.gui.reset_progress"), (Icon)ThemeProperties.RELOAD_ICON.get(), () -> ChangeProgressMessage.send(this.file.self, object, progressChange -> {
            progressChange.reset = true;
        })).setYesNo((class_2561)new class_2588("ftbquests.gui.reset_progress_q")));
        contextMenu.add(new ContextMenuItem((class_2561)new class_2588("ftbquests.gui.complete_instantly"), (Icon)ThemeProperties.CHECK_ICON.get(), () -> ChangeProgressMessage.send(this.file.self, object, progressChange -> {
            progressChange.reset = false;
        })).setYesNo((class_2561)new class_2588("ftbquests.gui.complete_instantly_q")));
        contextMenu.add(new ContextMenuItem((class_2561)new class_2588("ftbquests.gui.copy_id"), (Icon)ThemeProperties.WIKI_ICON.get(), () -> QuestScreen.setClipboardString((String)object.getCodeString())){

            public void addMouseOverText(TooltipList list) {
                list.add((class_2561)new class_2585(QuestObjectBase.getCodeString(object)));
            }
        });
    }

    public static void displayError(class_2561 error) {
        class_310.method_1551().method_1566().method_1999((class_368)new class_370(class_370.class_371.field_2218, (class_2561)new class_2588("ftbquests.gui.error"), error));
    }

    private boolean moveSelectedQuests(double x, double y) {
        for (Movable movable : this.selectedObjects) {
            if (movable.getChapter() != this.selectedChapter) continue;
            movable.move(this.selectedChapter, movable.getX() + x, movable.getY() + y);
        }
        return true;
    }

    public boolean keyPressed(Key key) {
        if (super.keyPressed(key)) {
            return true;
        }
        if (FTBQuestsClient.KEY_QUESTS.method_1417(key.keyCode, key.scanCode)) {
            this.closeGui(true);
            return true;
        }
        if (key.is(258)) {
            List<Chapter> visibleChapters;
            if (this.selectedChapter != null && this.file.getVisibleChapters(this.file.self).size() > 1 && !(visibleChapters = this.file.getVisibleChapters(this.file.self)).isEmpty()) {
                this.selectChapter(visibleChapters.get(MathUtils.mod((int)(visibleChapters.indexOf(this.selectedChapter) + (QuestScreen.isShiftKeyDown() ? -1 : 1)), (int)visibleChapters.size())));
            }
            return true;
        }
        if (key.is(32)) {
            this.questPanel.resetScroll();
            return true;
        }
        if (key.is(82) && key.modifiers.onlyControl()) {
            grid = !grid;
            return true;
        }
        if (key.keyCode >= 49 && key.keyCode <= 57) {
            int i = key.keyCode - 49;
            if (i < this.file.getVisibleChapters(this.file.self).size()) {
                this.selectChapter(this.file.getVisibleChapters(this.file.self).get(i));
            }
            return true;
        }
        if (key.modifiers.control() && this.selectedChapter != null && this.file.canEdit()) {
            double step = key.modifiers.shift() ? 0.1 : 0.5;
            switch (key.keyCode) {
                case 65: {
                    this.selectedObjects.addAll(this.selectedChapter.quests);
                    return true;
                }
                case 68: {
                    this.selectedObjects.clear();
                    return true;
                }
                case 264: {
                    return this.moveSelectedQuests(0.0, step);
                }
                case 265: {
                    return this.moveSelectedQuests(0.0, -step);
                }
                case 263: {
                    return this.moveSelectedQuests(-step, 0.0);
                }
                case 262: {
                    return this.moveSelectedQuests(step, 0.0);
                }
            }
        }
        if (key.keyCode == 340 || key.keyCode == 344) {
            long now = System.currentTimeMillis();
            if (this.lastShiftPress == 0L) {
                this.lastShiftPress = now;
            } else {
                if (now - this.lastShiftPress <= 400L) {
                    ConfigQuestObject c = new ConfigQuestObject(QuestObjectType.CHAPTER.or(QuestObjectType.QUEST));
                    SelectQuestObjectScreen gui = new SelectQuestObjectScreen(c, accepted -> {
                        if (accepted) {
                            if (c.value instanceof Chapter) {
                                this.selectChapter((Chapter)c.value);
                            } else if (c.value instanceof Quest) {
                                this.zoom = 20;
                                this.selectChapter(((Quest)c.value).chapter);
                                this.viewQuestPanel.hidePanel = false;
                                this.viewQuest((Quest)c.value);
                            }
                        }
                        this.openGui();
                    });
                    gui.focus();
                    gui.setTitle((class_2561)new class_2588("gui.search_box"));
                    gui.openGui();
                }
                this.lastShiftPress = 0L;
            }
        }
        return false;
    }

    public void tick() {
        if (this.selectedChapter != null && this.selectedChapter.invalid) {
            this.selectChapter(null);
        }
        if (this.selectedChapter == null) {
            this.selectChapter(this.file.getFirstVisibleChapter(this.file.self));
        }
        super.tick();
    }

    public int getZoom() {
        return this.zoom;
    }

    public double getQuestButtonSize() {
        return (double)this.getZoom() * 3.0 / 2.0;
    }

    public double getQuestButtonSpacing() {
        return (double)this.getZoom() * (Double)ThemeProperties.QUEST_SPACING.get(this.selectedChapter) / 4.0;
    }

    public void addZoom(double up) {
        int z = this.zoom;
        this.zoom = (int)class_3532.method_15350((double)((double)this.zoom + up * 4.0), (double)4.0, (double)28.0);
        if (this.zoom != z) {
            this.grabbed = 0;
            double sx = this.questPanel.centerQuestX;
            double sy = this.questPanel.centerQuestY;
            this.questPanel.resetScroll();
            this.questPanel.scrollTo(sx, sy);
        }
    }

    public void drawBackground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        QuestTheme.currentObject = this.selectedChapter;
        super.drawBackground(matrixStack, theme, x, y, w, h);
        int pw = 20;
        Color4I borderColor = (Color4I)ThemeProperties.WIDGET_BORDER.get(this.selectedChapter);
        Color4I backgroundColor = (Color4I)ThemeProperties.WIDGET_BACKGROUND.get(this.selectedChapter);
        borderColor.draw(matrixStack, x + pw - 1, y + 1, 1, h - 2);
        backgroundColor.draw(matrixStack, x + 1, y + 1, pw - 2, h - 2);
        borderColor.draw(matrixStack, x + w - pw, y + 1, 1, h - 2);
        backgroundColor.draw(matrixStack, x + w - pw + 1, y + 1, pw - 2, h - 2);
        if (this.grabbed != 0) {
            int mx = this.getMouseX();
            int my = this.getMouseY();
            if (this.scrollWidth > (double)this.questPanel.width) {
                this.questPanel.setScrollX(Math.max(Math.min(this.questPanel.getScrollX() + (double)(this.prevMouseX - mx), this.scrollWidth - (double)this.questPanel.width), 0.0));
            } else {
                this.questPanel.setScrollX((this.scrollWidth - (double)this.questPanel.width) / 2.0);
            }
            if (this.scrollHeight > (double)this.questPanel.height) {
                this.questPanel.setScrollY(Math.max(Math.min(this.questPanel.getScrollY() + (double)(this.prevMouseY - my), this.scrollHeight - (double)this.questPanel.height), 0.0));
            } else {
                this.questPanel.setScrollY((this.scrollHeight - (double)this.questPanel.height) / 2.0);
            }
            this.prevMouseX = mx;
            this.prevMouseY = my;
        }
    }

    public void drawForeground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        Color4I borderColor = (Color4I)ThemeProperties.WIDGET_BORDER.get(this.selectedChapter);
        GuiHelper.drawHollowRect((class_4587)matrixStack, (int)x, (int)y, (int)w, (int)h, (Color4I)borderColor, (boolean)false);
        super.drawForeground(matrixStack, theme, x, y, w, h);
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    public boolean drawDefaultBackground(class_4587 matrixStack) {
        return false;
    }

    public void open(@Nullable QuestObject object, boolean focus) {
        if (object instanceof Chapter) {
            this.selectChapter((Chapter)object);
        } else if (object instanceof Quest) {
            this.viewQuestPanel.hidePanel = false;
            Quest q = (Quest)object;
            this.selectChapter(q.chapter);
            this.viewQuest(q);
            if (focus) {
                this.questPanel.scrollTo(q.x + 0.5, q.y + 0.5);
            }
        } else if (object instanceof Task) {
            this.viewQuestPanel.hidePanel = false;
            this.selectChapter(((Task)object).quest.chapter);
            this.viewQuest(((Task)object).quest);
        }
        this.openGui();
    }

    public boolean handleClick(String scheme, String path) {
        if (scheme.isEmpty() && path.startsWith("#")) {
            this.open(this.file.get(this.file.getID(path)), true);
            return true;
        }
        return super.handleClick(scheme, path);
    }

    public void addMouseOverText(TooltipList list) {
        list.zOffset = 950;
        list.zOffsetItemTooltip = 500;
        super.addMouseOverText(list);
    }

    public void addInfoTooltip(TooltipList list, QuestObjectBase object) {
        if (QuestScreen.isKeyDown((int)290) || QuestScreen.isShiftKeyDown() && QuestScreen.isCtrlKeyDown()) {
            Date c;
            list.add((class_2561)new class_2585(object.getCodeString()).method_27692(class_124.field_1063));
            if (object instanceof QuestObject) {
                Date c2;
                Date s = this.file.self.getStartedTime(object.id);
                if (s != null) {
                    list.add((class_2561)new class_2585("Started: ").method_27693(s.toLocaleString()).method_27692(class_124.field_1063));
                }
                if ((c2 = this.file.self.getCompletedTime(object.id)) != null) {
                    list.add((class_2561)new class_2585("Completed: ").method_27693(c2.toLocaleString()).method_27692(class_124.field_1063));
                }
            } else if (object instanceof Reward && (c = this.file.self.getRewardClaimTime(class_310.method_1551().field_1724.method_5667(), (Reward)object)) != null) {
                list.add((class_2561)new class_2585("Claimed: ").method_27693(c.toLocaleString()).method_27692(class_124.field_1063));
            }
        }
    }
}

