/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.gui;

import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.SimpleTextButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TimeUtils;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.gui.FTBQuestsTheme;
import dev.ftb.mods.ftbquests.net.GetEmergencyItemsMessage;
import dev.ftb.mods.ftbquests.quest.QuestShape;
import java.util.ArrayList;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_4587;
import org.jetbrains.annotations.Nullable;

public class EmergencyItemsScreen
extends BaseScreen {
    private final long endTime;
    private boolean done;
    private final SimpleTextButton cancelButton;
    private final Panel itemPanel;

    public EmergencyItemsScreen() {
        this.endTime = System.currentTimeMillis() + (long)ClientQuestFile.INSTANCE.emergencyItemsCooldown * 1000L;
        this.done = false;
        this.cancelButton = new SimpleTextButton((Panel)this, (class_2561)new class_2588("gui.cancel"), (Icon)Icon.EMPTY){

            public void onClicked(MouseButton button) {
                this.playClickSound();
                this.getGui().closeGui();
            }
        };
        this.itemPanel = new Panel((Panel)this){

            public void addWidgets() {
                for (class_1799 stack : ClientQuestFile.INSTANCE.emergencyItems) {
                    this.add(new EmergencyItem(this, stack));
                }
            }

            public void alignWidgets() {
                this.setWidth(this.align((WidgetLayout)new WidgetLayout.Horizontal(3, 7, 3)));
                this.setHeight(22);
                this.setPos((EmergencyItemsScreen.this.width - EmergencyItemsScreen.this.itemPanel.width) / 2, EmergencyItemsScreen.this.height * 2 / 3 - 10);
            }
        };
    }

    public void addWidgets() {
        this.add((Widget)this.itemPanel);
        this.add((Widget)this.cancelButton);
        this.cancelButton.setPos((this.width - this.cancelButton.width) / 2, this.height * 2 / 3 + 16);
    }

    public boolean onInit() {
        return this.setFullscreen();
    }

    public void drawBackground(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
        long left = this.endTime - System.currentTimeMillis();
        if (left <= 0L) {
            if (!this.done) {
                this.done = true;
                this.cancelButton.setTitle((class_2561)new class_2588("gui.close"));
                new GetEmergencyItemsMessage().sendToServer();
            }
            left = 0L;
        }
        matrixStack.method_22903();
        matrixStack.method_22904((double)((int)((double)w / 2.0)), (double)((int)((double)h / 5.0)), 0.0);
        matrixStack.method_22905(2.0f, 2.0f, 1.0f);
        String s = class_1074.method_4662((String)"ftbquests.file.emergency_items", (Object[])new Object[0]);
        theme.drawString(matrixStack, (Object)s, (float)(-theme.getStringWidth(s)) / 2.0f, 0.0f, Color4I.WHITE, 0);
        matrixStack.method_22909();
        matrixStack.method_22903();
        matrixStack.method_22904((double)((int)((double)w / 2.0)), (double)((int)((double)h / 2.5)), 0.0);
        matrixStack.method_22905(4.0f, 4.0f, 1.0f);
        s = left <= 0L ? "00:00" : TimeUtils.getTimeString((long)(left / 1000L * 1000L + 1000L));
        int x1 = -theme.getStringWidth(s) / 2;
        theme.drawString(matrixStack, (Object)s, (float)(x1 - 1), 0.0f, Color4I.BLACK, 0);
        theme.drawString(matrixStack, (Object)s, (float)(x1 + 1), 0.0f, Color4I.BLACK, 0);
        theme.drawString(matrixStack, (Object)s, (float)x1, 1.0f, Color4I.BLACK, 0);
        theme.drawString(matrixStack, (Object)s, (float)x1, -1.0f, Color4I.BLACK, 0);
        theme.drawString(matrixStack, (Object)s, (float)x1, 0.0f, Color4I.WHITE, 0);
        matrixStack.method_22909();
    }

    public Theme getTheme() {
        return FTBQuestsTheme.INSTANCE;
    }

    private static class EmergencyItem
    extends Widget {
        private final class_1799 stack;

        public EmergencyItem(Panel p, class_1799 is) {
            super(p);
            this.setY(3);
            this.stack = is;
            this.setSize(16, 16);
        }

        public void addMouseOverText(TooltipList list) {
            ArrayList list1 = new ArrayList();
            GuiHelper.addStackTooltip((class_1799)this.stack, list1);
            for (class_2561 t : list1) {
                list.add(t);
            }
        }

        public void draw(class_4587 matrixStack, Theme theme, int x, int y, int w, int h) {
            GuiHelper.setupDrawing();
            QuestShape.get((String)"rsquare").outline.draw(matrixStack, x - 3, y - 3, w + 6, h + 6);
            matrixStack.method_22903();
            matrixStack.method_22904((double)x + (double)w / 2.0, (double)y + (double)h / 2.0, 100.0);
            GuiHelper.drawItem((class_4587)matrixStack, (class_1799)this.stack, (int)0, (boolean)true, null);
            matrixStack.method_22909();
        }

        @Nullable
        public Object getIngredientUnderMouse() {
            return this.stack;
        }
    }
}

