/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import com.mojang.blaze3d.platform.GlStateManager;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientLifecycleEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.registry.client.rendering.ColorHandlerRegistry;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.sidebar.SidebarButtonCreatedEvent;
import dev.ftb.mods.ftblibrary.ui.CustomClickEvent;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftbquests.client.ClientQuestFile;
import dev.ftb.mods.ftbquests.client.FTBQuestsClient;
import dev.ftb.mods.ftbquests.events.ClearFileCacheEvent;
import dev.ftb.mods.ftbquests.item.FTBQuestsItems;
import dev.ftb.mods.ftbquests.item.LootCrateItem;
import dev.ftb.mods.ftbquests.net.SubmitTaskMessage;
import dev.ftb.mods.ftbquests.quest.Chapter;
import dev.ftb.mods.ftbquests.quest.ChapterGroup;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.loot.LootCrate;
import dev.ftb.mods.ftbquests.quest.task.ObservationTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import dev.ftb.mods.ftbquests.quest.theme.property.ThemeProperties;
import it.unimi.dsi.fastutil.longs.LongIterator;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1935;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2585;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_368;
import net.minecraft.class_370;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_5481;

public class FTBQuestsClientEventHandler {
    private static final class_2960 QUESTS_BUTTON = new class_2960("ftbquests", "quests");
    private List<ObservationTask> observationTasks = null;
    private ObservationTask currentlyObserving = null;
    private long currentlyObservingTicks = 0L;

    public void init() {
        ClientLifecycleEvent.CLIENT_SETUP.register(this::registerItemColors);
        SidebarButtonCreatedEvent.EVENT.register(this::onSidebarButtonCreated);
        ClearFileCacheEvent.EVENT.register(this::onFileCacheClear);
        ClientTickEvent.CLIENT_PRE.register(this::onKeyEvent);
        CustomClickEvent.EVENT.register(this::onCustomClick);
        ClientTickEvent.CLIENT_PRE.register(this::onClientTick);
        ClientGuiEvent.RENDER_HUD.register(this::onScreenRender);
    }

    private void registerItemColors(class_310 minecraft) {
        ColorHandlerRegistry.registerItemColors((stack, tintIndex) -> {
            LootCrate crate = LootCrateItem.getCrate(stack);
            return crate == null ? -1 : 0xFF000000 | crate.color.rgb();
        }, (class_1935[])new class_1935[]{(class_1935)FTBQuestsItems.LOOTCRATE.get()});
    }

    private void onSidebarButtonCreated(SidebarButtonCreatedEvent event) {
        if (event.getButton().id.equals((Object)QUESTS_BUTTON)) {
            event.getButton().setCustomTextHandler(() -> {
                if (ClientQuestFile.exists()) {
                    if (ClientQuestFile.INSTANCE.disableGui && !ClientQuestFile.INSTANCE.canEdit()) {
                        return "[X]";
                    }
                    if (ClientQuestFile.INSTANCE.self.isLocked()) {
                        return "[X]";
                    }
                    if (ClientQuestFile.INSTANCE.self.hasUnclaimedRewards(class_310.method_1551().field_1724.method_5667(), ClientQuestFile.INSTANCE)) {
                        return "[!]";
                    }
                }
                return "";
            });
        }
    }

    private void onFileCacheClear(QuestFile file) {
        this.observationTasks = null;
    }

    private void onKeyEvent(class_310 mc) {
        if (FTBQuestsClient.KEY_QUESTS.method_1436()) {
            ClientQuestFile.INSTANCE.openQuestGui();
        }
    }

    private EventResult onCustomClick(CustomClickEvent event) {
        if (event.id().method_12836().equals("ftbquests") && "open_gui".equals(event.id().method_12832())) {
            if (!ClientQuestFile.exists()) {
                class_310.method_1551().method_1566().method_1999((class_368)new class_370(class_370.class_371.field_2218, (class_2561)new class_2585("Error?! Server doesn't have FTB Quests!"), null));
            } else {
                ClientQuestFile.INSTANCE.openQuestGui();
            }
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    private void onClientTick(class_310 mc) {
        if (mc.field_1687 != null && ClientQuestFile.exists() && mc.field_1724 != null) {
            if (this.observationTasks == null) {
                this.observationTasks = ClientQuestFile.INSTANCE.collect(ObservationTask.class);
            }
            if (this.observationTasks.isEmpty()) {
                return;
            }
            this.currentlyObserving = null;
            if (mc.field_1765 != null && mc.field_1765.method_17783() != class_239.class_240.field_1333) {
                for (ObservationTask task : this.observationTasks) {
                    if (ClientQuestFile.INSTANCE.self.isCompleted(task) || !task.observe((class_1657)mc.field_1724, mc.field_1765) || !ClientQuestFile.INSTANCE.self.canStartTasks(task.quest)) continue;
                    this.currentlyObserving = task;
                    break;
                }
            }
            if (this.currentlyObserving != null) {
                if (!mc.method_1493()) {
                    ++this.currentlyObservingTicks;
                }
                if (this.currentlyObservingTicks >= this.currentlyObserving.timer) {
                    new SubmitTaskMessage(this.currentlyObserving.id).sendToServer();
                    ClientQuestFile.INSTANCE.self.addProgress(this.currentlyObserving, 1L);
                    this.currentlyObserving = null;
                    this.currentlyObservingTicks = 0L;
                }
            } else {
                this.currentlyObservingTicks = 0L;
            }
        }
    }

    private void onScreenRender(class_4587 matrixStack, float tickDelta) {
        if (!ClientQuestFile.exists()) {
            return;
        }
        ClientQuestFile file = ClientQuestFile.INSTANCE;
        TeamData data = file.self;
        GlStateManager._enableBlend();
        class_310 mc = class_310.method_1551();
        int cy = mc.method_22683().method_4502() / 2;
        if (this.currentlyObserving != null) {
            int cx = mc.method_22683().method_4486() / 2;
            class_5250 cot = this.currentlyObserving.getMutableTitle().method_27695(new class_124[]{class_124.field_1054, class_124.field_1073});
            int sw = mc.field_1772.method_27525((class_5348)cot);
            int bw = Math.max(sw, 100);
            Color4I.DARK_GRAY.withAlpha(130).draw(matrixStack, cx - bw / 2 - 3, cy - 63, bw + 6, 29);
            GuiHelper.drawHollowRect((class_4587)matrixStack, (int)(cx - bw / 2 - 3), (int)(cy - 63), (int)(bw + 6), (int)29, (Color4I)Color4I.DARK_GRAY, (boolean)false);
            mc.field_1772.method_30881(matrixStack, (class_2561)cot, (float)cx - (float)sw / 2.0f, (float)(cy - 60), 0xFFFFFF);
            double completed = (double)((float)this.currentlyObservingTicks + tickDelta) / (double)this.currentlyObserving.timer;
            GuiHelper.drawHollowRect((class_4587)matrixStack, (int)(cx - bw / 2), (int)(cy - 49), (int)bw, (int)12, (Color4I)Color4I.DARK_GRAY, (boolean)false);
            Color4I.LIGHT_BLUE.withAlpha(130).draw(matrixStack, cx - bw / 2 + 1, cy - 48, (int)(((double)bw - 2.0) * completed), 10);
            String cop = this.currentlyObservingTicks * 100L / this.currentlyObserving.timer + "%";
            mc.field_1772.method_1720(matrixStack, cop, (float)cx - (float)mc.field_1772.method_1727(cop) / 2.0f, (float)(cy - 47), 0xFFFFFF);
        }
        if (!data.pinnedQuests.isEmpty()) {
            ArrayList<class_5481> list = new ArrayList<class_5481>();
            boolean first = true;
            if (data.pinnedQuests.contains(1L)) {
                for (ChapterGroup group : file.chapterGroups) {
                    for (Chapter chapter : group.chapters) {
                        for (Quest quest : chapter.quests) {
                            if (data.isCompleted(quest) || !data.canStartTasks(quest)) continue;
                            if (first) {
                                first = false;
                                continue;
                            }
                            list.add(class_5481.field_26385);
                        }
                    }
                }
            } else {
                LongIterator sw = data.pinnedQuests.iterator();
                while (sw.hasNext()) {
                    long q = (Long)sw.next();
                    Quest quest = file.getQuest(q);
                    if (quest == null) continue;
                    if (first) {
                        first = false;
                    } else {
                        list.add(class_5481.field_26385);
                    }
                    if (data.isCompleted(quest)) {
                        class_2585 component = new class_2585("");
                        component.method_10852((class_2561)quest.getMutableTitle().method_27695(new class_124[]{class_124.field_1067, class_124.field_1060}));
                        component.method_10852((class_2561)new class_2585(" 100%").method_27692(class_124.field_1077));
                        list.addAll(mc.field_1772.method_1728((class_5348)component, 160));
                        continue;
                    }
                    list.addAll(mc.field_1772.method_1728(class_5348.method_29433((class_5348[])new class_5348[]{mc.field_1772.method_27527().method_27490((class_5348)quest.getTitle(), 160, class_2583.field_24360.method_10982(Boolean.valueOf(true))), new class_2585(" ").method_27692(class_124.field_1062).method_27693(data.getRelativeProgress(quest) + "%")}), 500));
                    for (Task task : quest.tasks) {
                        if (data.isCompleted(task)) continue;
                        list.addAll(mc.field_1772.method_1728(class_5348.method_29433((class_5348[])new class_5348[]{mc.field_1772.method_27527().method_27490((class_5348)task.getTitle(), 160, class_2583.field_24360.method_27706(class_124.field_1080)), new class_2585(" ").method_27692(class_124.field_1060).method_27693(task.formatProgress(data, data.getProgress(task))).method_27693("/").method_27693(task.formatMaxProgress())}), 500));
                    }
                }
            }
            if (!list.isEmpty()) {
                int mw = 0;
                for (class_5481 s : list) {
                    mw = Math.max(mw, (int)mc.field_1772.method_27527().method_30875(s));
                }
                float scale = ((Double)ThemeProperties.PINNED_QUEST_SIZE.get(file)).floatValue();
                matrixStack.method_22903();
                matrixStack.method_22904((double)((float)mc.method_22683().method_4486() - (float)mw * scale) - 8.0, (double)cy - (double)list.size() * 4.5 * (double)scale, 100.0);
                matrixStack.method_22905(scale, scale, 1.0f);
                Color4I.BLACK.withAlpha(100).draw(matrixStack, 0, 0, mw + 8, list.size() * 9 + 8);
                for (int i = 0; i < list.size(); ++i) {
                    mc.field_1772.method_27517(matrixStack, (class_5481)list.get(i), 4.0f, (float)(i * 9 + 4), -1);
                }
                matrixStack.method_22909();
            }
        }
    }
}

