/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.client;

import dev.architectury.utils.Env;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.util.ClientTextComponentUtils;
import dev.ftb.mods.ftblibrary.util.ClientUtils;
import dev.ftb.mods.ftbquests.gui.CustomToast;
import dev.ftb.mods.ftbquests.gui.quests.QuestScreen;
import dev.ftb.mods.ftbquests.integration.FTBQuestsJEIHelper;
import dev.ftb.mods.ftbquests.net.DeleteObjectMessage;
import dev.ftb.mods.ftbquests.quest.Movable;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.QuestFile;
import dev.ftb.mods.ftbquests.quest.TeamData;
import dev.ftb.mods.ftbquests.quest.theme.QuestTheme;
import dev.ftb.mods.ftbteams.data.ClientTeamManager;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_368;

public class ClientQuestFile
extends QuestFile {
    public static ClientQuestFile INSTANCE;
    public TeamData self;
    public QuestScreen questScreen;
    public BaseScreen questGui;

    public static boolean exists() {
        return INSTANCE != null && !ClientQuestFile.INSTANCE.invalid;
    }

    @Override
    public void load() {
        if (INSTANCE != null) {
            INSTANCE.deleteChildren();
            INSTANCE.deleteSelf();
        }
        this.self = new TeamData(class_156.field_25140);
        this.self.file = this;
        this.self.name = "Loading...";
        this.self.setLocked(true);
        INSTANCE = this;
        this.refreshGui();
        FTBQuestsJEIHelper.refresh(this);
    }

    @Override
    public boolean canEdit() {
        return this.self.getCanEdit();
    }

    @Override
    public void refreshGui() {
        this.clearCachedData();
        boolean hasPrev = false;
        boolean guiOpen = false;
        int zoom = 0;
        double scrollX = 0.0;
        double scrollY = 0.0;
        long selectedChapter = 0L;
        long[] selectedQuests = new long[]{};
        boolean chaptersExpanded = false;
        if (this.questScreen != null) {
            hasPrev = true;
            zoom = this.questScreen.zoom;
            scrollX = this.questScreen.questPanel.centerQuestX;
            scrollY = this.questScreen.questPanel.centerQuestY;
            selectedChapter = this.questScreen.selectedChapter == null ? 0L : this.questScreen.selectedChapter.id;
            selectedQuests = new long[this.questScreen.selectedObjects.size()];
            int i = 0;
            for (Movable m : this.questScreen.selectedObjects) {
                if (m instanceof Quest) {
                    selectedQuests[i] = ((Quest)m).id;
                }
                ++i;
            }
            if (ClientUtils.getCurrentGuiAs(QuestScreen.class) != null) {
                guiOpen = true;
            }
            chaptersExpanded = this.questScreen.chapterPanel.expanded;
        }
        this.questScreen = new QuestScreen(this);
        this.questGui = this.questScreen;
        if (hasPrev) {
            this.questScreen.zoom = zoom;
            this.questScreen.selectChapter(this.getChapter(selectedChapter));
            for (long i : selectedQuests) {
                Quest q = this.getQuest(i);
                if (q == null) continue;
                this.questScreen.selectedObjects.add(q);
            }
            if (guiOpen) {
                this.questScreen.openGui();
            }
        }
        this.questScreen.refreshWidgets();
        if (hasPrev) {
            this.questScreen.questPanel.scrollTo(scrollX, scrollY);
        }
        this.questScreen.chapterPanel.setExpanded(chaptersExpanded);
    }

    public void openQuestGui() {
        if (ClientQuestFile.exists()) {
            if (this.disableGui && !this.canEdit()) {
                class_310.method_1551().method_1566().method_1999((class_368)new CustomToast((class_2561)new class_2588("item.ftbquests.book.disabled"), Icons.BARRIER, class_2585.field_24366));
            } else if (this.self.isLocked()) {
                class_310.method_1551().method_1566().method_1999((class_368)new CustomToast((class_2561)(this.lockMessage.isEmpty() ? new class_2585("Quests locked!") : ClientTextComponentUtils.parse((String)this.lockMessage)), Icons.BARRIER, class_2585.field_24366));
            } else {
                this.questGui.openGui();
            }
        }
    }

    @Override
    public Env getSide() {
        return Env.CLIENT;
    }

    @Override
    public void deleteObject(long id) {
        new DeleteObjectMessage(id).sendToServer();
    }

    @Override
    public void clearCachedData() {
        super.clearCachedData();
        QuestTheme.instance.clearCache();
    }

    @Override
    public TeamData getData(class_1297 player) {
        return player == class_310.method_1551().field_1724 ? this.self : this.getData(Objects.requireNonNull(ClientTeamManager.INSTANCE.getKnownPlayer((UUID)player.method_5667()), (String)"Non-null team required!").teamId);
    }
}

