/*
 * Decompiled with CFR 0.152.
 */
package com.github.klyser8.earthbounds.world.features.coalden;

import com.github.klyser8.earthbounds.entity.CarboraneaEntity;
import com.github.klyser8.earthbounds.registry.EarthboundEntities;
import com.github.klyser8.earthbounds.world.features.coalden.CoalDenFeatureConfig;
import com.mojang.serialization.Codec;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3031;
import net.minecraft.class_3730;
import net.minecraft.class_5281;
import net.minecraft.class_5425;
import net.minecraft.class_5821;

public class CoalDenFeature
extends class_3031<CoalDenFeatureConfig> {
    private final Random random = new Random();

    public CoalDenFeature(Codec<CoalDenFeatureConfig> codec) {
        super(codec);
    }

    public boolean method_13151(class_5821<CoalDenFeatureConfig> context) {
        class_2338 origin = context.method_33655();
        class_5281 world = context.method_33652();
        int xLength = 12;
        int yDepth = -8;
        int zLength = 12;
        for (int y = -yDepth; y > yDepth; --y) {
            int absY = Math.abs(y);
            int modX = xLength - this.random.nextInt(3) - absY;
            int modZ = zLength - this.random.nextInt(3) - absY;
            for (int x = Math.round(-((float)modX / 2.0f)) + this.random.nextInt(6) - 2; x < Math.round((float)modX / 2.0f) + this.random.nextInt(6) - 2; ++x) {
                for (int z = Math.round(-((float)modZ / 2.0f)) + this.random.nextInt(6) - 2; z < Math.round((float)modZ / 2.0f) + this.random.nextInt(6) - 2; ++z) {
                    class_2338.class_2339 mutable = origin.method_25503().method_10069(x, y, z).method_25503();
                    class_2680 state = world.method_8320(origin);
                    if (world.method_8320((class_2338)mutable).method_26220((class_1922)world, (class_2338)mutable).method_1110() || !world.method_8320((class_2338)mutable).method_26228((class_1922)world, (class_2338)mutable) || !world.method_8320((class_2338)mutable).method_26225()) continue;
                    float chance = this.random.nextFloat();
                    if (chance > 0.97f && absY != Math.abs(yDepth) && absY != 0) {
                        state = class_2246.field_10381.method_9564();
                    } else if ((double)chance > 0.6) {
                        state = class_2246.field_27165.method_9564();
                    } else if ((double)chance > 0.25) {
                        state = class_2246.field_10418.method_9564();
                    }
                    world.method_8652((class_2338)mutable, state, 3);
                }
            }
            this.createHole(world, origin, (int)((double)xLength / 1.5), -(yDepth + 2));
        }
        this.spawnCarboranea(world, origin);
        return true;
    }

    private void createHole(class_5281 world, class_2338 origin, int radius, int height) {
        int maxJ = 16;
        int maxK = 16;
        int maxL = 16;
        for (int j = 0; j < maxJ; ++j) {
            for (int k = 0; k < maxK; ++k) {
                for (int l = 0; l < maxL; ++l) {
                    class_2338 blockPos;
                    if (j != 0 && j != maxJ - 1 && k != 0 && k != maxK - 1 && l != 0 && l != maxL - 1) continue;
                    double d = (float)j / ((float)maxJ - 1.0f) * 2.0f - 1.0f;
                    double e = (float)k / ((float)maxK - 1.0f) * 2.0f - 1.0f;
                    double f = (float)l / ((float)maxL - 1.0f) * 2.0f - 1.0f;
                    double g = Math.sqrt(d * d + e * e + f * f);
                    d /= g;
                    e /= g;
                    f /= g;
                    double m = origin.method_10263();
                    double n = origin.method_10264();
                    double o = origin.method_10260();
                    for (float h = 2.0f * (0.7f + this.random.nextFloat() * 0.6f); h > 0.0f && !world.method_31606(blockPos = new class_2338(m, n, o)); h -= 0.22500001f) {
                        if (this.random.nextBoolean()) {
                            h -= this.random.nextFloat() / 2.0f;
                        }
                        m += d * (double)0.3f;
                        n += e * (double)0.3f;
                        o += f * (double)0.3f;
                        world.method_8652(blockPos, class_2246.field_10124.method_9564(), 16);
                    }
                }
            }
        }
    }

    private void spawnCarboranea(class_5281 world, class_2338 spawnPoint) {
        CarboraneaEntity carboranea = (CarboraneaEntity)EarthboundEntities.CARBORANEA.method_5883((class_1937)world.method_8410());
        if (carboranea != null) {
            carboranea.method_5971();
            carboranea.method_5808((double)spawnPoint.method_10263() + 0.5, spawnPoint.method_10264(), (double)spawnPoint.method_10260() + 0.5, 0.0f, 0.0f);
            carboranea.method_5943((class_5425)world, world.method_8404(spawnPoint), class_3730.field_16472, null, null);
            world.method_30771((class_1297)carboranea);
        }
    }
}

