/*
 * Decompiled with CFR 0.152.
 */
package com.github.klyser8.earthbounds.entity;

import com.github.klyser8.earthbounds.entity.CarboraneaEntity;
import com.github.klyser8.earthbounds.entity.Conductive;
import com.github.klyser8.earthbounds.mixin.AbstractFurnaceBlockEntityAccessor;
import com.github.klyser8.earthbounds.registry.EarthboundParticles;
import java.util.List;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2586;
import net.minecraft.class_2609;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3486;
import net.minecraft.class_3494;
import net.minecraft.class_3611;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import software.bernie.geckolib3.core.IAnimatable;
import software.bernie.geckolib3.core.PlayState;
import software.bernie.geckolib3.core.builder.AnimationBuilder;
import software.bernie.geckolib3.core.controller.AnimationController;
import software.bernie.geckolib3.core.event.predicate.AnimationEvent;
import software.bernie.geckolib3.core.manager.AnimationData;
import software.bernie.geckolib3.core.manager.AnimationFactory;

public class CoalChunkEntity
extends class_1308
implements Conductive,
IAnimatable {
    private AnimationFactory factory = new AnimationFactory((IAnimatable)this);
    private static final class_2940<Float> HEAT = class_2945.method_12791(CarboraneaEntity.class, (class_2941)class_2943.field_13320);
    public static final int MAX_AGE = 1200;
    private final float scale;
    private boolean extinguished;

    public CoalChunkEntity(class_1299<? extends class_1308> type, class_1937 world) {
        super(type, world);
        this.field_6011.method_12778(HEAT, (Object)Float.valueOf(400.0f - this.field_5974.nextFloat()));
        this.scale = 1.5f - this.field_5974.nextFloat() / 2.0f;
        this.extinguished = false;
    }

    private <E extends IAnimatable> PlayState defaultPredicate(AnimationEvent<E> event) {
        if (this.method_5771()) {
            event.getController().setAnimation(new AnimationBuilder().addAnimation("float", Boolean.valueOf(true)));
            return PlayState.CONTINUE;
        }
        return PlayState.STOP;
    }

    @Override
    public float updateHeat(int period) {
        float currentHeat = ((Float)this.field_6011.method_12789(HEAT)).floatValue();
        float heatChange = Conductive.calculateHeatChangePerPeriod(this.field_6002, this.method_33571(), false);
        if ((currentHeat += heatChange) > 400.0f) {
            currentHeat = 400.0f;
        } else if (currentHeat < 0.0f) {
            currentHeat = 0.0f;
        }
        if (currentHeat == 0.0f) {
            this.extinguished = true;
        }
        this.field_6011.method_12778(HEAT, (Object)Float.valueOf(currentHeat));
        return heatChange;
    }

    public class_4048 method_18377(class_4050 pose) {
        class_4048 dimensions = class_4048.method_18384((float)(this.scale / 7.0f), (float)(this.scale / 7.0f));
        if (this.method_5771()) {
            dimensions = class_4048.method_18384((float)dimensions.field_18067, (float)(dimensions.field_18068 + 0.3f));
        }
        return dimensions;
    }

    public void method_5773() {
        super.method_5773();
        int period = 10;
        float heatChange = 0.0f;
        if (this.field_6012 % period == 0) {
            heatChange = this.updateHeat(period);
            this.method_18382();
        }
        if (this.extinguished || this.field_6012 == 1200) {
            this.method_5650(class_1297.class_5529.field_26998);
            return;
        }
        if (this.getCurrentHeat() > 50.0f) {
            List entities = this.field_6002.method_8335((class_1297)this, this.method_33332());
            for (class_1297 entity : entities) {
                if (entity.method_5753() || entity instanceof CoalChunkEntity || !(entity instanceof class_1309)) continue;
                class_1309 living = (class_1309)entity;
                living.method_5639(1);
                living.method_5643(class_1282.field_5867, this.getCurrentHeat() / 100.0f);
            }
        }
        for (double x = -0.5; x < 1.5; x += 1.0) {
            for (double y = -0.5; y < 1.5; y += 1.0) {
                for (double z = -0.5; z < 1.5; z += 1.0) {
                    class_2586 block = this.field_6002.method_8321(new class_2338(this.method_23317() + x, this.method_23318() + y, this.method_23321() + z));
                    if (!(block instanceof class_2609)) continue;
                    class_2609 furnace = (class_2609)block;
                    int burnTime = ((AbstractFurnaceBlockEntityAccessor)furnace).getBurnTime();
                    ((AbstractFurnaceBlockEntityAccessor)furnace).setBurnTime(burnTime + (int)(this.getCurrentHeat() / 40.0f * this.scale));
                    if (!this.field_6002.field_9236) {
                        this.field_6002.method_8396(null, this.method_24515(), class_3417.field_15145, class_3419.field_15245, 0.25f, 2.0f);
                        this.field_6002.method_8396(null, this.method_24515(), class_3417.field_15013, class_3419.field_15245, 0.1f, 2.0f);
                    }
                    this.method_5650(class_1297.class_5529.field_26998);
                }
            }
        }
        if (this.field_6002.field_9236) {
            this.playParticles(heatChange);
        }
    }

    private void playParticles(float heatChange) {
        float chance = this.getCurrentHeat() / 400.0f / 2.0f;
        if (heatChange < 0.0f && this.field_5974.nextFloat() <= chance / 2.0f) {
            this.field_6002.method_8406((class_2394)EarthboundParticles.SCORCH_ASH, this.method_23317() + this.field_5974.nextDouble() / 10.0 - 0.05, this.method_23318(), this.method_23321() + this.field_5974.nextDouble() / 10.0 - 0.05, -0.05 + this.field_5974.nextDouble() / 10.0, 0.01, -0.05 + this.field_5974.nextDouble() / 10.0);
        }
        if (this.field_5974.nextFloat() <= chance / 10.0f && this.getCurrentHeat() > 200.0f) {
            this.field_6002.method_8406((class_2394)class_2398.field_11240, this.method_23317() + this.field_5974.nextDouble() / 10.0 - 0.05, this.method_23319(), this.method_23321() + this.field_5974.nextDouble() / 10.0 - 0.05, 0.0, 0.0, 0.0);
        }
    }

    public boolean method_26319(class_3611 fluid) {
        return fluid.method_15791((class_3494)class_3486.field_15518);
    }

    public boolean method_5655() {
        return false;
    }

    public boolean method_5643(class_1282 source, float amount) {
        if (source.method_5538() || source.method_5527()) {
            return super.method_5643(source, amount);
        }
        return false;
    }

    @Override
    public float getCurrentHeat() {
        return ((Float)this.field_6011.method_12789(HEAT)).floatValue();
    }

    @Override
    public void setCurrentHeat(float heat) {
        this.field_6011.method_12778(HEAT, (Object)Float.valueOf(heat));
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(HEAT, (Object)Float.valueOf(0.0f));
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    public boolean method_5863() {
        return this.field_6012 > 20;
    }

    public boolean method_5753() {
        return true;
    }

    public float getScale() {
        return this.scale;
    }

    public void registerControllers(AnimationData animationData) {
        animationData.addAnimationController(new AnimationController((IAnimatable)this, "default", 0.0f, this::defaultPredicate));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1296.method_26828().method_26868(class_5134.field_23716, 1.0).method_26868(class_5134.field_23718, 0.75);
    }

    public AnimationFactory getFactory() {
        return this.factory;
    }
}

