/*
 * Decompiled with CFR 0.152.
 */
package draylar.inmis.ui;

import draylar.inmis.Inmis;
import draylar.inmis.api.Dimension;
import draylar.inmis.api.Point;
import draylar.inmis.config.BackpackInfo;
import draylar.inmis.item.BackpackItem;
import draylar.inmis.util.InventoryUtils;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2480;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2540;

public class BackpackScreenHandler
extends class_1703 {
    private final class_1799 backpackStack;
    private final int padding = 8;
    private final int titleSpace = 10;

    public BackpackScreenHandler(int synchronizationID, class_1661 playerInventory, class_2540 packetByteBuf) {
        this(synchronizationID, playerInventory, packetByteBuf.method_10819());
    }

    public BackpackScreenHandler(int synchronizationID, class_1661 playerInventory, class_1799 backpackStack) {
        super(Inmis.CONTAINER_TYPE, synchronizationID);
        this.backpackStack = backpackStack;
        if (backpackStack.method_7909() instanceof BackpackItem) {
            this.setupContainer(playerInventory, backpackStack);
        } else {
            class_1657 player = playerInventory.field_7546;
            this.method_7595(player);
        }
    }

    private void setupContainer(class_1661 playerInventory, final class_1799 backpackStack) {
        int x;
        int y;
        Dimension dimension = this.getDimension();
        BackpackInfo tier = this.getItem().getTier();
        int rowWidth = tier.getRowWidth();
        int numberOfRows = tier.getNumberOfRows();
        class_2499 tag = backpackStack.method_7948().method_10554("Inventory", 10);
        BackpackInventory inventory = new BackpackInventory(rowWidth * numberOfRows){

            public void method_5431() {
                backpackStack.method_7948().method_10566("Inventory", (class_2520)InventoryUtils.toTag(this));
                super.method_5431();
            }
        };
        InventoryUtils.fromTag(tag, inventory);
        for (y = 0; y < numberOfRows; ++y) {
            for (x = 0; x < rowWidth; ++x) {
                Point backpackSlotPosition = this.getBackpackSlotPosition(dimension, x, y);
                this.method_7621(new BackpackLockedSlot((class_1263)inventory, y * rowWidth + x, backpackSlotPosition.x + 1, backpackSlotPosition.y + 1));
            }
        }
        for (y = 0; y < 3; ++y) {
            for (x = 0; x < 9; ++x) {
                Point playerInvSlotPosition = this.getPlayerInvSlotPosition(dimension, x, y);
                this.method_7621(new BackpackLockedSlot((class_1263)playerInventory, x + y * 9 + 9, playerInvSlotPosition.x + 1, playerInvSlotPosition.y + 1));
            }
        }
        for (int x2 = 0; x2 < 9; ++x2) {
            Point playerInvSlotPosition = this.getPlayerInvSlotPosition(dimension, x2, 3);
            this.method_7621(new BackpackLockedSlot((class_1263)playerInventory, x2, playerInvSlotPosition.x + 1, playerInvSlotPosition.y + 1));
        }
    }

    public BackpackItem getItem() {
        return (BackpackItem)this.backpackStack.method_7909();
    }

    public Dimension getDimension() {
        BackpackInfo tier = this.getItem().getTier();
        return new Dimension(16 + Math.max(tier.getRowWidth(), 9) * 18, 44 + (tier.getNumberOfRows() + 4) * 18);
    }

    public Point getBackpackSlotPosition(Dimension dimension, int x, int y) {
        BackpackInfo tier = this.getItem().getTier();
        return new Point(dimension.getWidth() / 2 - tier.getRowWidth() * 9 + x * 18, 18 + y * 18);
    }

    public Point getPlayerInvSlotPosition(Dimension dimension, int x, int y) {
        BackpackInfo tier = this.getItem().getTier();
        return new Point(dimension.getWidth() / 2 - 81 + x * 18, dimension.getHeight() - 8 - 72 - 3 + y * 18 + (y == 3 ? 4 : 0));
    }

    public boolean method_7597(class_1657 player) {
        return this.backpackStack.method_7909() instanceof BackpackItem;
    }

    public class_1799 getBackpackStack() {
        return this.backpackStack;
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 itemStack = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 toInsert = slot.method_7677();
            itemStack = toInsert.method_7972();
            BackpackInfo tier = this.getItem().getTier();
            if (index < tier.getNumberOfRows() * tier.getRowWidth() ? !this.method_7616(toInsert, tier.getNumberOfRows() * tier.getRowWidth(), this.field_7761.size(), true) : !this.method_7616(toInsert, 0, tier.getNumberOfRows() * tier.getRowWidth(), false)) {
                return class_1799.field_8037;
            }
            if (toInsert.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
        }
        return itemStack;
    }

    private class BackpackLockedSlot
    extends class_1735 {
        public BackpackLockedSlot(class_1263 inventory, int index, int x, int y) {
            super(inventory, index, x, y);
        }

        public boolean method_7674(class_1657 playerEntity) {
            return this.stackMovementIsAllowed(this.method_7677());
        }

        public boolean method_7680(class_1799 stack) {
            class_1792 item;
            if (Inmis.CONFIG.unstackablesOnly && stack.method_7914() > 1) {
                return false;
            }
            if (Inmis.CONFIG.disableShulkers && this.field_7871 instanceof BackpackInventory && (item = stack.method_7909()) instanceof class_1747) {
                class_1747 blockItem = (class_1747)item;
                return !(blockItem.method_7711() instanceof class_2480);
            }
            return this.stackMovementIsAllowed(stack);
        }

        private boolean stackMovementIsAllowed(class_1799 stack) {
            return !(stack.method_7909() instanceof BackpackItem) && stack != BackpackScreenHandler.this.backpackStack;
        }
    }

    public static class BackpackInventory
    extends class_1277 {
        public BackpackInventory(int slots) {
            super(slots);
        }
    }
}

