/*
 * Decompiled with CFR 0.152.
 */
package io.github.apace100.smwyg.compat;

import io.github.apace100.smwyg.ShowMeWhatYouGot;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.fabricmc.loader.api.Version;
import net.fabricmc.loader.api.VersionParsingException;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;

public class CalioPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!mixinClassName.equals("io.github.apace100.smwyg.mixin.CalioClientMixin")) {
            return true;
        }
        Optional calioMod = FabricLoader.getInstance().getModContainer("calio");
        if (calioMod.isPresent()) {
            try {
                Version highestCalioVersionWithItemSharing = Version.parse((String)"1.5.0");
                if (((ModContainer)calioMod.get()).getMetadata().getVersion().compareTo((Object)highestCalioVersionWithItemSharing) < 0) {
                    ShowMeWhatYouGot.LOGGER.info("Calio < 1.5.0 detected by Show Me What You Got, turning off Calio item sharing keybind to avoid conflicts.");
                    return true;
                }
            }
            catch (VersionParsingException e) {
                ShowMeWhatYouGot.LOGGER.warn("Could not properly detect which version of Calio was present. Possible side-effect: items are shared in chat twice.");
            }
        }
        return false;
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

