/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.common.entity.ai;

import java.util.EnumSet;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_4538;

public abstract class MoveIntoBlockGoal
extends class_1352 {
    protected final class_1314 creature;
    public final double movementSpeed;
    protected int runDelay;
    protected int timeoutCounter;
    private int maxStayTicks;
    protected class_2338 destinationBlock = class_2338.field_10980;
    private boolean isAtDestination;
    private final int searchLength;
    private final int verticalSearchRange;
    protected int verticalSearchStart;

    public MoveIntoBlockGoal(class_1314 creature, double speedIn, int length) {
        this(creature, speedIn, length, 1);
    }

    public MoveIntoBlockGoal(class_1314 creatureIn, double speed, int length, int p_i48796_5_) {
        this.creature = creatureIn;
        this.movementSpeed = speed;
        this.searchLength = length;
        this.verticalSearchStart = 0;
        this.verticalSearchRange = p_i48796_5_;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18407));
    }

    public boolean method_6264() {
        if (this.runDelay > 0) {
            --this.runDelay;
            return false;
        }
        this.runDelay = this.getRunDelay(this.creature);
        return this.searchForDestination();
    }

    protected int getRunDelay(class_1314 creatureIn) {
        return 200 + creatureIn.method_6051().nextInt(200);
    }

    public boolean method_6266() {
        return this.timeoutCounter >= -this.maxStayTicks && this.timeoutCounter <= 1200 && this.shouldMoveTo((class_4538)this.creature.field_6002, this.destinationBlock);
    }

    public void method_6269() {
        this.moveMobToBlock();
        this.timeoutCounter = 0;
        this.maxStayTicks = this.creature.method_6051().nextInt(this.creature.method_6051().nextInt(1200) + 1200) + 1200;
    }

    protected void moveMobToBlock() {
        this.creature.method_5942().method_6337((double)this.destinationBlock.method_10263() + 0.5, (double)this.destinationBlock.method_10264(), (double)this.destinationBlock.method_10260() + 0.5, this.movementSpeed);
    }

    public double getTargetDistanceSq() {
        return 1.0;
    }

    public void method_6268() {
        if (!this.destinationBlock.method_19769((class_2374)this.creature.method_19538(), this.getTargetDistanceSq())) {
            this.isAtDestination = false;
            ++this.timeoutCounter;
            if (this.shouldMove()) {
                this.creature.method_5942().method_6337((double)this.destinationBlock.method_10263() + 0.5, (double)this.destinationBlock.method_10264(), (double)this.destinationBlock.method_10260() + 0.5, this.movementSpeed);
            }
        } else {
            this.isAtDestination = true;
            --this.timeoutCounter;
        }
    }

    public boolean shouldMove() {
        return this.timeoutCounter % 40 == 0;
    }

    protected boolean isAtDestination() {
        return this.isAtDestination;
    }

    protected boolean searchForDestination() {
        class_2338 blockpos = this.creature.method_24515();
        class_2338.class_2339 blockpos$mutableblockpos = new class_2338.class_2339();
        int k = this.verticalSearchStart;
        while (k <= this.verticalSearchRange) {
            for (int l = 0; l < this.searchLength; ++l) {
                int i1 = 0;
                while (i1 <= l) {
                    int j1;
                    int n = j1 = i1 < l && i1 > -l ? l : 0;
                    while (j1 <= l) {
                        blockpos$mutableblockpos.method_10101((class_2382)blockpos).method_10100(i1, k - 1, j1);
                        if (this.creature.method_18407((class_2338)blockpos$mutableblockpos) && this.shouldMoveTo((class_4538)this.creature.field_6002, (class_2338)blockpos$mutableblockpos)) {
                            this.destinationBlock = blockpos$mutableblockpos;
                            return true;
                        }
                        j1 = j1 > 0 ? -j1 : 1 - j1;
                    }
                    i1 = i1 > 0 ? -i1 : 1 - i1;
                }
            }
            k = k > 0 ? -k : 1 - k;
        }
        return false;
    }

    protected abstract boolean shouldMoveTo(class_4538 var1, class_2338 var2);
}

