/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalsplus.client;

import com.google.common.collect.ImmutableMap;
import dev.architectury.platform.Platform;
import dev.architectury.registry.client.rendering.BlockEntityRendererRegistry;
import dev.itsmeow.betteranimalsplus.BetterAnimalsPlusMod;
import dev.itsmeow.betteranimalsplus.client.dumb.DeveloperRenderThing;
import dev.itsmeow.betteranimalsplus.client.model.armor.ModelBearCape;
import dev.itsmeow.betteranimalsplus.client.model.armor.ModelWolfCape;
import dev.itsmeow.betteranimalsplus.client.model.block.ModelTrillium;
import dev.itsmeow.betteranimalsplus.client.model.block.ModelTrilliumMulti;
import dev.itsmeow.betteranimalsplus.client.model.block.ModelTrilliumMulti2;
import dev.itsmeow.betteranimalsplus.client.model.block.head.ModelBlackBearHead;
import dev.itsmeow.betteranimalsplus.client.model.block.head.ModelBoarHead;
import dev.itsmeow.betteranimalsplus.client.model.block.head.ModelBrownBearHead;
import dev.itsmeow.betteranimalsplus.client.model.block.head.ModelCoyoteHead;
import dev.itsmeow.betteranimalsplus.client.model.block.head.ModelDeerHead;
import dev.itsmeow.betteranimalsplus.client.model.block.head.ModelFeralWolfHead;
import dev.itsmeow.betteranimalsplus.client.model.block.head.ModelMooseHead;
import dev.itsmeow.betteranimalsplus.client.model.block.head.ModelReindeerHead;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelBadger;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelBarracuda;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelBeakedWhale;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelBlackBear;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelBoar;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelBobbitWorm;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelBrownBear;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelButterfly;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelColossalSquid;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelCoyote;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelCrab;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelDeer;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelDragonfly;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelFeralWolf;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelFlyingFish;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelFreshwaterEel;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelGiantSquid;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelGoose;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelHorseshoeCrab;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelJellyfish;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelLammergeier;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelLamprey;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelMoose;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelNautilus;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelOctopus;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelPheasant;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelPiranha;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelReindeer;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelSaltwaterEel;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelSmallWhale;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelSongbird;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelSongbirdSmall;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelSquirrel;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelTarantula;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelTurkey;
import dev.itsmeow.betteranimalsplus.client.model.entity.ModelWalrus;
import dev.itsmeow.betteranimalsplus.client.model.entity.shark.ModelBlueShark;
import dev.itsmeow.betteranimalsplus.client.model.entity.shark.ModelBullShark;
import dev.itsmeow.betteranimalsplus.client.model.entity.shark.ModelGoblinShark;
import dev.itsmeow.betteranimalsplus.client.model.entity.shark.ModelGreatWhiteShark;
import dev.itsmeow.betteranimalsplus.client.model.entity.shark.ModelGreenlandShark;
import dev.itsmeow.betteranimalsplus.client.model.entity.shark.ModelHammerheadShark;
import dev.itsmeow.betteranimalsplus.client.model.entity.shark.ModelMakoShark;
import dev.itsmeow.betteranimalsplus.client.model.entity.shark.ModelTigerShark;
import dev.itsmeow.betteranimalsplus.client.model.entity.shark.ModelWhiteTipShark;
import dev.itsmeow.betteranimalsplus.client.renderer.blockentity.RenderBlockTrillium;
import dev.itsmeow.betteranimalsplus.client.renderer.entity.RenderTarantulaHair;
import dev.itsmeow.betteranimalsplus.client.renderer.entity.layers.GooseItemLayerRenderer;
import dev.itsmeow.betteranimalsplus.client.renderer.entity.layers.LayerEyes;
import dev.itsmeow.betteranimalsplus.client.renderer.entity.layers.LayerEyesCondition;
import dev.itsmeow.betteranimalsplus.common.entity.EntityDeer;
import dev.itsmeow.betteranimalsplus.imdlib.blockentity.HeadBlockEntity;
import dev.itsmeow.betteranimalsplus.imdlib.client.IMDLibClient;
import dev.itsmeow.betteranimalsplus.imdlib.client.render.RenderFactory;
import dev.itsmeow.betteranimalsplus.init.ModBlockEntities;
import dev.itsmeow.betteranimalsplus.init.ModEntities;
import dev.itsmeow.betteranimalsplus.init.ModResources;
import java.util.function.BiConsumer;
import net.minecraft.class_1160;
import net.minecraft.class_1296;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_4050;
import net.minecraft.class_5601;
import net.minecraft.class_5607;

public class ClientLifecycleHandler {
    public static final RenderFactory R = IMDLibClient.getRenderRegistry("betteranimalsplus");

    public static void clientInit() {
        DeveloperRenderThing.init();
        BlockEntityRendererRegistry.register((class_2591)((class_2591)ModBlockEntities.TRILLIUM_TYPE.get()), RenderBlockTrillium::new);
        HeadBlockEntity.registerTypeRender();
        if (Platform.isFabric()) {
            ClientLifecycleHandler.registerEntityRenders();
        }
        BetterAnimalsPlusMod.LOGGER.info("Rendering squirrel physics...");
    }

    public static void registerEntityRenders() {
        R.addRender(ModEntities.BROWN_BEAR::getEntityType, 1.0f, r -> r.tCondition(class_1296::method_6109, "brownbear_baby", "brownbear").mSingle(ModelBrownBear::new, "brown_bear").childScale(0.5f));
        R.addRender(ModEntities.BLACK_BEAR::getEntityType, 1.0f, r -> r.tVariant().mSingle(ModelBlackBear::new, "black_bear").childScale(0.5f));
        R.addRender(ModEntities.DEER::getEntityType, 1.0f, r -> r.tBabyVariant("deer_baby").mSingle(ModelDeer::new, "deer").childScale(0.6f).layer(t -> new LayerEyesCondition(t, ModResources.deer_christmas_glow, e -> EntityDeer.EntityDeerVariant.isChristmas)));
        R.addRender(ModEntities.LAMMERGEIER::getEntityType, 0.3f, r -> r.tVariant().mSingle(ModelLammergeier::new, "lammergeier"));
        R.addRender(ModEntities.FERAL_WOLF::getEntityType, 0.5f, r -> r.tVariant().mSingle(ModelFeralWolf::new, "feral_wolf").handleRotation((e, p) -> e.getTailRotation()).childScale(0.5f).layer(t -> new LayerEyesCondition(t, ModResources.wolf_eyes, e -> !e.method_6181())));
        R.addRender(ModEntities.COYOTE::getEntityType, 0.5f, r -> r.tMapped(e -> e.method_6181() || e.isDaytime() && !e.isHostileDaytime() ? "coyote" : "coyote_hostile").mSingle(ModelCoyote::new, "coyote").handleRotation((e, p) -> e.getTailRotation()).childScale(0.5f).layer(t -> new LayerEyesCondition(t, ModResources.coyote_eyes, e -> !e.method_6181() && (!e.isDaytime() || e.isHostileDaytime()))));
        RenderFactory.addRender(() -> ModEntities.PROJECTILE_TARANTULA_HAIR.get(), RenderTarantulaHair::new);
        R.addRender(ModEntities.TARANTULA::getEntityType, 1.0f, r -> r.tVariant().mSingle(ModelTarantula::new, "tarantula").preRender((e, s, p) -> {
            if (e.method_7167()) {
                s.method_22907(class_1160.field_20703.method_23214(-90.0f));
                s.method_22904(0.0, 0.75, -0.5);
            }
        }).layer(t -> new LayerEyes(t, ModResources.tarantula_eyes)));
        R.addRender(ModEntities.JELLYFISH::getEntityType, 0.5f, r -> r.tVariant().mSingle(ModelJellyfish::new, "jellyfish").preRender((e, s, p) -> {
            float a = e.method_18377((class_4050)class_4050.field_18076).field_18067;
            s.method_22905(a, a, a);
            s.method_22904(0.0, 1.0, 0.0);
        }));
        R.addRender(ModEntities.PHEASANT::getEntityType, 0.5f, r -> r.tBabyVariant("pheasant_baby").mSingle(ModelPheasant::new, "pheasant").childScale(0.5f).handleRotation((e, p) -> {
            float f = e.oFlap + (e.wingRotation - e.oFlap) * p;
            float f1 = e.oFlapSpeed + (e.destPos - e.oFlapSpeed) * p;
            return (class_3532.method_15374((float)f) + 1.0f) * f1;
        }));
        R.addRender(ModEntities.REINDEER::getEntityType, 1.0f, r -> r.tVariant().mSingle(ModelReindeer::new, "reindeer").ageScale(1.3f, 0.7f).layer(t -> new LayerEyesCondition(t, ModResources.reindeer_christmas_glow, e -> e.getVariantNameOrEmpty().endsWith("_christmas"))));
        R.addRender(ModEntities.BOAR::getEntityType, 0.6f, r -> r.tBabyVariant("boar_baby").mSingle(ModelBoar::new, "boar").childScale(0.6f));
        R.addRender(ModEntities.SQUIRREL::getEntityType, 0.3f, r -> r.tVariant().mSingle(ModelSquirrel::new, "squirrel").ageScale(0.5f, 0.35f));
        R.addRender(ModEntities.SONGBIRD::getEntityType, 0.3f, r -> r.tVariant().mCondition(e -> e.getVariantNameOrEmpty().isEmpty() || !e.getVariantNameOrEmpty().startsWith("small"), ModelSongbird::new, "songbird", ModelSongbirdSmall::new, "songbird_small").ageScale(0.5f, 0.3f));
        R.addRender(ModEntities.BADGER::getEntityType, 0.4f, r -> r.tVariant().mSingle(ModelBadger::new, "badger").ageScale(0.7f, 0.35f));
        R.addRender(ModEntities.LAMPREY::getEntityType, 0.4f, r -> r.tVariant().mSingle(ModelLamprey::new, "lamprey").preRender((e, s, p) -> {
            s.method_22905(0.5f, 0.5f, 0.5f);
            if (e.method_5854() != null) {
                s.method_22907(class_1160.field_20705.method_23214(180.0f));
                s.method_22904(0.0, 0.0, 0.5);
            }
        }));
        R.addRender(ModEntities.NAUTILUS::getEntityType, 0.4f, r -> r.tSingle("nautilus").mSingle(ModelNautilus::new, "nautilus"));
        R.addRender(ModEntities.CRAB::getEntityType, 0.4f, r -> r.tVariant().mSingle(ModelCrab::new, "crab").childScale(0.45f));
        R.addRender(ModEntities.HORSESHOE_CRAB::getEntityType, 0.4f, r -> r.tVariant().mSingle(ModelHorseshoeCrab::new, "horseshoe_crab").childScale(0.45f));
        R.addRender(ModEntities.SHARK::getEntityType, 2.0f, r -> r.tVariant().mMapped(e -> {
            String v = e.getVariantNameOrEmpty();
            if (v.equals("whitetip")) {
                return "white_tip_shark";
            }
            return v.isEmpty() ? "bull_shark" : v + "_shark";
        }, ModelBullShark::new, "bull_shark").mEntry(ModelBlueShark::new, "blue_shark").mEntry(ModelTigerShark::new, "tiger_shark").mEntry(ModelWhiteTipShark::new, "white_tip_shark").mEntry(ModelGreenlandShark::new, "greenland_shark").mEntry(ModelHammerheadShark::new, "hammerhead_shark").mEntry(ModelGoblinShark::new, "goblin_shark").mEntry(ModelMakoShark::new, "mako_shark").mEntry(ModelGreatWhiteShark::new, "great_white_shark").preRender((e, s, p) -> {
            switch (e.getVariantNameOrEmpty()) {
                case "blue": {
                    s.method_22905(0.8f, 0.8f, 0.8f);
                    break;
                }
                case "bull": {
                    s.method_22905(0.8f, 0.8f, 0.8f);
                    break;
                }
                case "tiger": {
                    s.method_22905(1.1f, 1.1f, 1.1f);
                    break;
                }
                case "whitetip": {
                    s.method_22905(0.9f, 0.9f, 0.9f);
                    break;
                }
                case "greenland": {
                    s.method_22905(1.7f, 1.7f, 1.7f);
                    s.method_22904(0.0, (double)0.3f, 0.0);
                    break;
                }
                case "hammerhead": {
                    s.method_22905(1.3f, 1.3f, 1.3f);
                    break;
                }
                case "goblin": {
                    s.method_22905(0.7f, 0.7f, 0.7f);
                    break;
                }
                case "mako": {
                    break;
                }
                case "great_white": {
                    s.method_22905(1.2f, 1.2f, 1.2f);
                    break;
                }
            }
        }));
        R.addRender(ModEntities.MOOSE::getEntityType, 0.8f, r -> r.tVariant().mSingle(ModelMoose::new, "moose").simpleScale(e -> Float.valueOf(1.5f)));
        RenderFactory.addRender(() -> ModEntities.PROJECTILE_PHEASANT_EGG.get(), RenderFactory.sprite());
        R.addRender(ModEntities.TURKEY::getEntityType, 0.5f, r -> r.tBabyVariant("turkey_baby").mSingle(ModelTurkey::new, "turkey").ageScale(0.8f, 0.5f).handleRotation((e, p) -> {
            float f = e.oFlap + (e.wingRotation - e.oFlap) * p;
            float f1 = e.oFlapSpeed + (e.destPos - e.oFlapSpeed) * p;
            return (class_3532.method_15374((float)f) + 1.0f) * f1;
        }));
        RenderFactory.addRender(() -> ModEntities.PROJECTILE_TURKEY_EGG.get(), RenderFactory.sprite());
        R.addRender(ModEntities.BOBBIT_WORM::getEntityType, 0.4f, r -> r.tVariant().mSingle(ModelBobbitWorm::new, "bobbit_worm"));
        R.addRender(ModEntities.GOOSE::getEntityType, 0.5f, r -> r.tBabyVariant("goose_baby").mSingle(ModelGoose::new, "goose").ageScale(0.8f, 0.5f).layer(GooseItemLayerRenderer::new));
        RenderFactory.addRender(() -> ModEntities.PROJECTILE_GOOSE_EGG.get(), RenderFactory.sprite());
        RenderFactory.addRender(() -> ModEntities.PROJECTILE_GOLDEN_GOOSE_EGG.get(), RenderFactory.sprite());
        R.addRender(ModEntities.EEL_FRESHWATER::getEntityType, 0.4f, r -> r.tVariant().mSingle(ModelFreshwaterEel::new, "freshwater_eel"));
        R.addRender(ModEntities.EEL_SALTWATER::getEntityType, 0.4f, r -> r.tVariant().mSingle(ModelSaltwaterEel::new, "saltwater_eel"));
        R.addRender(ModEntities.WHALE::getEntityType, 3.0f, r -> r.tVariant().mCondition(e -> !"cuviers".equals(e.getVariantNameOrEmpty()) && !"bottlenose".equals(e.getVariantNameOrEmpty()), ModelSmallWhale::new, "small_whale", ModelBeakedWhale::new, "beaked_whale").preRender((e, s, p) -> {
            switch (e.getVariantNameOrEmpty()) {
                case "cuviers": {
                    s.method_22905(1.7f, 1.7f, 1.7f);
                    break;
                }
                case "bottlenose": {
                    s.method_22905(2.5f, 2.5f, 2.5f);
                    break;
                }
                case "false_killer": {
                    s.method_22905(1.8f, 1.8f, 1.8f);
                    break;
                }
                case "beluga": {
                    s.method_22905(1.5f, 1.5f, 1.5f);
                    break;
                }
                case "pilot": {
                    s.method_22905(2.0f, 2.0f, 2.0f);
                    break;
                }
                case "narwhal": {
                    s.method_22905(1.6f, 1.6f, 1.6f);
                    break;
                }
            }
        }));
        R.addRender(ModEntities.WALRUS::getEntityType, 1.5f, r -> r.tSingle("walrus").mSingle(ModelWalrus::new, "walrus"));
        R.addRender(ModEntities.BUTTERFLY::getEntityType, 0.1f, r -> r.tVariant().mSingle(ModelButterfly::new, "butterfly").simpleScale(e -> Float.valueOf(e.method_18377((class_4050)class_4050.field_18076).field_18067)));
        R.addRender(ModEntities.DRAGONFLY::getEntityType, 0.1f, r -> r.tVariant().mSingle(ModelDragonfly::new, "dragonfly").simpleScale(e -> Float.valueOf(e.method_18377((class_4050)class_4050.field_18076).field_18067 / 2.0f)));
        R.addRender(ModEntities.BARRACUDA::getEntityType, 1.0f, r -> r.tSingle("barracuda").mSingle(ModelBarracuda::new, "barracuda").simpleScale(e -> Float.valueOf(0.6f)));
        R.addRender(ModEntities.FLYING_FISH::getEntityType, 1.0f, r -> r.tVariant().mSingle(ModelFlyingFish::new, "flying_fish").simpleScale(e -> Float.valueOf(0.4f)));
        R.addRender(ModEntities.SQUID_COLOSSAL::getEntityType, 5.0f, r -> r.tSingle("squid_colossal").mSingle(ModelColossalSquid::new, "colossal_squid").simpleScale(e -> Float.valueOf(1.9f)).handleRotation((e, p) -> class_3532.method_16439((float)p, (float)e.lastTentacleAngle, (float)e.tentacleAngle)).applyRotations((e, s, a, y, p) -> {
            float f = class_3532.method_16439((float)p, (float)e.prevSquidPitch, (float)e.squidPitch);
            float f1 = class_3532.method_16439((float)p, (float)e.prevSquidYaw, (float)e.squidYaw);
            s.method_22904(0.0, 0.5, 0.0);
            s.method_22907(class_1160.field_20705.method_23214(180.0f - y));
            s.method_22907(class_1160.field_20703.method_23214(f));
            s.method_22907(class_1160.field_20705.method_23214(f1));
            s.method_22904(0.0, (double)-1.2f, 0.0);
        }));
        R.addRender(ModEntities.SQUID_GIANT::getEntityType, 3.0f, r -> r.tSingle("squid_giant").mSingle(ModelGiantSquid::new, "giant_squid").simpleScale(e -> Float.valueOf(2.2f)).handleRotation((e, p) -> class_3532.method_16439((float)p, (float)e.lastTentacleAngle, (float)e.tentacleAngle)).applyRotations((e, s, a, y, p) -> {
            float f = class_3532.method_16439((float)p, (float)e.prevSquidPitch, (float)e.squidPitch);
            float f1 = class_3532.method_16439((float)p, (float)e.prevSquidYaw, (float)e.squidYaw);
            s.method_22904(0.0, 0.5, 0.0);
            s.method_22907(class_1160.field_20705.method_23214(180.0f - y));
            s.method_22907(class_1160.field_20703.method_23214(f));
            s.method_22907(class_1160.field_20705.method_23214(f1));
            s.method_22904(0.0, (double)-1.2f, 0.0);
        }));
        R.addRender(ModEntities.PIRANHA::getEntityType, 0.4f, r -> r.tSingle("piranha").mSingle(ModelPiranha::new, "piranha").simpleScale(e -> Float.valueOf(0.3f)));
        R.addRender(ModEntities.OCTOPUS::getEntityType, 1.0f, r -> r.tVariant().mSingle(ModelOctopus::new, "octopus").handleRotation((e, p) -> class_3532.method_16439((float)p, (float)e.lastTentacleAngle, (float)e.tentacleAngle)).applyRotations((e, s, a, y, p) -> {
            s.method_22907(class_1160.field_20705.method_23214(180.0f - y));
            if (e.method_5816() && (!e.isAboveBlock() || e.method_18798().method_1033() > 0.01)) {
                float f = class_3532.method_16439((float)p, (float)e.prevSquidPitch, (float)e.squidPitch);
                float f1 = class_3532.method_16439((float)p, (float)e.prevSquidYaw, (float)e.squidYaw);
                s.method_22907(class_1160.field_20703.method_23214(f));
                s.method_22907(class_1160.field_20705.method_23214(f1));
            }
        }));
        RenderFactory.addRender(() -> ModEntities.PROJECTILE_BADGER_DIRT.get(), RenderFactory.nothing());
    }

    public static void layerDefinitions(ImmutableMap.Builder<class_5601, class_5607> b) {
        BiConsumer<String, class_5607> r = (k, l) -> b.put((Object)new class_5601(new class_2960("betteranimalsplus", k), "main"), l);
        r.accept("badger", ModelBadger.createBodyLayer());
        r.accept("barracuda", ModelBarracuda.createBodyLayer());
        r.accept("beaked_whale", ModelBeakedWhale.createBodyLayer());
        r.accept("black_bear", ModelBlackBear.createBodyLayer());
        r.accept("boar", ModelBoar.createBodyLayer());
        r.accept("bobbit_worm", ModelBobbitWorm.createBodyLayer());
        r.accept("brown_bear", ModelBrownBear.createBodyLayer());
        r.accept("butterfly", ModelButterfly.createBodyLayer());
        r.accept("colossal_squid", ModelColossalSquid.createBodyLayer());
        r.accept("coyote", ModelCoyote.createBodyLayer());
        r.accept("crab", ModelCrab.createBodyLayer());
        r.accept("deer", ModelDeer.createBodyLayer());
        r.accept("dragonfly", ModelDragonfly.createBodyLayer());
        r.accept("feral_wolf", ModelFeralWolf.createBodyLayer());
        r.accept("flying_fish", ModelFlyingFish.createBodyLayer());
        r.accept("freshwater_eel", ModelFreshwaterEel.createBodyLayer());
        r.accept("giant_squid", ModelGiantSquid.createBodyLayer());
        r.accept("goose", ModelGoose.createBodyLayer());
        r.accept("horseshoe_crab", ModelHorseshoeCrab.createBodyLayer());
        r.accept("jellyfish", ModelJellyfish.createBodyLayer());
        r.accept("lammergeier", ModelLammergeier.createBodyLayer());
        r.accept("lamprey", ModelLamprey.createBodyLayer());
        r.accept("moose", ModelMoose.createBodyLayer());
        r.accept("nautilus", ModelNautilus.createBodyLayer());
        r.accept("octopus", ModelOctopus.createBodyLayer());
        r.accept("pheasant", ModelPheasant.createBodyLayer());
        r.accept("piranha", ModelPiranha.createBodyLayer());
        r.accept("reindeer", ModelReindeer.createBodyLayer());
        r.accept("saltwater_eel", ModelSaltwaterEel.createBodyLayer());
        r.accept("small_whale", ModelSmallWhale.createBodyLayer());
        r.accept("songbird", ModelSongbird.createBodyLayer());
        r.accept("songbird_small", ModelSongbirdSmall.createBodyLayer());
        r.accept("squirrel", ModelSquirrel.createBodyLayer());
        r.accept("tarantula", ModelTarantula.createBodyLayer());
        r.accept("turkey", ModelTurkey.createBodyLayer());
        r.accept("walrus", ModelWalrus.createBodyLayer());
        r.accept("blue_shark", ModelBlueShark.createBodyLayer());
        r.accept("bull_shark", ModelBullShark.createBodyLayer());
        r.accept("goblin_shark", ModelGoblinShark.createBodyLayer());
        r.accept("great_white_shark", ModelGreatWhiteShark.createBodyLayer());
        r.accept("greenland_shark", ModelGreenlandShark.createBodyLayer());
        r.accept("hammerhead_shark", ModelHammerheadShark.createBodyLayer());
        r.accept("mako_shark", ModelMakoShark.createBodyLayer());
        r.accept("tiger_shark", ModelTigerShark.createBodyLayer());
        r.accept("white_tip_shark", ModelWhiteTipShark.createBodyLayer());
        r.accept("bear_cape", ModelBearCape.createBodyLayer());
        r.accept("wolf_cape", ModelWolfCape.createBodyLayer());
        r.accept("black_bear_head", ModelBlackBearHead.createBodyLayer());
        r.accept("boar_head", ModelBoarHead.createBodyLayer());
        r.accept("brown_bear_head", ModelBrownBearHead.createBodyLayer());
        r.accept("coyote_head", ModelCoyoteHead.createBodyLayer());
        r.accept("deer_head", ModelDeerHead.createBodyLayer());
        r.accept("feral_wolf_head", ModelFeralWolfHead.createBodyLayer());
        r.accept("moose_head", ModelMooseHead.createBodyLayer());
        r.accept("reindeer_head", ModelReindeerHead.createBodyLayer());
        r.accept("trillium_single", ModelTrillium.createBodyLayer());
        r.accept("trillium_double", ModelTrilliumMulti.createBodyLayer());
        r.accept("trillium_triple", ModelTrilliumMulti2.createBodyLayer());
    }
}

