/*
 * Decompiled with CFR 0.152.
 */
package wraith.harvest_scythes.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.util.HashSet;
import java.util.Scanner;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import wraith.harvest_scythes.HarvestScythes;

public class Config {
    private static final String CONFIG_FILE = "config/harvest_scythes/config.json";
    private class_2487 configData;
    private final HashSet<String> scytheBlacklist = new HashSet();
    private final HashSet<String> macheteBlacklist = new HashSet();
    private static Config INSTANCE = null;
    private int difference = 0;

    private Config() {
    }

    public static Config getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new Config();
            INSTANCE.loadConfig();
        }
        return INSTANCE;
    }

    public boolean canScytheHarvest(class_2960 block) {
        return !this.scytheBlacklist.contains(block.toString());
    }

    public boolean canMacheteHarvest(class_2960 block) {
        return !this.macheteBlacklist.contains(block.toString());
    }

    private class_2487 getDefaults() {
        class_2487 defaultConfig = new class_2487();
        class_2499 scytheBlacklisted = new class_2499();
        scytheBlacklisted.add((Object)class_2519.method_23256((String)"minecraft:lily_pad"));
        defaultConfig.method_10566("scythe_blacklisted_blocks", (class_2520)scytheBlacklisted);
        class_2499 macheteBlacklisted = new class_2499();
        defaultConfig.method_10566("machete_blacklisted_blocks", (class_2520)macheteBlacklisted);
        return defaultConfig;
    }

    public int getIntOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10550(key);
        }
        ++this.difference;
        return defaults.method_10550(key);
    }

    public boolean getBooleanOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10577(key);
        }
        ++this.difference;
        return defaults.method_10577(key);
    }

    private String getStringOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10558(key);
        }
        ++this.difference;
        return defaults.method_10558(key);
    }

    private class_2487 getCompoundOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10562(key);
        }
        ++this.difference;
        return defaults.method_10562(key);
    }

    private class_2499 getNbtListOrDefault(class_2487 getFrom, String key, class_2487 defaults, int type) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10554(key, type);
        }
        ++this.difference;
        return defaults.method_10554(key, type);
    }

    private double getDoubleOrDefault(class_2487 getFrom, String key, class_2487 defaults) {
        if (getFrom.method_10545(key)) {
            return getFrom.method_10574(key);
        }
        ++this.difference;
        return defaults.method_10574(key);
    }

    public int getIntOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsInt();
        }
        ++this.difference;
        return defaults.method_10550(key);
    }

    public boolean getBooleanOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsBoolean();
        }
        ++this.difference;
        return defaults.method_10577(key);
    }

    private String getStringOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsString();
        }
        ++this.difference;
        return defaults.method_10558(key);
    }

    private double getDoubleOrDefault(JsonObject getFrom, String key, class_2487 defaults) {
        if (getFrom.has(key)) {
            return getFrom.get(key).getAsDouble();
        }
        ++this.difference;
        return defaults.method_10574(key);
    }

    private JsonObject toJson(class_2487 tag) {
        JsonObject json = new JsonObject();
        class_2487 defaults = this.getDefaults();
        JsonArray scytheBlacklistedJson = new JsonArray();
        class_2499 scytheBlacklisted = this.getNbtListOrDefault(tag, "scythe_blacklisted_blocks", defaults, 8);
        for (int i = 0; i < scytheBlacklisted.size(); ++i) {
            scytheBlacklistedJson.add(scytheBlacklisted.method_10608(i));
        }
        json.add("scythe_blacklisted_blocks", (JsonElement)scytheBlacklistedJson);
        JsonArray macheteBlacklistedJson = new JsonArray();
        class_2499 macheteBlacklisted = this.getNbtListOrDefault(tag, "machete_blacklisted_blocks", defaults, 8);
        for (int i = 0; i < macheteBlacklisted.size(); ++i) {
            macheteBlacklistedJson.add(macheteBlacklisted.method_10608(i));
        }
        json.add("machete_blacklisted_blocks", (JsonElement)macheteBlacklistedJson);
        this.createFile(json, this.difference > 0);
        this.difference = 0;
        return json;
    }

    private class_2487 toNbtCompound(JsonObject json) {
        class_2487 tag = new class_2487();
        class_2487 defaults = this.getDefaults();
        class_2499 scytheBlacklisted = new class_2499();
        class_2499 defaultScytheBlacklist = defaults.method_10554("scythe_blacklisted_blocks", 8);
        if (json.has("scythe_blacklisted_blocks")) {
            for (JsonElement element : json.get("scythe_blacklisted_blocks").getAsJsonArray()) {
                scytheBlacklisted.add((Object)class_2519.method_23256((String)element.getAsString()));
            }
        } else {
            ++this.difference;
            scytheBlacklisted = defaults.method_10554("scythe_blacklisted_blocks", 8);
        }
        tag.method_10566("scythe_blacklisted_blocks", (class_2520)scytheBlacklisted);
        class_2499 macheteBlacklisted = new class_2499();
        class_2499 defaultMacheteBlacklist = defaults.method_10554("machete_blacklisted_blocks", 8);
        if (json.has("machete_blacklisted_blocks")) {
            for (JsonElement element : json.get("machete_blacklisted_blocks").getAsJsonArray()) {
                macheteBlacklisted.add((Object)class_2519.method_23256((String)element.getAsString()));
            }
        } else {
            ++this.difference;
            macheteBlacklisted = defaultMacheteBlacklist;
        }
        tag.method_10566("machete_blacklisted_blocks", (class_2520)macheteBlacklisted);
        this.createFile(this.toJson(tag), this.difference > 0);
        this.difference = 0;
        return tag;
    }

    private void setConfigData(class_2487 data) {
        this.configData = data;
        class_2499 scytheBlacklistedBlocks = this.configData.method_10554("scythe_blacklisted_blocks", 8);
        this.scytheBlacklist.clear();
        for (int i = 0; i < scytheBlacklistedBlocks.size(); ++i) {
            this.scytheBlacklist.add(scytheBlacklistedBlocks.method_10608(i));
        }
        class_2499 macheteBlacklistedBlocks = this.configData.method_10554("machete_blacklisted_blocks", 8);
        this.macheteBlacklist.clear();
        for (int i = 0; i < macheteBlacklistedBlocks.size(); ++i) {
            this.macheteBlacklist.add(macheteBlacklistedBlocks.method_10608(i));
        }
    }

    public boolean loadConfig() {
        try {
            return this.loadConfig(Config.getJsonObject(Config.readFile(new File(CONFIG_FILE))));
        }
        catch (Exception e) {
            HarvestScythes.LOGGER.info("Found error with config. Using default config.");
            this.setConfigData(this.getDefaults());
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    private boolean loadConfig(JsonObject fileConfig) {
        try {
            this.setConfigData(this.toNbtCompound(fileConfig));
            return true;
        }
        catch (Exception e) {
            HarvestScythes.LOGGER.info("Found error with config. Using default config.");
            this.setConfigData(this.getDefaults());
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    public boolean loadConfig(class_2487 config) {
        try {
            this.setConfigData(config);
            return true;
        }
        catch (Exception e) {
            HarvestScythes.LOGGER.info("Found error with config. Using default config.");
            this.setConfigData(this.getDefaults());
            this.createFile(this.toJson(this.configData), true);
            return false;
        }
    }

    private void createFile(JsonObject contents, boolean overwrite) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        contents = Config.getJsonObject(gson.toJson((JsonElement)contents));
        File file = new File(CONFIG_FILE);
        if (file.exists() && !overwrite) {
            return;
        }
        file.getParentFile().mkdirs();
        try {
            file.createNewFile();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        file.setReadable(true);
        file.setWritable(true);
        if (contents == null) {
            return;
        }
        try (FileWriter writer = new FileWriter(file);){
            String json = gson.toJson((JsonElement)contents).replace("\n", "").replace("\r", "");
            writer.write(gson.toJson((JsonElement)Config.getJsonObject(json)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String readFile(File file) throws FileNotFoundException {
        Scanner scanner = new Scanner(file);
        scanner.useDelimiter("\\Z");
        String result = scanner.next();
        scanner.close();
        return result;
    }

    public static JsonObject getJsonObject(String json) {
        return JsonParser.parseString((String)json).getAsJsonObject();
    }
}

