/*
 * Decompiled with CFR 0.152.
 */
package bre2el.fpsreducer.gui;

import bre2el.fpsreducer.config.Config;
import bre2el.fpsreducer.gui.HudPos;
import bre2el.fpsreducer.handler.GuiOpenEventHandler;
import bre2el.fpsreducer.handler.WakeupEventHandler;
import bre2el.fpsreducer.util.GlUtils;
import java.util.Objects;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;

public class Hud
extends class_332 {
    private String text;
    private float scaledPosX;
    private float scaledPosY;
    private int hudColor;
    private int hudIdleColor;
    private int hudGuiModeColor;
    private class_310 mc = class_310.method_1551();
    private class_327 fontRenderer;
    private boolean hovered;
    private int dragOffsetX;
    private int dragOffsetY;
    private int x1;
    private int x2;
    private int y1;
    private int y2;
    private int curFPS;
    private double cpuLoad;
    private static Hud INSTANCE = new Hud();
    private String hudLine1;
    private String hudLine1Eco;
    private String hudLine1Gui;
    private String hudLine2;
    private int hudLine1OffsetX;
    private int hudLine1EcoOffsetX;
    private int hudLine1GuiOffsetX;
    private int hudLine2OffsetX;

    public Hud() {
        this.fontRenderer = this.mc.field_1772;
    }

    public static Hud getInstance() {
        return INSTANCE;
    }

    public void setFPSCPUData(int fps, double cpuload) {
        this.curFPS = fps;
        this.cpuLoad = cpuload;
    }

    public void drawHud(class_4587 matrixStack, int scaledWidth, int scaledHeight) {
        float scale = (float)Config.getInstance().hudScale;
        this.updatePosition(scaledWidth, scaledHeight, scale);
        if (scale != 1.0f) {
            matrixStack.method_22903();
            matrixStack.method_22905(scale, scale, 0.0f);
        }
        switch (WakeupEventHandler.INSTANCE.fpsMode) {
            case 0: {
                this.fontRenderer.method_30881(matrixStack, (class_2561)new class_2585(this.hudLine1Eco), (float)((int)this.scaledPosX + this.hudLine1EcoOffsetX), (float)((int)this.scaledPosY), this.hudIdleColor);
                break;
            }
            case 2: {
                this.fontRenderer.method_30881(matrixStack, (class_2561)new class_2585(this.hudLine1Gui), (float)((int)this.scaledPosX + this.hudLine1GuiOffsetX), (float)((int)this.scaledPosY), this.hudGuiModeColor);
                break;
            }
            default: {
                this.fontRenderer.method_30881(matrixStack, (class_2561)new class_2585(this.hudLine1), (float)((int)this.scaledPosX + this.hudLine1OffsetX), (float)((int)this.scaledPosY), this.hudColor);
            }
        }
        if (Config.getInstance().hudInfo == 3) {
            class_2585 class_25852 = new class_2585(this.hudLine2);
            float f = (int)this.scaledPosX + this.hudLine2OffsetX;
            int n = (int)this.scaledPosY;
            Objects.requireNonNull(this.fontRenderer);
            this.fontRenderer.method_30881(matrixStack, (class_2561)class_25852, f, (float)(n + 9), this.hudColor);
            if (Config.getInstance().debugLog) {
                String tpsText = String.valueOf(WakeupEventHandler.INSTANCE.getTps());
                class_2585 class_25853 = new class_2585("TPS: " + tpsText);
                float f2 = (int)this.scaledPosX + this.hudLine2OffsetX;
                int n2 = (int)this.scaledPosY;
                Objects.requireNonNull(this.fontRenderer);
                this.fontRenderer.method_30881(matrixStack, (class_2561)class_25853, f2, (float)(n2 + 9 * 2), this.hudColor);
            }
        }
        if (scale != 1.0f) {
            matrixStack.method_22909();
        }
    }

    public void updateBoxPosition(int screenWidth, int screenHeight) {
        int hudBoxHeight;
        float scale = (float)Config.getInstance().hudScale;
        String hudStr = switch (Config.getInstance().hudInfo) {
            case 1 -> "FPS: 000, CPU: 000%";
            case 2 -> "000, 000%";
            default -> "CPU: 000%";
        };
        if (Config.getInstance().hudInfo == 3) {
            Objects.requireNonNull(this.fontRenderer);
            hudBoxHeight = 9 * 2 - 2;
        } else {
            Objects.requireNonNull(this.fontRenderer);
            hudBoxHeight = 9 - 2;
        }
        int hudBoxWidth = this.fontRenderer.method_1727(hudStr) - 1;
        int hudBoxOffsetX = switch (Config.getInstance().curHudPos.alignment) {
            default -> 0;
            case 1 -> -hudBoxWidth;
            case 2 -> -hudBoxWidth / 2;
        };
        this.updatePosition(screenWidth, screenHeight, scale);
        this.x1 = Math.round((this.scaledPosX + (float)hudBoxOffsetX) * scale + (float)this.dragOffsetX);
        this.x2 = Math.round((this.scaledPosX + (float)hudBoxOffsetX) * scale + (float)this.dragOffsetX + (float)hudBoxWidth * scale);
        this.y1 = Math.round(this.scaledPosY * scale + (float)this.dragOffsetY);
        this.y2 = Math.round(this.scaledPosY * scale + (float)this.dragOffsetY + (float)hudBoxHeight * scale);
    }

    public void drawHudBox(class_4587 matrixStack, int screenWidth, int screenHeight, int mouseX, int mouseY, boolean dragging) {
        if (!Config.getInstance().hudEnabled) {
            return;
        }
        this.hovered = mouseX >= this.x1 && mouseX <= this.x2 && mouseY >= this.y1 && mouseY <= this.y2;
        int color = this.hovered || dragging ? -65281 : -1;
        this.drawRectFrame(matrixStack, this.x1, this.y1, this.x2, this.y2, color);
    }

    public void drawLineToHudBox(class_4587 matrixStack, int screenWidth, int screenHeight) {
        if (!Config.getInstance().hudEnabled) {
            return;
        }
        float zLevel = -10.0f;
        float lineWidth = 0.5f;
        int alignedX = switch (Config.getInstance().curHudPos.alignment) {
            default -> this.x1;
            case 1 -> this.x2;
            case 2 -> Math.round((float)(this.x1 + this.x2) / 2.0f);
        };
        GlUtils.pushState(matrixStack);
        GlUtils.setColor4f(1.0f, 1.0f, 1.0f, 1.0f);
        switch (Config.getInstance().getHudReferencePos()) {
            case 1: {
                GlUtils.drawLine2(matrixStack, 0, 0, alignedX, this.y1, zLevel, lineWidth);
                break;
            }
            case 2: {
                GlUtils.drawLine2(matrixStack, Math.round((float)screenWidth / 2.0f), 0, alignedX, this.y1, zLevel, lineWidth);
                break;
            }
            case 3: {
                GlUtils.drawLine2(matrixStack, screenWidth, 0, alignedX, this.y1, zLevel, lineWidth);
                break;
            }
            case 4: {
                GlUtils.drawLine2(matrixStack, screenWidth, Math.round((float)screenHeight / 2.0f), alignedX, Math.round((float)(this.y1 + this.y2) / 2.0f), zLevel, lineWidth);
                break;
            }
            case 5: {
                GlUtils.drawLine2(matrixStack, screenWidth, screenHeight, alignedX, this.y2, zLevel, lineWidth);
                break;
            }
            case 6: {
                GlUtils.drawLine2(matrixStack, Math.round((float)screenWidth / 2.0f), screenHeight, alignedX, this.y2, zLevel, lineWidth);
                break;
            }
            case 7: {
                GlUtils.drawLine2(matrixStack, 0, screenHeight, alignedX, this.y2, zLevel, lineWidth);
                break;
            }
            case 8: {
                GlUtils.drawLine2(matrixStack, 0, Math.round((float)screenHeight / 2.0f), alignedX, Math.round((float)(this.y1 + this.y2) / 2.0f), zLevel, lineWidth);
            }
        }
        GlUtils.popState(matrixStack);
    }

    public void updateHudText() {
        this.hudColor = Config.getInstance().hudColorDec;
        this.hudIdleColor = Config.getInstance().hudReductionColorDec;
        this.hudGuiModeColor = Config.getInstance().hudGuiModeColorDec;
        switch (Config.getInstance().hudInfo) {
            case 5: {
                this.hudLine1Eco = this.hudLine1 = "CPU: " + this.cpuLoadValStr(this.cpuLoad);
                this.hudLine1Gui = this.hudLine1;
                break;
            }
            case 1: {
                this.hudLine1 = Config.getInstance().hudPreText + this.curFPS + ", " + "CPU: " + this.cpuLoadValStr(this.cpuLoad);
                this.hudLine1Eco = Config.getInstance().hudReductionPreText + this.curFPS + ", " + "CPU: " + this.cpuLoadValStr(this.cpuLoad);
                this.hudLine1Gui = Config.getInstance().hudGuiModePreText + this.curFPS + ", " + "CPU: " + this.cpuLoadValStr(this.cpuLoad);
                break;
            }
            case 2: {
                String commonStr;
                this.hudLine1 = commonStr = "" + this.curFPS + ", " + this.cpuLoadValStr(this.cpuLoad);
                this.hudLine1Eco = commonStr;
                this.hudLine1Gui = this.hudLine1;
                break;
            }
            case 3: {
                this.hudLine2 = "CPU: " + this.cpuLoadValStr(this.cpuLoad);
            }
            case 4: {
                this.hudLine1 = Config.getInstance().hudPreText + this.curFPS;
                this.hudLine1Eco = Config.getInstance().hudReductionPreText + this.curFPS;
                this.hudLine1Gui = Config.getInstance().hudGuiModePreText + this.curFPS;
            }
        }
        this.updateAlignOffset();
    }

    private String cpuLoadValStr(double cpuload) {
        if (cpuload < 0.0) {
            return "n/a";
        }
        if (cpuload < 10.0) {
            return String.valueOf((float)((int)(cpuload * 10.0)) / 10.0f) + "%";
        }
        return String.valueOf((int)cpuload) + "%";
    }

    public void updateAlignOffset() {
        switch (Config.getInstance().curHudPos.alignment) {
            default: {
                this.hudLine1OffsetX = 0;
                this.hudLine1EcoOffsetX = 0;
                this.hudLine1GuiOffsetX = 0;
                this.hudLine2OffsetX = 0;
                break;
            }
            case 1: {
                this.hudLine1OffsetX = -this.fontRenderer.method_1727(this.hudLine1);
                this.hudLine1EcoOffsetX = -this.fontRenderer.method_1727(this.hudLine1Eco);
                this.hudLine1GuiOffsetX = -this.fontRenderer.method_1727(this.hudLine1Gui);
                if (Config.getInstance().hudInfo != 3) break;
                this.hudLine2OffsetX = -this.fontRenderer.method_1727(this.hudLine2);
                int minX = Math.min(this.hudLine1EcoOffsetX, this.hudLine1GuiOffsetX);
                minX = Math.min(minX, this.hudLine1OffsetX);
                this.hudLine1EcoOffsetX = this.hudLine1GuiOffsetX = (minX = Math.min(minX, this.hudLine2OffsetX));
                this.hudLine2OffsetX = this.hudLine1GuiOffsetX;
                this.hudLine1OffsetX = this.hudLine1GuiOffsetX;
                break;
            }
            case 2: {
                this.hudLine1OffsetX = -this.fontRenderer.method_1727(this.hudLine1) / 2;
                this.hudLine1EcoOffsetX = -this.fontRenderer.method_1727(this.hudLine1Eco) / 2;
                this.hudLine1GuiOffsetX = -this.fontRenderer.method_1727(this.hudLine1Gui) / 2;
                if (Config.getInstance().hudInfo != 3) break;
                this.hudLine2OffsetX = -this.fontRenderer.method_1727(this.hudLine2) / 2;
                int minX = Math.min(this.hudLine1EcoOffsetX, this.hudLine1GuiOffsetX);
                minX = Math.min(minX, this.hudLine1OffsetX);
                this.hudLine1EcoOffsetX = this.hudLine1GuiOffsetX = (minX = Math.min(minX, this.hudLine2OffsetX));
                this.hudLine2OffsetX = this.hudLine1GuiOffsetX;
                this.hudLine1OffsetX = this.hudLine1GuiOffsetX;
            }
        }
    }

    public void update() {
        this.updateHudText();
        this.updateAlignOffset();
    }

    private void updatePosition(int screenWidth, int screenHeight, float scale) {
        int boxHeight;
        HudPos hudPos = Config.getInstance().curHudPos;
        if (Config.getInstance().hudInfo == 3) {
            Objects.requireNonNull(this.fontRenderer);
            boxHeight = 9 * 2;
        } else {
            Objects.requireNonNull(this.fontRenderer);
            boxHeight = 9;
        }
        block0 : switch (Config.getInstance().getHudReferencePos()) {
            case 1: {
                this.scaledPosX = (float)hudPos.offsetX / scale;
                this.scaledPosY = (float)hudPos.offsetY / scale;
                break;
            }
            case 2: {
                this.scaledPosX = (float)(screenWidth / 2 + hudPos.offsetX) / scale;
                this.scaledPosY = (float)hudPos.offsetY / scale;
                break;
            }
            case 3: {
                this.scaledPosX = (float)(screenWidth + hudPos.offsetX) / scale;
                this.scaledPosY = (float)hudPos.offsetY / scale;
                break;
            }
            case 4: {
                this.scaledPosX = (float)(screenWidth + hudPos.offsetX) / scale;
                this.scaledPosY = (float)(screenHeight / 2 + hudPos.offsetY) / scale - (float)(boxHeight / 2);
                break;
            }
            case 5: {
                this.scaledPosX = (float)(screenWidth + hudPos.offsetX) / scale;
                this.scaledPosY = (float)(screenHeight + hudPos.offsetY) / scale - (float)(boxHeight - 1);
                break;
            }
            case 6: {
                this.scaledPosX = (float)(screenWidth / 2 + hudPos.offsetX) / scale;
                this.scaledPosY = (float)(screenHeight + hudPos.offsetY) / scale - (float)(boxHeight - 1);
                break;
            }
            case 7: {
                float dodgeY;
                this.scaledPosX = (float)hudPos.offsetX / scale;
                this.scaledPosY = (float)(screenHeight + hudPos.offsetY) / scale - (float)(boxHeight - 1);
                if (!GuiOpenEventHandler.guiChatOpened || !(this.scaledPosY > (dodgeY = (float)(screenHeight - 15) / scale - (float)(boxHeight - 1)))) break;
                switch (Config.getInstance().hudBehindChatBox) {
                    case 1: {
                        return;
                    }
                    case 2: {
                        this.scaledPosY = dodgeY;
                        break block0;
                    }
                }
                break;
            }
            case 8: {
                this.scaledPosX = (float)hudPos.offsetX / scale;
                this.scaledPosY = (float)(screenHeight / 2 + hudPos.offsetY) / scale - (float)(boxHeight / 2);
                break;
            }
        }
    }

    private void drawRectFrame(class_4587 matrixStack, int posX1, int posY1, int posX2, int posY2, int color) {
        this.method_25292(matrixStack, posX1, posX2, posY1, color);
        this.method_25292(matrixStack, posX1, posX2, posY2, color);
        this.method_25301(matrixStack, posX1, posY1, posY2, color);
        this.method_25301(matrixStack, posX2, posY1, posY2, color);
    }

    public int getPosX() {
        return this.x1;
    }

    public int getPosY() {
        return this.y1;
    }

    public void setPos(int x, int y) {
        this.scaledPosX = x;
        this.scaledPosY = y;
    }

    public void setDragOffset(int x, int y) {
        this.dragOffsetX = x;
        this.dragOffsetY = y;
    }

    public int getBoxPosX() {
        return Config.getInstance().curHudPos.offsetX + this.dragOffsetX;
    }

    public int getBoxPosY() {
        return Config.getInstance().curHudPos.offsetY + this.dragOffsetY;
    }

    public boolean isMouseOver() {
        return this.hovered;
    }
}

