/*
 * Decompiled with CFR 0.152.
 */
package uk.me.desert_island.rer.rei_stuff;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import me.shedaniel.clothconfig2.ClothConfigInitializer;
import me.shedaniel.clothconfig2.api.ScissorsHandler;
import me.shedaniel.clothconfig2.api.ScrollingContainer;
import me.shedaniel.math.Point;
import me.shedaniel.math.Rectangle;
import me.shedaniel.math.impl.PointHelper;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.gui.widgets.Tooltip;
import me.shedaniel.rei.api.client.gui.widgets.Widget;
import me.shedaniel.rei.api.client.gui.widgets.WidgetWithBounds;
import me.shedaniel.rei.api.client.gui.widgets.Widgets;
import me.shedaniel.rei.api.client.registry.display.DisplayCategory;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.api.common.util.EntryStacks;
import me.shedaniel.rei.impl.client.gui.widget.EntryWidget;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1074;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_333;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_757;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.Nullable;
import uk.me.desert_island.rer.rei_stuff.LootDisplay;

@Environment(value=EnvType.CLIENT)
public class LootCategory
implements DisplayCategory<LootDisplay> {
    public static final CategoryIdentifier<LootDisplay> CATEGORY_ID = CategoryIdentifier.of((String)"roughlyenoughresources", (String)"loot_category");

    public CategoryIdentifier<? extends LootDisplay> getCategoryIdentifier() {
        return CATEGORY_ID;
    }

    public Renderer getIcon() {
        return EntryStacks.of((class_1935)class_1802.field_8647);
    }

    public class_2561 getTitle() {
        return new class_2588("rer.loot.category");
    }

    public List<Widget> setupDisplay(LootDisplay display, Rectangle bounds) {
        ArrayList<Widget> widgets = new ArrayList<Widget>();
        widgets.add((Widget)Widgets.createLabel((Point)new Point(bounds.getCenterX(), bounds.getMaxY() - 13), (class_2561)class_333.field_18967));
        Rectangle outputsArea = this.getOutputsArea(bounds);
        widgets.add((Widget)Widgets.createSlotBase((Rectangle)outputsArea));
        widgets.add((Widget)new ScrollableSlotsWidget(outputsArea, LootCategory.map(display.getOutputs(), t -> {
            EntryIngredient stacks = t.output.map(stack -> t.original.copy());
            ArrayList<Object> lore = new ArrayList<Object>();
            lore.add(t.countText == null ? String.valueOf(((class_1799)t.original.castValue()).method_7947()) : t.countText);
            if (t.extraTextCount != null) {
                lore.set(0, class_1074.method_4662((String)"rer.function.and", (Object[])new Object[]{lore.get(0), t.extraTextCount}));
            }
            lore.set(0, "\u00a7e" + StringUtils.capitalize((String)class_1074.method_4662((String)"rer.function.count", (Object[])new Object[]{lore.get(0)})));
            if (t.extraText != null) {
                lore.add("\u00a7e" + StringUtils.capitalize((String)t.extraText));
            }
            return new TooltipEntryWidget(outputsArea, 0, 0, t.original, CollectionUtils.map(lore, class_2585::new), (List<EntryStack<?>>)t.output).noBackground().entries((Collection)stacks);
        })));
        widgets.add((Widget)Widgets.createLabel((Point)new Point(bounds.getCenterX(), bounds.getMaxY() - 10), (class_2561)new class_2585(display.getLocation().toString())).noShadow().color(-12566464, -4473925));
        this.registerWidget(display, widgets, bounds);
        return widgets;
    }

    protected void registerWidget(LootDisplay display, List<Widget> widgets, Rectangle bounds) {
        widgets.add((Widget)Widgets.createSlot((Point)new Point(bounds.getMinX() - 1, bounds.getMinY() + 1)).entry(display.inputStack));
    }

    public static <T, R> List<R> map(List<T> list, Function<T, R> function) {
        ArrayList l = Lists.newArrayList();
        for (T t : list) {
            l.add(function.apply(t));
        }
        return l;
    }

    protected Rectangle getOutputsArea(Rectangle root) {
        return new Rectangle(root.x + 18, root.y, root.width - 17, root.height - 12);
    }

    private static class ScrollableSlotsWidget
    extends WidgetWithBounds {
        private final Rectangle bounds;
        private final List<EntryWidget> widgets;
        private double target;
        private double scroll;
        private long start;
        private long duration;

        public ScrollableSlotsWidget(Rectangle bounds, List<EntryWidget> widgets) {
            this.bounds = bounds;
            this.widgets = Lists.newArrayList(widgets);
        }

        public boolean method_25401(double double_1, double double_2, double double_3) {
            if (this.containsMouse(double_1, double_2)) {
                this.offset(ClothConfigInitializer.getScrollStep() * -double_3, true);
                return true;
            }
            return false;
        }

        public void offset(double value, boolean animated) {
            this.scrollTo(this.target + value, animated);
        }

        public void scrollTo(double value, boolean animated) {
            this.scrollTo(value, animated, ClothConfigInitializer.getScrollDuration());
        }

        public void scrollTo(double value, boolean animated, long duration) {
            this.target = this.clamp(value);
            if (animated) {
                this.start = System.currentTimeMillis();
                this.duration = duration;
            } else {
                this.scroll = this.target;
            }
        }

        public final double clamp(double v) {
            return this.clamp(v, 200.0);
        }

        public final double clamp(double v, double clampExtension) {
            return class_3532.method_15350((double)v, (double)(-clampExtension), (double)((double)this.getMaxScroll() + clampExtension));
        }

        protected int getMaxScroll() {
            return Math.max(0, this.getMaxScrollPosition() - this.getBounds().height + 1);
        }

        protected int getMaxScrollPosition() {
            return class_3532.method_15386((float)((float)this.widgets.size() / (float)((this.bounds.width - 7) / 18))) * 18;
        }

        public Rectangle getBounds() {
            return this.bounds;
        }

        public void method_25394(class_4587 matrices, int mouseX, int mouseY, float delta) {
            this.updatePosition(delta);
            Rectangle innerBounds = new Rectangle(this.bounds.x + 1, this.bounds.y + 1, this.bounds.width - 7, this.bounds.height - 2);
            ScissorsHandler.INSTANCE.scissor(innerBounds);
            int size = innerBounds.width / 18;
            block0: for (int y = 0; y < class_3532.method_15386((float)((float)this.widgets.size() / (float)size)); ++y) {
                for (int x = 0; x < size; ++x) {
                    int index = y * size + x;
                    if (this.widgets.size() <= index) continue block0;
                    EntryWidget widget = this.widgets.get(index);
                    widget.getBounds().setLocation(this.bounds.x + 1 + x * 18, (int)((double)(this.bounds.y + 1 + y * 18) - this.scroll));
                    widget.method_25394(matrices, mouseX, mouseY, delta);
                }
            }
            ScissorsHandler.INSTANCE.removeLastScissor();
            ScissorsHandler.INSTANCE.scissor(this.bounds);
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((int)770, (int)771, (int)0, (int)1);
            RenderSystem.disableTexture();
            this.renderScrollBar();
            RenderSystem.enableTexture();
            RenderSystem.disableBlend();
            ScissorsHandler.INSTANCE.removeLastScissor();
        }

        private void renderScrollBar() {
            int maxScroll = this.getMaxScroll();
            int scrollbarPositionMinX = this.getBounds().getMaxX() - 7;
            int scrollbarPositionMaxX = scrollbarPositionMinX + 6;
            class_289 tessellator = class_289.method_1348();
            class_287 buffer = tessellator.method_1349();
            if (maxScroll > 0) {
                int height = (int)(((float)this.getBounds().height - 2.0f) * ((float)this.getBounds().height - 2.0f) / (float)this.getMaxScrollPosition());
                height = class_3532.method_15340((int)height, (int)32, (int)(this.getBounds().height - 2));
                height = (int)((double)height - Math.min((double)(this.scroll < 0.0 ? (int)(-this.scroll) : (this.scroll > (double)maxScroll ? (int)this.scroll - maxScroll : 0)), (double)height * 0.95));
                height = Math.max(10, height);
                int minY = Math.min(Math.max((int)this.scroll * (this.getBounds().height - 2 - height) / maxScroll + this.getBounds().y + 1, this.getBounds().y + 1), this.getBounds().getMaxY() - 1 - height);
                boolean hovered = new Rectangle(scrollbarPositionMinX, minY, scrollbarPositionMaxX - scrollbarPositionMinX, height).contains(PointHelper.ofMouse());
                int bottomC = hovered ? 168 : 128;
                int topC = hovered ? 222 : 172;
                RenderSystem.setShader(class_757::method_34540);
                buffer.method_1328(class_293.class_5596.field_27382, class_290.field_1576);
                buffer.method_22912((double)scrollbarPositionMinX, (double)(this.getBounds().y + 1), 0.0).method_1336(0, 0, 0, 255).method_1344();
                buffer.method_22912((double)scrollbarPositionMaxX, (double)(this.getBounds().y + 1), 0.0).method_1336(0, 0, 0, 255).method_1344();
                buffer.method_22912((double)scrollbarPositionMaxX, (double)(this.getBounds().getMaxY() - 1), 0.0).method_1336(0, 0, 0, 255).method_1344();
                buffer.method_22912((double)scrollbarPositionMinX, (double)(this.getBounds().getMaxY() - 1), 0.0).method_1336(0, 0, 0, 255).method_1344();
                buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + height), 0.0).method_1336(bottomC, bottomC, bottomC, 255).method_1344();
                buffer.method_22912((double)scrollbarPositionMaxX, (double)(minY + height), 0.0).method_1336(bottomC, bottomC, bottomC, 255).method_1344();
                buffer.method_22912((double)scrollbarPositionMaxX, (double)minY, 0.0).method_1336(bottomC, bottomC, bottomC, 255).method_1344();
                buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 0.0).method_1336(bottomC, bottomC, bottomC, 255).method_1344();
                buffer.method_22912((double)scrollbarPositionMinX, (double)(minY + height - 1), 0.0).method_1336(topC, topC, topC, 255).method_1344();
                buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)(minY + height - 1), 0.0).method_1336(topC, topC, topC, 255).method_1344();
                buffer.method_22912((double)(scrollbarPositionMaxX - 1), (double)minY, 0.0).method_1336(topC, topC, topC, 255).method_1344();
                buffer.method_22912((double)scrollbarPositionMinX, (double)minY, 0.0).method_1336(topC, topC, topC, 255).method_1344();
                tessellator.method_1350();
            }
        }

        private void updatePosition(float delta) {
            double[] target = new double[]{this.target};
            this.scroll = ScrollingContainer.handleScrollingPosition((double[])target, (double)this.scroll, (double)this.getMaxScroll(), (float)delta, (double)this.start, (double)this.duration);
            this.target = target[0];
        }

        public boolean method_25404(int keyCode, int scanCode, int modifiers) {
            for (EntryWidget widget : this.widgets) {
                if (!widget.method_25404(keyCode, scanCode, modifiers)) continue;
                return true;
            }
            return false;
        }

        @Nullable
        public class_364 method_25399() {
            return null;
        }

        public void method_25395(@Nullable class_364 focused) {
        }

        public List<? extends class_364> method_25396() {
            return this.widgets;
        }

        public boolean method_25397() {
            return false;
        }

        public void method_25398(boolean dragging) {
        }
    }

    private static class TooltipEntryWidget
    extends EntryWidget {
        private final EntryStack<?> original;
        private final List<EntryStack<?>> stacks;
        private final Rectangle outputsArea;

        public TooltipEntryWidget(Rectangle outputsArea, int x, int y, EntryStack<?> original, List<class_2561> lore, List<EntryStack<?>> stacks) {
            super(new Point(x, y));
            this.original = lore != null ? original.copy().tooltip(entryStack -> lore) : original;
            this.stacks = stacks;
            this.outputsArea = outputsArea;
        }

        protected void drawCurrentEntry(class_4587 matrices, int mouseX, int mouseY, float delta) {
            EntryStack entry = this.getCurrentEntry();
            entry.setZ(100);
            Rectangle innerBounds = this.getInnerBounds();
            entry.render(matrices, innerBounds, mouseX, mouseY, delta);
            if (this.stacks.isEmpty()) {
                return;
            }
            EntryStack<?> stack = this.stacks.get(this.stacks.size() == 1 ? 0 : class_3532.method_15357((double)((double)(System.currentTimeMillis() / 500L) % (double)this.stacks.size())));
            class_1799 itemStack = (class_1799)stack.castValue();
            int count = itemStack.method_7947();
            matrices.method_22903();
            String string = String.valueOf(count);
            matrices.method_22904(0.0, 0.0, (double)((float)this.getZ() + 400.0f));
            class_4597.class_4598 immediate = class_4597.method_22991((class_287)class_289.method_1348().method_1349());
            this.font.method_27521(string, (float)(innerBounds.x + 19 - 2 - this.font.method_1727(string)), (float)(innerBounds.y + 6 + 3), 0xFFFFFF, true, matrices.method_23760().method_23761(), (class_4597)immediate, false, 0, 0xF000F0);
            immediate.method_22993();
            matrices.method_22909();
        }

        public Tooltip getCurrentTooltip(Point mouse) {
            return this.original.getTooltip(mouse);
        }

        public boolean containsMouse(double mouseX, double mouseY) {
            return super.containsMouse(mouseX, mouseY) && this.outputsArea.contains(mouseX, mouseY);
        }
    }
}

