/*
 * Decompiled with CFR 0.152.
 */
package uk.me.desert_island.rer;

import com.google.gson.JsonElement;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.CompositeByteBuf;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import uk.me.desert_island.rer.RERUtils;
import uk.me.desert_island.rer.RoughlyEnoughResources;
import uk.me.desert_island.rer.client.ClientLootCache;
import uk.me.desert_island.rer.client.ClientWorldGenState;

@Environment(value=EnvType.CLIENT)
public class RoughlyEnoughResourcesClient
implements ClientModInitializer {
    private CompositeByteBuf world_state_buf;

    public void onInitializeClient() {
        ClientPlayNetworking.registerGlobalReceiver((class_2960)RoughlyEnoughResources.SEND_WORLD_GEN_STATE_START, (client, handler, this_buf, responseSender) -> {
            RERUtils.LOGGER.debug("got SEND_WORLD_GEN_STATE_START");
            this.world_state_buf = Unpooled.compositeBuffer();
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)RoughlyEnoughResources.SEND_WORLD_GEN_STATE_CHUNK, (client, handler, this_buf, responseSender) -> {
            RERUtils.LOGGER.debug("got SEND_WORLD_GEN_STATE_CHUNK");
            this.world_state_buf.addComponent(true, this_buf.retainedDuplicate());
        });
        ClientPlayNetworking.registerGlobalReceiver((class_2960)RoughlyEnoughResources.SEND_WORLD_GEN_STATE_DONE, (client, handler, this_buf, responseSender) -> {
            RERUtils.LOGGER.debug("got SEND_WORLD_GEN_STATE_DONE");
            class_2540 buf = new class_2540((ByteBuf)this.world_state_buf);
            class_2960 worldId = buf.method_10810();
            class_5321 world = class_5321.method_29179((class_5321)class_2378.field_25298, (class_2960)worldId);
            if (world == null) {
                RERUtils.LOGGER.error("Found unregistered dimension type %s, do the server and client have the same dimensions?", worldId.toString());
                return;
            }
            ClientWorldGenState state = ClientWorldGenState.byWorld((class_5321<class_1937>)world);
            state.fromNetwork(buf);
            RERUtils.LOGGER.debug("Received data for " + worldId);
        });
        if (FabricLoader.getInstance().isModLoaded("roughlyenoughitems")) {
            ClientPlayNetworking.registerGlobalReceiver((class_2960)RoughlyEnoughResources.SEND_LOOT_INFO, (client, handler, buf, responseSender) -> {
                int size = buf.readInt();
                RERUtils.LOGGER.debug("Received %d Loot Info", size);
                for (int i = 0; i < size; ++i) {
                    class_2960 identifier = buf.method_10810();
                    JsonElement json = RoughlyEnoughResources.readJson(buf);
                    ClientLootCache.ID_TO_LOOT.put(identifier, json);
                }
            });
        }
    }
}

