/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures.pieces;

import com.google.common.collect.Queues;
import com.mojang.datafixers.util.Pair;
import com.telepathicgrunt.repurposedstructures.RepurposedStructures;
import com.telepathicgrunt.repurposedstructures.misc.StructurePieceCountsManager;
import com.telepathicgrunt.repurposedstructures.mixin.structures.SinglePoolElementAccessor;
import com.telepathicgrunt.repurposedstructures.mixin.structures.StructurePoolAccessor;
import com.telepathicgrunt.repurposedstructures.utils.BoxOctree;
import com.telepathicgrunt.repurposedstructures.utils.GeneralUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.BiConsumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2385;
import net.minecraft.class_2470;
import net.minecraft.class_2680;
import net.minecraft.class_2794;
import net.minecraft.class_2902;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3111;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3499;
import net.minecraft.class_3748;
import net.minecraft.class_3777;
import net.minecraft.class_3780;
import net.minecraft.class_3781;
import net.minecraft.class_3784;
import net.minecraft.class_3785;
import net.minecraft.class_3790;
import net.minecraft.class_3812;
import net.minecraft.class_5468;
import net.minecraft.class_5539;
import net.minecraft.class_5742;
import net.minecraft.class_5819;
import net.minecraft.class_5820;
import net.minecraft.class_6622;
import net.minecraft.class_6626;
import net.minecraft.class_6834;
import org.apache.commons.lang3.mutable.MutableObject;

public class PieceLimitedJigsawManager {
    public static Optional<class_6622<class_3111>> assembleJigsawStructure(class_6834.class_6835<class_3111> context, class_3812 jigsawConfig, class_2960 structureID, class_2338 startPos, boolean doBoundaryAdjustments, boolean useHeightmap, int maxY, int minY, BiConsumer<class_6626, List<class_3790>> structureBoundsAdjuster) {
        return PieceLimitedJigsawManager.assembleJigsawStructure(context, jigsawConfig, structureID, startPos, doBoundaryAdjustments, useHeightmap, maxY, minY, new HashSet<class_2960>(), structureBoundsAdjuster);
    }

    public static Optional<class_6622<class_3111>> assembleJigsawStructure(class_6834.class_6835<class_3111> context, class_3812 jigsawConfig, class_2960 structureID, class_2338 startPos, boolean doBoundaryAdjustments, boolean useHeightmap, int maxY, int minY, Set<class_2960> poolsThatIgnoreBounds, BiConsumer<class_6626, List<class_3790>> structureBoundsAdjuster) {
        class_3784 startPieceBlueprint;
        class_2385 jigsawPoolRegistry = context.comp_314().method_33309(class_2378.field_25917);
        class_2919 random = new class_2919((class_5819)new class_5820(0L));
        random.method_12663(context.comp_308(), context.comp_309().field_9181, context.comp_309().field_9180);
        class_2470 rotation = class_2470.method_16548((Random)random);
        class_3785 startPool = (class_3785)jigsawConfig.method_27223().get();
        if (startPool == null || startPool.method_16632() == 0) {
            RepurposedStructures.LOGGER.warn("Repurposed Structures: Empty or nonexistent start pool in structure: {}  Crash is imminent", (Object)structureID);
        }
        if ((startPieceBlueprint = startPool.method_16631((Random)random)) == class_3777.field_16663) {
            return Optional.empty();
        }
        class_3790 startPiece = new class_3790(context.comp_313(), startPieceBlueprint, startPos, startPieceBlueprint.method_19308(), rotation, startPieceBlueprint.method_16628(context.comp_313(), startPos, rotation));
        class_3341 pieceBoundingBox = startPiece.method_14935();
        int pieceCenterX = (pieceBoundingBox.method_35418() + pieceBoundingBox.method_35415()) / 2;
        int pieceCenterZ = (pieceBoundingBox.method_35420() + pieceBoundingBox.method_35417()) / 2;
        int pieceCenterY = useHeightmap ? startPos.method_10264() + context.comp_306().method_20402(pieceCenterX, pieceCenterZ, class_2902.class_2903.field_13194, context.comp_311()) : startPos.method_10264();
        int yAdjustment = pieceBoundingBox.method_35416() + startPiece.method_16646();
        startPiece.method_14922(0, pieceCenterY - yAdjustment, 0);
        if (!context.comp_312().test(context.comp_306().method_16359(class_5742.method_33100((int)pieceCenterX), class_5742.method_33100((int)pieceCenterY), class_5742.method_33100((int)pieceCenterZ)))) {
            return Optional.empty();
        }
        return Optional.of((structurePiecesBuilder, contextx) -> {
            ArrayList<class_3790> components = new ArrayList<class_3790>();
            components.add(startPiece);
            Map<class_2960, StructurePieceCountsManager.RequiredPieceNeeds> requiredPieces = RepurposedStructures.structurePieceCountsManager.getRequirePieces(structureID);
            boolean runOnce = requiredPieces == null || requiredPieces.isEmpty();
            HashMap<class_2960, Integer> currentPieceCounter = new HashMap<class_2960, Integer>();
            int attempts = 0;
            while (runOnce || PieceLimitedJigsawManager.doesNotHaveAllRequiredPieces(components, requiredPieces, currentPieceCounter)) {
                if (attempts == 100) {
                    RepurposedStructures.LOGGER.error("\n-------------------------------------------------------------------\nRepurposed Structures: Failed to create valid structure with all required pieces starting from this pool file: {}. Required pieces failed to generate the required amount are: {}\n  Make sure this structure's size in the config (if it has one) is not set too low.\n  Also make sure the max height and min height for this structure in the config (if it has one) is not too close together.\n  If min and max height is super close together, the structure's pieces may not be able to fit in the narrow range and spawn.\n  Otherwise, if the min and max height ranges aren't close, and structure size isn't super small like 1 or 2, and this message still appears,\n  please report the issue to Repurposed Structures's dev with latest.log file!\n\n", (Object)startPool.method_16629(), (Object)Arrays.toString(currentPieceCounter.entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).toArray()));
                    break;
                }
                components.clear();
                components.add(startPiece);
                if (jigsawConfig.method_27222() > 0) {
                    class_238 axisAlignedBB = new class_238((double)(pieceCenterX - 80), (double)(pieceCenterY - 120), (double)(pieceCenterZ - 80), (double)(pieceCenterX + 80 + 1), (double)(pieceCenterY + 180 + 1), (double)(pieceCenterZ + 80 + 1));
                    BoxOctree boxOctree = new BoxOctree(axisAlignedBB);
                    boxOctree.addBox(class_238.method_19316((class_3341)pieceBoundingBox));
                    Entry startPieceEntry = new Entry(startPiece, (MutableObject<BoxOctree>)new MutableObject((Object)boxOctree), pieceCenterY + 80, 0);
                    Assembler assembler = new Assembler(structureID, (class_2378<class_3785>)jigsawPoolRegistry, jigsawConfig.method_27222(), context, components, (Random)random, requiredPieces, maxY, minY, poolsThatIgnoreBounds);
                    assembler.availablePieces.addLast(startPieceEntry);
                    while (!assembler.availablePieces.isEmpty()) {
                        Entry entry2 = assembler.availablePieces.removeFirst();
                        assembler.generatePiece(entry2.piece, entry2.boxOctreeMutableObject, entry2.topYLimit, entry2.depth, doBoundaryAdjustments, context.comp_311());
                    }
                }
                if (runOnce) break;
                ++attempts;
            }
            components.forEach(arg_0 -> ((class_6626)structurePiecesBuilder).method_35462(arg_0));
            structureBoundsAdjuster.accept(structurePiecesBuilder, components);
            if (structurePiecesBuilder.method_38721().method_35419() > context.comp_311().method_31600()) {
                structurePiecesBuilder.method_38719();
            }
        });
    }

    private static boolean doesNotHaveAllRequiredPieces(List<? extends class_3443> components, Map<class_2960, StructurePieceCountsManager.RequiredPieceNeeds> requiredPieces, Map<class_2960, Integer> counter) {
        counter.clear();
        requiredPieces.forEach((key, value) -> counter.put((class_2960)key, value.getRequiredAmount()));
        for (class_3443 class_34432 : components) {
            class_2960 pieceID;
            class_3784 poolElement;
            if (!(class_34432 instanceof class_3790) || !((poolElement = ((class_3790)class_34432).method_16644()) instanceof class_3781) || !counter.containsKey(pieceID = (class_2960)((SinglePoolElementAccessor)poolElement).repurposedstructures_getTemplate().left().orElse(null))) continue;
            counter.put(pieceID, counter.get(pieceID) - 1);
        }
        return counter.values().stream().anyMatch(count -> count > 0);
    }

    public record Entry(class_3790 piece, MutableObject<BoxOctree> boxOctreeMutableObject, int topYLimit, int depth) {
    }

    public static final class Assembler {
        private final class_2960 structureID;
        private final class_2378<class_3785> poolRegistry;
        private final int maxDepth;
        private final class_2794 chunkGenerator;
        private final class_3485 structureManager;
        private final List<? super class_3790> structurePieces;
        private final Random rand;
        public final Deque<Entry> availablePieces = Queues.newArrayDeque();
        private final Map<class_2960, Integer> currentPieceCounts;
        private final Map<class_2960, Integer> maximumPieceCounts;
        private final Map<class_2960, StructurePieceCountsManager.RequiredPieceNeeds> requiredPieces;
        private final int maxY;
        private final int minY;
        private final Set<class_2960> poolsThatIgnoreBounds;

        public Assembler(class_2960 structureID, class_2378<class_3785> poolRegistry, int maxDepth, class_6834.class_6835<class_3111> context, List<? super class_3790> structurePieces, Random rand, Map<class_2960, StructurePieceCountsManager.RequiredPieceNeeds> requiredPieces, int maxY, int minY, Set<class_2960> poolsThatIgnoreBounds) {
            this.structureID = structureID;
            this.poolRegistry = poolRegistry;
            this.maxDepth = maxDepth;
            this.chunkGenerator = context.comp_306();
            this.structureManager = context.comp_313();
            this.structurePieces = structurePieces;
            this.rand = rand;
            this.maxY = maxY;
            this.minY = minY;
            this.requiredPieces = requiredPieces == null ? new HashMap<class_2960, StructurePieceCountsManager.RequiredPieceNeeds>() : new HashMap<class_2960, StructurePieceCountsManager.RequiredPieceNeeds>(requiredPieces);
            this.maximumPieceCounts = new HashMap<class_2960, Integer>(RepurposedStructures.structurePieceCountsManager.getMaximumCountForPieces(structureID));
            this.poolsThatIgnoreBounds = poolsThatIgnoreBounds;
            this.currentPieceCounts = new HashMap<class_2960, Integer>();
            this.requiredPieces.forEach((key, value) -> this.currentPieceCounts.putIfAbsent((class_2960)key, 0));
            this.maximumPieceCounts.forEach((key, value) -> this.currentPieceCounts.putIfAbsent((class_2960)key, 0));
        }

        public void generatePiece(class_3790 piece, MutableObject<BoxOctree> boxOctree, int minY, int depth, boolean doBoundaryAdjustments, class_5539 heightLimitView) {
            class_3784 pieceBlueprint = piece.method_16644();
            class_2338 piecePos = piece.method_16648();
            class_2470 pieceRotation = piece.method_16888();
            class_3341 pieceBoundingBox = piece.method_14935();
            int pieceMinY = pieceBoundingBox.method_35416();
            MutableObject<BoxOctree> parentOctree = new MutableObject<BoxOctree>();
            List pieceJigsawBlocks = pieceBlueprint.method_16627(this.structureManager, piecePos, pieceRotation, this.rand);
            for (class_3499.class_3501 jigsawBlock : pieceJigsawBlocks) {
                class_3784 generatedPiece;
                int targetPieceBoundsTop;
                MutableObject<BoxOctree> octreeToUse;
                class_2350 direction = class_3748.method_26378((class_2680)jigsawBlock.field_15596);
                class_2338 jigsawBlockPos = jigsawBlock.field_15597;
                class_2338 jigsawBlockTargetPos = jigsawBlockPos.method_10093(direction);
                class_2960 jigsawBlockPool = new class_2960(jigsawBlock.field_15595.method_10558("pool"));
                Optional poolOptional = this.poolRegistry.method_17966(jigsawBlockPool);
                if (!poolOptional.isPresent() || ((class_3785)poolOptional.get()).method_16632() == 0 && !Objects.equals(jigsawBlockPool, class_5468.field_26254.method_29177())) {
                    RepurposedStructures.LOGGER.warn("Repurposed Structures: Empty or nonexistent pool: {} which is being called from {}", (Object)jigsawBlockPool, pieceBlueprint instanceof class_3781 ? ((SinglePoolElementAccessor)pieceBlueprint).repurposedstructures_getTemplate().left().get() : "not a SinglePoolElement class");
                    continue;
                }
                class_2960 jigsawBlockFallback = ((class_3785)poolOptional.get()).method_16634();
                Optional fallbackOptional = this.poolRegistry.method_17966(jigsawBlockFallback);
                if (!fallbackOptional.isPresent() || ((class_3785)fallbackOptional.get()).method_16632() == 0 && !Objects.equals(jigsawBlockFallback, class_5468.field_26254.method_29177())) {
                    RepurposedStructures.LOGGER.warn("Repurposed Structures: Empty or nonexistent pool: {} which is being called from {}", (Object)jigsawBlockFallback, pieceBlueprint instanceof class_3781 ? ((SinglePoolElementAccessor)pieceBlueprint).repurposedstructures_getTemplate().left().get() : "not a SinglePoolElement class");
                    continue;
                }
                boolean isTargetInsideCurrentPiece = pieceBoundingBox.method_14662((class_2382)jigsawBlockTargetPos);
                if (isTargetInsideCurrentPiece) {
                    octreeToUse = parentOctree;
                    targetPieceBoundsTop = pieceMinY;
                    if (parentOctree.getValue() == null) {
                        parentOctree.setValue((Object)new BoxOctree(class_238.method_19316((class_3341)pieceBoundingBox)));
                    }
                } else {
                    octreeToUse = boxOctree;
                    targetPieceBoundsTop = minY;
                }
                if (depth != this.maxDepth && (generatedPiece = this.processList(new ArrayList<Pair<class_3784, Integer>>(((StructurePoolAccessor)poolOptional.get()).repurposedstructures_getRawTemplates()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, octreeToUse, piece, depth, targetPieceBoundsTop, heightLimitView, false)) != null) continue;
                boolean ignoreBounds = false;
                if (this.poolsThatIgnoreBounds != null) {
                    ignoreBounds = this.poolsThatIgnoreBounds.contains(jigsawBlockFallback);
                }
                this.processList(new ArrayList<Pair<class_3784, Integer>>(((StructurePoolAccessor)fallbackOptional.get()).repurposedstructures_getRawTemplates()), doBoundaryAdjustments, jigsawBlock, jigsawBlockTargetPos, pieceMinY, jigsawBlockPos, octreeToUse, piece, depth, targetPieceBoundsTop, heightLimitView, ignoreBounds);
            }
        }

        private class_3784 processList(List<Pair<class_3784, Integer>> candidatePieces, boolean doBoundaryAdjustments, class_3499.class_3501 jigsawBlock, class_2338 jigsawBlockTargetPos, int pieceMinY, class_2338 jigsawBlockPos, MutableObject<BoxOctree> boxOctreeMutableObject, class_3790 piece, int depth, int targetPieceBoundsTop, class_5539 heightLimitView, boolean ignoreBounds) {
            class_3785.class_3786 piecePlacementBehavior = piece.method_16644().method_16624();
            boolean isPieceRigid = piecePlacementBehavior == class_3785.class_3786.field_16687;
            int jigsawBlockRelativeY = jigsawBlockPos.method_10264() - pieceMinY;
            int surfaceHeight = -1;
            int totalCount = candidatePieces.stream().mapToInt(Pair::getSecond).reduce(0, Integer::sum);
            while (candidatePieces.size() > 0) {
                class_3784 candidatePiece;
                Object chosenPiecePair = null;
                Optional<class_2960> pieceNeededToSpawn = this.requiredPieces.keySet().stream().filter(key -> {
                    int currentCount = this.currentPieceCounts.get(key);
                    StructurePieceCountsManager.RequiredPieceNeeds requiredPieceNeeds = this.requiredPieces.get(key);
                    int requireCount = requiredPieceNeeds == null ? 0 : requiredPieceNeeds.getRequiredAmount();
                    return currentCount < requireCount;
                }).findFirst();
                if (pieceNeededToSpawn.isPresent()) {
                    for (int i = 0; i < candidatePieces.size(); ++i) {
                        Pair<class_3784, Integer> candidatePiecePair = candidatePieces.get(i);
                        class_3784 class_37842 = (class_3784)candidatePiecePair.getFirst();
                        if (!(class_37842 instanceof class_3781) || !((class_2960)((SinglePoolElementAccessor)class_37842).repurposedstructures_getTemplate().left().get()).equals((Object)pieceNeededToSpawn.get())) continue;
                        if (depth >= Math.min(this.maxDepth - 1, this.requiredPieces.get(pieceNeededToSpawn.get()).getMinDistanceFromCenter())) {
                            chosenPiecePair = candidatePiecePair;
                            break;
                        }
                        totalCount -= ((Integer)candidatePiecePair.getSecond()).intValue();
                        candidatePieces.remove(candidatePiecePair);
                        break;
                    }
                }
                if (chosenPiecePair == null) {
                    int chosenWeight = this.rand.nextInt(totalCount) + 1;
                    for (Pair pair : candidatePieces) {
                        if ((chosenWeight -= ((Integer)pair.getSecond()).intValue()) > 0) continue;
                        chosenPiecePair = pair;
                        break;
                    }
                }
                if ((candidatePiece = (class_3784)chosenPiecePair.getFirst()) == class_3777.field_16663) {
                    return null;
                }
                class_2960 pieceName = null;
                if (candidatePiece instanceof class_3781 && this.currentPieceCounts.containsKey(pieceName = (class_2960)((SinglePoolElementAccessor)candidatePiece).repurposedstructures_getTemplate().left().get()) && this.maximumPieceCounts.containsKey(pieceName) && this.currentPieceCounts.get(pieceName) >= this.maximumPieceCounts.get(pieceName)) {
                    totalCount -= ((Integer)chosenPiecePair.getSecond()).intValue();
                    candidatePieces.remove(chosenPiecePair);
                    continue;
                }
                for (class_2470 rotation : class_2470.method_16547((Random)this.rand)) {
                    List candidateJigsawBlocks = candidatePiece.method_16627(this.structureManager, class_2338.field_10980, rotation, this.rand);
                    class_3341 tempCandidateBoundingBox = candidatePiece.method_16628(this.structureManager, class_2338.field_10980, rotation);
                    int candidateHeightAdjustments = doBoundaryAdjustments && tempCandidateBoundingBox.method_14660() <= 16 ? candidateJigsawBlocks.stream().mapToInt(pieceCandidateJigsawBlock -> {
                        if (!tempCandidateBoundingBox.method_14662((class_2382)pieceCandidateJigsawBlock.field_15597.method_10093(class_3748.method_26378((class_2680)pieceCandidateJigsawBlock.field_15596)))) {
                            return 0;
                        }
                        class_2960 candidateTargetPool = new class_2960(pieceCandidateJigsawBlock.field_15595.method_10558("pool"));
                        Optional candidateTargetPoolOptional = this.poolRegistry.method_17966(candidateTargetPool);
                        Optional<Integer> candidateTargetFallbackOptional = candidateTargetPoolOptional.flatMap(p_242843_1_ -> this.poolRegistry.method_17966(p_242843_1_.method_16634()));
                        int tallestCandidateTargetPoolPieceHeight = candidateTargetPoolOptional.map(p_242842_1_ -> p_242842_1_.method_19309(this.structureManager)).orElse(0);
                        int tallestCandidateTargetFallbackPieceHeight = candidateTargetFallbackOptional.map(p_242840_1_ -> p_242840_1_.method_19309(this.structureManager)).orElse(0);
                        return Math.max(tallestCandidateTargetPoolPieceHeight, tallestCandidateTargetFallbackPieceHeight);
                    }).max().orElse(0) : 0;
                    for (class_3499.class_3501 candidateJigsawBlock : candidateJigsawBlocks) {
                        int candidateJigsawBlockY;
                        int adjustedCandidatePieceMinY;
                        if (!GeneralUtils.canJigsawsAttach(jigsawBlock, candidateJigsawBlock)) continue;
                        class_2338 candidateJigsawBlockPos = candidateJigsawBlock.field_15597;
                        class_2338 candidateJigsawBlockRelativePos = new class_2338(jigsawBlockTargetPos.method_10263() - candidateJigsawBlockPos.method_10263(), jigsawBlockTargetPos.method_10264() - candidateJigsawBlockPos.method_10264(), jigsawBlockTargetPos.method_10260() - candidateJigsawBlockPos.method_10260());
                        class_3341 candidateBoundingBox = candidatePiece.method_16628(this.structureManager, candidateJigsawBlockRelativePos, rotation);
                        class_3785.class_3786 candidatePlacementBehavior = candidatePiece.method_16624();
                        boolean isCandidateRigid = candidatePlacementBehavior == class_3785.class_3786.field_16687;
                        int candidateJigsawBlockRelativeY = candidateJigsawBlockPos.method_10264();
                        int candidateJigsawYOffsetNeeded = jigsawBlockRelativeY - candidateJigsawBlockRelativeY + class_3748.method_26378((class_2680)jigsawBlock.field_15596).method_10164();
                        if (isPieceRigid && isCandidateRigid) {
                            adjustedCandidatePieceMinY = pieceMinY + candidateJigsawYOffsetNeeded;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.method_20402(jigsawBlockPos.method_10263(), jigsawBlockPos.method_10260(), class_2902.class_2903.field_13194, heightLimitView);
                            }
                            adjustedCandidatePieceMinY = surfaceHeight - candidateJigsawBlockRelativeY;
                        }
                        int candidatePieceYOffsetNeeded = adjustedCandidatePieceMinY - candidateBoundingBox.method_35416();
                        class_3341 adjustedCandidateBoundingBox = candidateBoundingBox.method_19311(0, candidatePieceYOffsetNeeded, 0);
                        class_2338 adjustedCandidateJigsawBlockRelativePos = candidateJigsawBlockRelativePos.method_10069(0, candidatePieceYOffsetNeeded, 0);
                        if (candidateHeightAdjustments > 0) {
                            int k2 = Math.max(candidateHeightAdjustments + 1, adjustedCandidateBoundingBox.method_35419() - adjustedCandidateBoundingBox.method_35416());
                            adjustedCandidateBoundingBox.method_34389(new class_2338(adjustedCandidateBoundingBox.method_35415(), adjustedCandidateBoundingBox.method_35416() + k2, adjustedCandidateBoundingBox.method_35417()));
                        }
                        if (adjustedCandidateBoundingBox.method_35419() > this.maxY || adjustedCandidateBoundingBox.method_35416() < this.minY) continue;
                        class_238 axisAlignedBB = class_238.method_19316((class_3341)adjustedCandidateBoundingBox);
                        class_238 axisAlignedBBDeflated = axisAlignedBB.method_1011(0.25);
                        boolean validBounds = false;
                        if (ignoreBounds || ((BoxOctree)boxOctreeMutableObject.getValue()).boundaryContains(axisAlignedBBDeflated) && !((BoxOctree)boxOctreeMutableObject.getValue()).intersectsAnyBox(axisAlignedBBDeflated)) {
                            ((BoxOctree)boxOctreeMutableObject.getValue()).addBox(axisAlignedBB);
                            validBounds = true;
                        }
                        if (!validBounds) continue;
                        int newPieceGroundLevelDelta = piece.method_16646();
                        int groundLevelDelta = isCandidateRigid ? newPieceGroundLevelDelta - candidateJigsawYOffsetNeeded : candidatePiece.method_19308();
                        class_3790 newPiece = new class_3790(this.structureManager, candidatePiece, adjustedCandidateJigsawBlockRelativePos, groundLevelDelta, rotation, adjustedCandidateBoundingBox);
                        if (isPieceRigid) {
                            candidateJigsawBlockY = pieceMinY + jigsawBlockRelativeY;
                        } else if (isCandidateRigid) {
                            candidateJigsawBlockY = adjustedCandidatePieceMinY + candidateJigsawBlockRelativeY;
                        } else {
                            if (surfaceHeight == -1) {
                                surfaceHeight = this.chunkGenerator.method_20402(jigsawBlockPos.method_10263(), jigsawBlockPos.method_10260(), class_2902.class_2903.field_13194, heightLimitView);
                            }
                            candidateJigsawBlockY = surfaceHeight + candidateJigsawYOffsetNeeded / 2;
                        }
                        piece.method_16647(new class_3780(jigsawBlockTargetPos.method_10263(), candidateJigsawBlockY - jigsawBlockRelativeY + newPieceGroundLevelDelta, jigsawBlockTargetPos.method_10260(), candidateJigsawYOffsetNeeded, candidatePlacementBehavior));
                        newPiece.method_16647(new class_3780(jigsawBlockPos.method_10263(), candidateJigsawBlockY - candidateJigsawBlockRelativeY + groundLevelDelta, jigsawBlockPos.method_10260(), -candidateJigsawYOffsetNeeded, piecePlacementBehavior));
                        this.structurePieces.add((class_3790)newPiece);
                        if (depth + 1 <= this.maxDepth) {
                            this.availablePieces.addLast(new Entry(newPiece, boxOctreeMutableObject, targetPieceBoundsTop, depth + 1));
                        }
                        if (pieceName != null && this.currentPieceCounts.containsKey(pieceName)) {
                            this.currentPieceCounts.put(pieceName, this.currentPieceCounts.get(pieceName) + 1);
                        }
                        return candidatePiece;
                    }
                }
                totalCount -= ((Integer)chosenPiecePair.getSecond()).intValue();
                candidatePieces.remove(chosenPiecePair);
            }
            return null;
        }
    }
}

