/*
 * Decompiled with CFR 0.152.
 */
package com.telepathicgrunt.repurposedstructures.world.structures.codeconfigs;

import com.telepathicgrunt.repurposedstructures.modinit.RSStructureTagMap;
import com.telepathicgrunt.repurposedstructures.modinit.RSStructures;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_2960;

public class GenericJigsawStructureCodeConfig {
    public final class_2960 startPool;
    public final int structureSize;
    public final int centerOffset;
    public final int biomeRange;
    public final int structureBlacklistRange;
    public final Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet;
    public final int allowTerrainHeightRange;
    public final int terrainHeightRadius;
    public final int minHeightLimit;
    public final int fixedYSpawn;
    public final boolean useHeightmap;
    public final boolean cannotSpawnInWater;
    public final Set<class_2960> poolsThatIgnoreBounds;

    public GenericJigsawStructureCodeConfig(class_2960 poolID, int structureSize, int centerOffset, int biomeRange, int structureBlacklistRange, Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet, int allowTerrainHeightRange, int terrainHeightRadius, int minHeightLimit, int fixedYSpawn, boolean useHeightmap, boolean cannotSpawnInWater, Set<class_2960> poolsThatIgnoreBounds) {
        this.startPool = poolID;
        this.structureSize = structureSize;
        this.centerOffset = centerOffset;
        this.biomeRange = biomeRange;
        this.structureBlacklistRange = structureBlacklistRange;
        this.avoidStructuresSet = avoidStructuresSet;
        this.allowTerrainHeightRange = allowTerrainHeightRange;
        this.terrainHeightRadius = terrainHeightRadius;
        this.minHeightLimit = minHeightLimit;
        this.fixedYSpawn = fixedYSpawn;
        this.useHeightmap = useHeightmap;
        this.cannotSpawnInWater = cannotSpawnInWater;
        this.poolsThatIgnoreBounds = poolsThatIgnoreBounds;
        RSStructures.RS_STRUCTURE_START_PIECES.add(this.startPool);
    }

    public static class Builder<T extends Builder<T>> {
        protected final class_2960 startPool;
        protected int structureSize = 1;
        protected int centerOffset = 0;
        protected int biomeRange = 0;
        protected int structureBlacklistRange = 0;
        protected Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet = new HashSet<RSStructureTagMap.STRUCTURE_TAGS>();
        protected int allowTerrainHeightRange = -1;
        protected int terrainHeightRadius = 0;
        protected int minHeightLimit = Integer.MIN_VALUE;
        protected int fixedYSpawn = 0;
        protected boolean useHeightmap = true;
        protected boolean cannotSpawnInWater = false;
        protected Set<class_2960> poolsThatIgnoreBounds;

        public Builder(class_2960 startPool) {
            this.startPool = startPool;
        }

        protected T getThis() {
            return (T)this;
        }

        public T setStructureSize(int structureSize) {
            this.structureSize = structureSize;
            return this.getThis();
        }

        public T setCenterOffset(int centerOffset) {
            this.centerOffset = centerOffset;
            return this.getThis();
        }

        public T setBiomeRange(int biomeRange) {
            this.biomeRange = biomeRange;
            return this.getThis();
        }

        public T setStructureBlacklistRange(int structureBlacklistRange) {
            this.structureBlacklistRange = structureBlacklistRange;
            return this.getThis();
        }

        public T setAvoidStructuresSet(Set<RSStructureTagMap.STRUCTURE_TAGS> avoidStructuresSet) {
            this.avoidStructuresSet = avoidStructuresSet;
            return this.getThis();
        }

        public T setAllowTerrainHeightRange(int allowTerrainHeightRange) {
            this.allowTerrainHeightRange = allowTerrainHeightRange;
            return this.getThis();
        }

        public T setTerrainHeightRadius(int terrainHeightRadius) {
            this.terrainHeightRadius = terrainHeightRadius;
            return this.getThis();
        }

        public T setMinHeightLimit(int minHeightLimit) {
            this.minHeightLimit = minHeightLimit;
            return this.getThis();
        }

        public T setFixedYSpawn(int fixedYSpawn) {
            this.fixedYSpawn = fixedYSpawn;
            return this.getThis();
        }

        public T doNotUseHeightmap() {
            this.useHeightmap = false;
            return this.getThis();
        }

        public T cannotSpawnInWater() {
            this.cannotSpawnInWater = true;
            return this.getThis();
        }

        public T setPoolsThatIgnoreBounds(Set<class_2960> poolsThatIgnoreBounds) {
            this.poolsThatIgnoreBounds = poolsThatIgnoreBounds;
            return this.getThis();
        }

        public GenericJigsawStructureCodeConfig build() {
            return new GenericJigsawStructureCodeConfig(this.startPool, this.structureSize, this.centerOffset, this.biomeRange, this.structureBlacklistRange, this.avoidStructuresSet, this.allowTerrainHeightRange, this.terrainHeightRadius, this.minHeightLimit, this.fixedYSpawn, this.useHeightmap, this.cannotSpawnInWater, this.poolsThatIgnoreBounds);
        }
    }
}

